/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.preview.viewer;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.media.MediaPlayer;
import android.os.Build;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.VideoView;
import net.aihelp.core.ui.glide.DrawableRequestBuilder;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.load.resource.drawable.GlideDrawable;
import net.aihelp.core.ui.glide.request.RequestListener;
import net.aihelp.core.ui.glide.request.target.Target;
import net.aihelp.core.util.viewer.PhotoView;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.preview.viewer.BasePreviewer;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;

public class VideoPreviewer
extends BasePreviewer {
    public static void previewVideo(Activity activity, PreviewInfo info) {
        if (activity == null || info == null || VideoPreviewer.isFileSizeExceeded(activity, info)) {
            return;
        }
        final PhotoView imageView = (PhotoView)activity.findViewById(ResResolver.getViewId("aihelp_image_view"));
        final ProgressBar progressBar = (ProgressBar)activity.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        final VideoView videoView = (VideoView)activity.findViewById(ResResolver.getViewId("aihelp_video_view"));
        imageView.enableGesture(false);
        imageView.setVisibility(0);
        progressBar.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 21) {
            progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)-1));
        }
        videoView.setBackgroundColor(0);
        videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                videoView.start();
                mp.setLooping(true);
                if (Build.VERSION.SDK_INT < 17) {
                    videoView.post(new Runnable(){

                        @Override
                        public void run() {
                            videoView.seekTo(0);
                            progressBar.setVisibility(8);
                            imageView.setVisibility(8);
                            videoView.setVisibility(0);
                        }
                    });
                }
            }
        });
        if (Build.VERSION.SDK_INT >= 17) {
            videoView.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                public boolean onInfo(MediaPlayer mp, int what, int extra) {
                    if (what == 3) {
                        videoView.seekTo(0);
                        progressBar.setVisibility(8);
                        imageView.setVisibility(8);
                        videoView.setVisibility(0);
                        return true;
                    }
                    return false;
                }
            });
        }
        String imagePath = MediaUtils.getImageForVideoSync(info.getFilePath());
        videoView.setVideoPath(info.getFilePath());
        ((DrawableRequestBuilder)Glide.with(activity).load(imagePath).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            @Override
            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                progressBar.setVisibility(0);
                return false;
            }

            @Override
            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                progressBar.post(new Runnable(){

                    @Override
                    public void run() {
                        videoView.setVisibility(0);
                    }
                });
                return false;
            }
        })).into((ImageView)imageView);
    }
}

