/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.webkit.WebView;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashSet;
import java.util.List;
import net.aihelp.utils.RomUtil;

public class WebViewUtil {
    public static void prepareDataDirectorySuffix(Context context) {
        if (Build.VERSION.SDK_INT < 28) {
            return;
        }
        try {
            String suffix;
            HashSet<String> pathSet = new HashSet<String>();
            String dataPath = context.getDataDir().getAbsolutePath();
            String webViewDir = "/app_webview";
            String huaweiWebViewDir = "/app_hws_webview";
            String lockFile = "/webview_data.lock";
            String processName = WebViewUtil.getCurProcessName(context);
            if (TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)processName)) {
                suffix = "_" + processName;
                pathSet.add(dataPath + webViewDir + lockFile);
                pathSet.add(dataPath + webViewDir + suffix + lockFile);
                if (RomUtil.isEmui()) {
                    pathSet.add(dataPath + huaweiWebViewDir + lockFile);
                    pathSet.add(dataPath + huaweiWebViewDir + suffix + lockFile);
                }
            } else {
                suffix = TextUtils.isEmpty((CharSequence)processName) ? context.getPackageName() : processName;
                WebView.setDataDirectorySuffix((String)suffix);
                suffix = "_" + suffix;
                pathSet.add(dataPath + webViewDir + suffix + lockFile);
                if (RomUtil.isEmui()) {
                    pathSet.add(dataPath + huaweiWebViewDir + suffix + lockFile);
                }
            }
            for (String path : pathSet) {
                File file = new File(path);
                if (!file.exists()) continue;
                WebViewUtil.tryLockOrRecreateFile(file);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TargetApi(value=28)
    private static void tryLockOrRecreateFile(File file) {
        try {
            FileLock tryLock = new RandomAccessFile(file, "rw").getChannel().tryLock();
            if (tryLock != null) {
                tryLock.close();
            } else {
                WebViewUtil.createFile(file, file.delete());
            }
        }
        catch (Exception ignored) {
            boolean deleted = false;
            if (file.exists()) {
                deleted = file.delete();
            }
            WebViewUtil.createFile(file, deleted);
        }
    }

    private static void createFile(File file, boolean deleted) {
        try {
            if (deleted && !file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCurProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess == null || appProcess.pid != pid) continue;
            return appProcess.processName;
        }
        return null;
    }
}

