/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import java.util.Iterator;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;
import org.json.JSONObject;

public class AIHelpEvaluateView
extends FrameLayout
implements View.OnClickListener {
    public static final int FAQ_TYPE_BOT_FAQ = 1;
    public static final int FAQ_TYPE_FAQ_DETAIL = 2;
    public static final int FAQ_TYPE_OPERATE_ARTICLE = 3;
    public static final int STATE_NORMAL = 1;
    public static final int STATE_INVISIBLE = 2;
    public static final int STATE_PLAIN_TEXT = 3;
    public static final int STATE_REQUESTING_FEEDBACK = 4;
    private int evaluateTarget = -1;
    private final ViewGroup mEvaluateFaqLayout;
    private final ViewGroup mAfterEvaluateLayout;
    private final AIHelpButton mTvAdvice;
    private final TextView mTvShowThanks;
    private OnAIHelpEvaluateViewCallback listener;
    private String title;
    private String mainId;
    private String contentId;

    public void setFaqData(String title, String mainId, String contentId) {
        this.title = title;
        this.mainId = mainId;
        this.contentId = contentId;
    }

    public void setEvaluateState(int evaluateState) {
        this.setVisibility(0);
        switch (evaluateState) {
            case 1: {
                break;
            }
            case 2: {
                this.setVisibility(8);
                break;
            }
            case 3: {
                this.mEvaluateFaqLayout.setVisibility(8);
                this.mAfterEvaluateLayout.setVisibility(0);
                this.mTvAdvice.setVisibility(8);
                Styles.reRenderTextView(this.mTvShowThanks, CustomConfig.CommonSetting.commonPositiveFeedbackHint, 0.5f);
                break;
            }
            case 4: {
                this.mEvaluateFaqLayout.setVisibility(8);
                this.mAfterEvaluateLayout.setVisibility(0);
                Styles.reRenderTextView(this.mTvShowThanks, CustomConfig.CommonSetting.commonNegativeFeedbackHint, 0.5f);
                this.mTvAdvice.setVisibility(CustomConfig.CommonSetting.isFaqUnhelpfulFeedbackEnable ? 0 : 8);
            }
        }
    }

    public void setOnAIHelpEvaluateViewCallback(OnAIHelpEvaluateViewCallback listener) {
        this.listener = listener;
    }

    public AIHelpEvaluateView(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpEvaluateView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpEvaluateView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int[] evaluateViewStyleable = ResResolver.getStyleable("aihelp_evaluate_view");
        if (evaluateViewStyleable != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, evaluateViewStyleable);
            this.evaluateTarget = typedArray.getInt(ResResolver.getStyleableFieldIndex("aihelp_evaluate_view", "aihelp_evaluate_target"), -1);
            typedArray.recycle();
        }
        View rootView = View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_evaluate_view"), (ViewGroup)this);
        this.mEvaluateFaqLayout = (ViewGroup)rootView.findViewById(ResResolver.getViewId("aihelp_ll_evaluate_faq"));
        AppCompatImageView unhelpfulView = (AppCompatImageView)rootView.findViewById(ResResolver.getViewId("aihelp_iv_un_helpful"));
        Styles.reRenderImageView((ImageView)unhelpfulView, "aihelp_svg_ic_un_helpful", true);
        AppCompatImageView helpfulView = (AppCompatImageView)rootView.findViewById(ResResolver.getViewId("aihelp_iv_helpful"));
        Styles.reRenderImageView((ImageView)helpfulView, "aihelp_svg_ic_helpful", true);
        this.mAfterEvaluateLayout = (ViewGroup)rootView.findViewById(ResResolver.getViewId("aihelp_ll_feedback"));
        this.mTvShowThanks = (TextView)rootView.findViewById(ResResolver.getViewId("aihelp_tv_thanks"));
        this.mTvAdvice = (AIHelpButton)rootView.findViewById(ResResolver.getViewId("aihelp_tv_advice"));
        this.mTvAdvice.setText(ResResolver.getString("aihelp_faq_feedback_suggest"));
        unhelpfulView.setOnClickListener((View.OnClickListener)this);
        helpfulView.setOnClickListener((View.OnClickListener)this);
        this.mTvAdvice.setOnClickListener(this);
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_iv_un_helpful")) {
            this.setEvaluateState(4);
            if (this.listener != null) {
                this.listener.onEvaluated(false);
            }
            if (this.evaluateTarget != 1) {
                AIHelpEventTracker.getInstance().markedUnhelpful(this.mainId, this.contentId, this.title);
            }
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_helpful")) {
            this.setEvaluateState(3);
            if (this.listener != null) {
                this.listener.onEvaluated(true);
            }
            if (this.evaluateTarget != 1) {
                AIHelpEventTracker.getInstance().markedHelpful(this.mainId, this.contentId, this.title);
            }
        }
        if (v.getId() == ResResolver.getViewId("aihelp_tv_advice")) {
            this.showAdviceAlert(v.getContext(), this.evaluateTarget, this.mainId);
        }
    }

    public void showAdviceAlert(final Context context, final int faqType, final String mainId) {
        final AlertDialog feedbackDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_advice")).setWidthByDevice().create();
        final EditText etFeedback = (EditText)feedbackDialog.getView(ResResolver.getViewId("aihelp_et_feedback"));
        TextView tvTitle = (TextView)feedbackDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        TextView tvCancel = (TextView)feedbackDialog.getView(ResResolver.getViewId("aihelp_tv_cancel"));
        final TextView tvConfirm = (TextView)feedbackDialog.getView(ResResolver.getViewId("aihelp_tv_confirm"));
        etFeedback.setHint((CharSequence)ResResolver.getString("aihelp_chat_hint"));
        tvTitle.setText((CharSequence)ResResolver.getString("aihelp_faq_feedback"));
        tvCancel.setText((CharSequence)ResResolver.getString("aihelp_no"));
        tvConfirm.setText((CharSequence)ResResolver.getString("aihelp_yes"));
        feedbackDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_cancel"), new View.OnClickListener(){

            public void onClick(View v) {
                feedbackDialog.dismiss();
            }
        });
        etFeedback.addTextChangedListener((TextWatcher)new TextWatcherWrapper(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                tvConfirm.setEnabled(!TextUtils.isEmpty((CharSequence)s.toString().trim()));
                tvConfirm.setAlpha(TextUtils.isEmpty((CharSequence)s) ? 0.5f : 1.0f);
            }
        });
        tvConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextUtils.isEmpty((CharSequence)etFeedback.getText().toString().trim())) {
                    ToastUtil.INSTANCE.makeRawToast(context, ResResolver.getString("aihelp_faq_feedback"));
                    return;
                }
                feedbackDialog.dismiss();
                AIHelpEvaluateView.this.postFeedbackOnFaq(faqType, mainId, AIHelpEvaluateView.this.contentId, etFeedback.getText().toString().trim(), String.valueOf(System.currentTimeMillis()));
                AIHelpEvaluateView.this.mTvAdvice.setVisibility(8);
                if (AIHelpEvaluateView.this.listener != null) {
                    AIHelpEvaluateView.this.listener.onFeedbackConfirmed();
                }
            }
        });
        feedbackDialog.show();
    }

    private void postFeedbackOnFaq(int faqType, final String mainId, final String contentId, final String feedbackMsg, String createTime) {
        JSONObject params = new JSONObject();
        try {
            params.put("Language", (Object)Const.CORRECT_LANGUAGE);
            params.put("PlayerId", (Object)String.format("%s|%s", Const.APP_ID, UserProfile.USER_ID));
            params.put("PlayerName", (Object)UserProfile.USER_NAME);
            params.put("FaqId", (Object)mainId);
            params.put("contentId", (Object)contentId);
            params.put("Message", (Object)feedbackMsg);
            params.put("Type", faqType);
            params.put("CreateTime", (Object)createTime);
            if (this.listener != null && this.listener.requestDataForFeedback() != null) {
                JSONObject dataForFeedback = this.listener.requestDataForFeedback();
                Iterator keys = dataForFeedback.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    params.put(key, (Object)dataForFeedback.optString(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AIHelpRequest.getInstance().requestPostByJson(API.FAQ_FEEDBACK_URL, params, new ReqCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                AIHelpEventTracker.getInstance().submitSuggestion(mainId, contentId, AIHelpEvaluateView.this.title, feedbackMsg);
            }
        });
    }

    public static abstract class OnAIHelpEvaluateViewCallback {
        public void onEvaluated(boolean isHelpful) {
        }

        public JSONObject requestDataForFeedback() {
            return null;
        }

        public void onFeedbackConfirmed() {
        }
    }
}

