/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import net.aihelp.common.CustomConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpFaqCardLayout
extends LinearLayout {
    private final RelativeLayout rlRoot;
    private final AppCompatImageView ivTitle;
    private final AppCompatTextView tvTitle;
    private final RecyclerView rvList;
    private RecyclerView.Adapter adapter;

    public AIHelpFaqCardLayout(Context context) {
        this(context, null);
    }

    public AIHelpFaqCardLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpFaqCardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_faq_card_layout"), (ViewGroup)this);
        this.rlRoot = (RelativeLayout)this.findViewById(ResResolver.getViewId("aihelp_rl_list"));
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        this.rlRoot.setBackground(Styles.getDrawable(colorFromHex, 15));
        this.ivTitle = (AppCompatImageView)this.findViewById(ResResolver.getViewId("aihelp_iv_title"));
        this.tvTitle = (AppCompatTextView)this.findViewById(ResResolver.getViewId("aihelp_tv_title"));
        this.tvTitle.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
        this.tvTitle.setTypeface(null, 1);
        this.rvList = (RecyclerView)this.findViewById(ResResolver.getViewId("aihelp_rv_list"));
    }

    private RecyclerView.LayoutManager getLinearLayoutManager(Context context) {
        return new LinearLayoutManager(context){

            public boolean canScrollVertically() {
                return Styles.isLandscape();
            }
        };
    }

    private RecyclerView.LayoutManager getGridLayoutManager(Context context) {
        final int spanCount = Styles.isLandscape() && !CustomConfig.HelpCenter.isFaqHotTopicVisible ? 4 : 3;
        GridLayoutManager manager = new GridLayoutManager(context, spanCount){

            public boolean canScrollVertically() {
                return Styles.isLandscape();
            }
        };
        if (Styles.isLandscape()) {
            manager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return position == AIHelpFaqCardLayout.this.adapter.getItemCount() - 1 ? spanCount : 1;
                }
            });
        }
        return manager;
    }

    public void setup(RecyclerView.Adapter adapter) {
        this.setup(true, adapter);
    }

    public void setup(boolean displayAsList, RecyclerView.Adapter adapter) {
        this.adapter = adapter;
        if (displayAsList) {
            this.rvList.setLayoutManager(this.getLinearLayoutManager(this.getContext()));
        } else {
            this.rvList.setLayoutManager(this.getGridLayoutManager(this.getContext()));
        }
        int rootPadding = displayAsList ? 0 : Styles.dpToPx(this.getContext(), 8.0f);
        this.rlRoot.setPadding(rootPadding, this.rlRoot.getPaddingTop(), rootPadding, this.rlRoot.getPaddingBottom());
        this.rvList.setAdapter(adapter);
    }

    public void updateTitleIcon(boolean visible, String iconUrl) {
        if (visible && !TextUtils.isEmpty((CharSequence)iconUrl)) {
            this.ivTitle.setVisibility(0);
            Styles.loadIcon((ImageView)this.ivTitle, iconUrl);
        }
    }

    public void updateTitleText(boolean visible, String title) {
        if (visible && !TextUtils.isEmpty((CharSequence)title)) {
            this.tvTitle.setVisibility(0);
            Styles.reRenderTextView((TextView)this.tvTitle, title);
        }
    }
}

