/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.animation.LayoutTransition;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.loading.indicator.LoadingIndicatorView;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpLoadingImageView
extends FrameLayout {
    private AppCompatImageView imageView;
    private AppCompatImageView ivPlay;
    private View maskView;
    private LoadingIndicatorView loadingView;
    private boolean isVideo;
    private boolean isLoading;

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean loading) {
        this.isLoading = loading;
    }

    public boolean isVideo() {
        return this.isVideo;
    }

    public void setVideo(boolean video) {
        this.isVideo = video;
    }

    public AppCompatImageView getRealImageView() {
        return this.imageView;
    }

    public AIHelpLoadingImageView(@NonNull Context context) {
        super(context);
    }

    public AIHelpLoadingImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.getAttributes(context, attrs);
        this.init(context);
    }

    public AIHelpLoadingImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttributes(context, attrs);
        this.init(context);
    }

    private void getAttributes(Context context, AttributeSet attrs) {
        int[] styleable = ResResolver.getStyleable("aihelp_widget");
        if (styleable != null) {
            TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, styleable, 0, 0);
            this.isVideo = ta.getBoolean(ResResolver.getStyleableFieldIndex("aihelp_widget", "aihelp_widget_is_video"), false);
            ta.recycle();
        }
    }

    private void init(Context context) {
        this.setLayoutTransition(new LayoutTransition());
        this.setBackground(AppCompatResources.getDrawable((Context)context, (int)ResResolver.getDrawableId("aihelp_bg_uploading_mask")));
        this.setForegroundGravity(17);
        View rootView = AIHelpLoadingImageView.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_loading_image_view"), (ViewGroup)this);
        this.imageView = (AppCompatImageView)rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        this.ivPlay = (AppCompatImageView)rootView.findViewById(ResResolver.getViewId("aihelp_iv_play"));
        this.maskView = rootView.findViewById(ResResolver.getViewId("aihelp_v_mask"));
        this.loadingView = (LoadingIndicatorView)rootView.findViewById(ResResolver.getViewId("aihelp_loading_view"));
        this.updateLoadingStatus(true);
    }

    public void resetStatus() {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.width = Styles.dpToPx(this.getContext(), 100.0f);
        layoutParams.height = Styles.dpToPx(this.getContext(), 150.0f);
        this.setLayoutParams(layoutParams);
        this.updateLoadingStatus(true);
    }

    public void updateLoadingStatus(boolean showLoading) {
        this.maskView.setVisibility(showLoading ? 0 : 8);
        this.loadingView.setVisibility(showLoading ? 0 : 8);
        if (this.isVideo) {
            this.ivPlay.setVisibility(showLoading ? 8 : 0);
        }
        this.setLoading(showLoading);
    }

    public void loadIntoImageView(Context context, final FileMessage message) {
        if (context instanceof Activity && !((Activity)context).isFinishing()) {
            String loadSource = DomainSupportHelper.getAdjustedUrl(this.isVideo ? message.getVideoThumbnail() : message.getContent());
            if (message.getImageSize() != null) {
                Glide.with(this.getContext()).load(loadSource).into((ImageView)this.imageView);
                ViewGroup.LayoutParams rootLayoutParams = this.getLayoutParams();
                ViewGroup.LayoutParams params = this.imageView.getLayoutParams();
                rootLayoutParams.width = params.width = message.getImageSize()[0];
                rootLayoutParams.height = params.height = message.getImageSize()[1];
                this.setLayoutParams(rootLayoutParams);
                this.imageView.setLayoutParams(params);
                this.updateLoadingStatus(false);
                return;
            }
            this.resetStatus();
            MediaUtils.scaleImageView(loadSource, (ImageView)this.imageView, (View)this, new MediaUtils.OnImageScaledListener(){

                @Override
                public void onImageScaled() {
                    if (message.getImageSize() == null) {
                        ViewGroup.LayoutParams params = AIHelpLoadingImageView.this.getLayoutParams();
                        int[] size = new int[]{params.width, params.height};
                        message.setImageSize(size);
                    }
                    AIHelpLoadingImageView.this.updateLoadingStatus(false);
                }
            });
        }
    }

    public int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * (double)density + 0.5);
    }

    public void showPlayButton(boolean show) {
        this.ivPlay.setVisibility(show ? 0 : 8);
    }
}

