/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import net.aihelp.common.CustomConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpRatingBar
extends View {
    private Bitmap mFocusedDrawable;
    private Bitmap mUnfocusedDrawable;
    private int mSpacing;
    private int mGradeLevel;
    private int mCurrGrade;
    private int mStarWidth = 30;
    private int mStarHeight = 30;
    private OnStatusChangedListener mListener;

    public int getSelectGrade() {
        return this.mCurrGrade;
    }

    public boolean isFullStar() {
        return this.mCurrGrade == this.mGradeLevel;
    }

    public AIHelpRatingBar(Context context) {
        this(context, null);
    }

    public AIHelpRatingBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int[] styleable = ResResolver.getStyleable("aihelp_rating_bar");
        if (styleable != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, styleable);
            int focusedResourceId = typedArray.getResourceId(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_focused"), ResResolver.getDrawableId("aihelp_svg_star_selected"));
            int unfocusedResourceId = typedArray.getResourceId(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_unfocused"), ResResolver.getDrawableId("aihelp_svg_star_unselected"));
            this.mSpacing = typedArray.getDimensionPixelSize(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_horizontal_spacing"), this.dip2px(context, 27.0));
            this.mGradeLevel = typedArray.getInt(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_grade_level"), 5);
            this.mCurrGrade = typedArray.getInt(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_default_grade"), this.mGradeLevel);
            typedArray.recycle();
            if (focusedResourceId != 0) {
                this.mFocusedDrawable = AIHelpRatingBar.getDrawableBitmap(context, focusedResourceId, Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            }
            if (unfocusedResourceId != 0) {
                this.mUnfocusedDrawable = AIHelpRatingBar.getDrawableBitmap(context, unfocusedResourceId, Styles.getColorWithAlpha(CustomConfig.CommonSetting.highlightedColor, (double)0.2f));
            }
            if (this.mFocusedDrawable != null) {
                this.mStarWidth = this.mFocusedDrawable.getWidth();
                this.mStarHeight = this.mFocusedDrawable.getHeight();
            }
        }
    }

    protected int dip2px(Context context, double dpValue) {
        if (context == null) {
            return (int)dpValue;
        }
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * (double)density + 0.5);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.mStarWidth * this.mGradeLevel + this.mSpacing * (this.mGradeLevel - 1);
        int height = this.mStarHeight;
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mFocusedDrawable == null || this.mUnfocusedDrawable == null) {
            return;
        }
        if (Styles.isLayoutRtl(this)) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        for (int i = 0; i < this.mGradeLevel; ++i) {
            int x = this.mStarWidth * i;
            if (i > 0) {
                x = this.mStarWidth * i + this.mSpacing * i;
            }
            if (this.mCurrGrade > i) {
                canvas.drawBitmap(this.mFocusedDrawable, (float)x, 0.0f, null);
                continue;
            }
            canvas.drawBitmap(this.mUnfocusedDrawable, (float)x, 0.0f, null);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mFocusedDrawable == null || this.mUnfocusedDrawable == null) {
            return true;
        }
        if (Styles.isLayoutRtl(this)) {
            event.setLocation((float)this.getWidth() - event.getX(), event.getY());
        }
        switch (event.getAction()) {
            case 1: 
            case 2: {
                int currGrade;
                float eventX = event.getX();
                if (eventX < 0.0f) {
                    eventX = 0.0f;
                }
                if ((currGrade = (int)(eventX / (float)(this.mFocusedDrawable.getWidth() + this.mSpacing)) + 1) < 0) {
                    currGrade = 1;
                } else if (currGrade > this.mGradeLevel) {
                    currGrade = this.mGradeLevel;
                }
                if (this.mCurrGrade == currGrade) {
                    return true;
                }
                this.mCurrGrade = currGrade;
                if (this.mListener != null) {
                    this.mListener.onRateStatusChanged(this.mCurrGrade);
                }
                this.invalidate();
            }
        }
        return true;
    }

    public static Bitmap getDrawableBitmap(Context context, int resId, int color) {
        VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)context.getResources(), (int)resId, null);
        if (drawable != null) {
            DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable).mutate(), (int)color);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public void setOnStatusChangedListener(OnStatusChangedListener mListener) {
        this.mListener = mListener;
    }

    public static interface OnStatusChangedListener {
        public void onRateStatusChanged(int var1);
    }
}

