/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NewMessageArrivedEvent;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpServiceEntrance
extends RelativeLayout {
    View vNotification;

    public AIHelpServiceEntrance(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_service_entrance"), (ViewGroup)this);
        AIHelpButton tvEntrance = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_tv_entrance"));
        tvEntrance.setText(CustomConfig.HelpCenter.faqCSEntranceText);
        this.vNotification = this.findViewById(ResResolver.getViewId("aihelp_v_unread_status"));
        this.vNotification.setBackground(Styles.getDrawable(Color.parseColor((String)"#FF4747"), 999));
        this.vNotification.setVisibility(8);
        this.updateEntranceStatus(false, false);
    }

    public void setup(Bundle bundle, IFaqEventListener faqEventListener, BaseFaqFragment faqFragment) {
        if (bundle != null && faqEventListener != null) {
            this.updateViewVisibility(bundle, faqFragment);
            this.updateViewClickEvent(bundle, faqEventListener, faqFragment);
        }
    }

    public void updateViewVisibility(Bundle bundle, BaseFaqFragment faqFragment) {
        if (TicketStatusTracker.hasUnreadMsg) {
            this.updateEntranceStatus(true, true);
        } else if (TicketStatusTracker.isTicketActive) {
            this.updateEntranceStatus(true, false);
        } else if (bundle != null && faqFragment != null) {
            String entrances = bundle.getString("faq_support_moment", "");
            boolean visibleInFaqHome = faqFragment instanceof FaqHomeFragment && entrances.contains("1");
            boolean visibleInFaqList = faqFragment instanceof FaqListFragment && entrances.contains("2");
            boolean visibleInFaqContent = faqFragment instanceof FaqContentFragment && entrances.contains("3");
            this.updateEntranceStatus(visibleInFaqHome || visibleInFaqList || visibleInFaqContent, false);
        }
    }

    private void updateEntranceStatus(boolean entranceVisible, boolean notificationVisible) {
        if (entranceVisible) {
            this.setVisibility(0);
            this.vNotification.setVisibility(notificationVisible ? 0 : 8);
        } else {
            this.setVisibility(8);
        }
    }

    private void updateViewClickEvent(final Bundle bundle, final IFaqEventListener faqEventListener, final BaseFaqFragment faqFragment) {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AIHelpServiceEntrance.this.onIntentToCustomerService(bundle, faqEventListener, faqFragment);
            }
        });
    }

    public void onIntentToCustomerService(Bundle bundle, IFaqEventListener faqEventListener, BaseFaqFragment faqFragment) {
        if (bundle != null && faqEventListener != null && faqFragment != null) {
            this.updateEntranceStatus(true, false);
            faqEventListener.onIntentToCustomerService(bundle, true);
            String faqContentVisitId = "";
            if (faqFragment instanceof FaqContentFragment) {
                FaqContentFragment faqContentFragment = (FaqContentFragment)faqFragment;
                faqContentVisitId = faqContentFragment.hashCode() + "";
            }
            AIHelpEventTracker.getInstance().clickServiceEntrance(faqContentVisitId);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register((Object)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof NewMessageArrivedEvent) {
            this.updateViewVisibility(null, null);
        }
    }
}

