/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class CircleProgressView
extends View {
    private int mOuterColor = -7829368;
    private int mInnerColor = -1;
    private int mBorderWidth = 18;
    private int mStepTextSize;
    private int mStepTextColor;
    private Paint mOutPaint = new Paint();
    private Paint mInnerPaint;
    private Paint mTextPaint;
    private int mStepMax = 100;
    private int mCurrentStep = 0;

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mOutPaint.setAntiAlias(true);
        this.mOutPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mOutPaint.setColor(this.mOuterColor);
        this.mOutPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mOutPaint.setStyle(Paint.Style.STROKE);
        this.mInnerPaint = new Paint();
        this.mInnerPaint.setAntiAlias(true);
        this.mInnerPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mInnerPaint.setColor(this.mInnerColor);
        this.mInnerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mInnerPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.mStepTextColor);
        this.mTextPaint.setTextSize((float)this.mStepTextSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width > height ? height : width, width > height ? height : width);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF rectF = new RectF((float)(this.mBorderWidth / 2), (float)(this.mBorderWidth / 2), (float)(this.getWidth() - this.mBorderWidth / 2), (float)(this.getHeight() - this.mBorderWidth / 2));
        canvas.drawArc(rectF, -90.0f, 360.0f, false, this.mOutPaint);
        if (this.mStepMax == 0) {
            return;
        }
        float sweepAngle = (float)this.mCurrentStep / (float)this.mStepMax;
        canvas.drawArc(rectF, -90.0f, sweepAngle * 360.0f, false, this.mInnerPaint);
        String stepText = this.mCurrentStep + "";
        Rect textBounds = new Rect();
        this.mTextPaint.getTextBounds(stepText, 0, stepText.length(), textBounds);
        int dx = this.getWidth() / 2 - textBounds.width() / 2;
        Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
        int dy = (fontMetrics.bottom - fontMetrics.top) / 2 - fontMetrics.bottom;
        int baseLine = this.getHeight() / 2 + dy;
        canvas.drawText(stepText, (float)dx, (float)baseLine, this.mTextPaint);
    }

    public synchronized void setStepMax(int stepMax) {
        this.mStepMax = stepMax;
    }

    public synchronized void setCurrentStep(int currentStep) {
        this.mCurrentStep = currentStep;
        this.invalidate();
    }
}

