/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class PieProgressView
extends View {
    private int maxProgress = 100;
    private int currentProgress = 0;
    private int cx;
    private int cy;
    private int radiusCircle;
    private int ovalCircle;
    Paint p;
    RectF rf;
    private int gap = 7;

    public PieProgressView(Context context) {
        super(context);
        this.init(context);
    }

    public PieProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PieProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.p = new Paint();
        this.p.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = this.getMeasuredWidth();
        int h = this.getMeasuredHeight();
        this.radiusCircle = w > h ? h / 2 : w / 2 - PieProgressView.dip2px(this.getContext(), 1.0f);
        this.ovalCircle = this.radiusCircle - this.gap;
        this.cx = w / 2;
        this.cy = h / 2;
        this.rf = new RectF((float)(this.cx - this.ovalCircle), (float)(this.cy - this.ovalCircle), (float)(this.cx + this.ovalCircle), (float)(this.cy + this.ovalCircle));
    }

    public void setProgress(int progress) {
        this.currentProgress = progress;
        this.invalidate();
    }

    public void setMaxProgress(int max) {
        this.maxProgress = max;
        this.invalidate();
    }

    public int getProgress() {
        return this.currentProgress;
    }

    public int getMax() {
        return this.maxProgress;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.p.reset();
        this.p.setColor(-1);
        this.p.setColor(-65536);
        this.p.setStyle(Paint.Style.STROKE);
        this.p.setStrokeWidth((float)PieProgressView.dip2px(this.getContext(), 1.0f));
        canvas.drawCircle((float)this.cx, (float)this.cy, (float)this.radiusCircle, this.p);
        this.p.setStyle(Paint.Style.FILL);
        canvas.drawArc(this.rf, -90.0f, (float)this.currentProgress * 360.0f / (float)this.maxProgress, true, this.p);
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

