/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import net.aihelp.common.Const;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.RegexDefinition;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AppInfoUtil {
    public static String getAppName(Context context) {
        String appName = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = context.getApplicationInfo();
            appName = pm.getApplicationLabel(ai).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appName == null ? "AIHelp" : appName;
    }

    public static String getAppVersion(Context context) {
        if (context == null) {
            return "Context is null!";
        }
        String appVersion = null;
        try {
            String packageName = context.getPackageName();
            PackageInfo p = context.getPackageManager().getPackageInfo(packageName, 0);
            appVersion = p.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appVersion;
    }

    public static Intent getLaunchIntent(Context context, String packageName) {
        Intent launchIntentForPackage = null;
        try {
            PackageManager pm = context.getPackageManager();
            launchIntentForPackage = pm.getLaunchIntentForPackage(packageName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return launchIntentForPackage;
    }

    public static void goRateApp(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("market://details?id=" + context.getPackageName())));
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(intent);
        } else {
            intent.setData(Uri.parse((String)("https://play.google.com/store/apps/details?id=" + context.getPackageName())));
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent);
            }
        }
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    public static boolean isUrlStillNeedResponding(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url) || !AppInfoUtil.validateNetwork(context)) {
            return false;
        }
        if (url.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null) {
            if (FastClickValidator.validate(0.5f)) {
                Const.sOnSpecificUrlClickedListener.onSpecificUrlClicked(url);
            }
            return false;
        }
        if (context != null && !url.startsWith("http")) {
            AppInfoUtil.openWithBrowser(context, url);
            return false;
        }
        return true;
    }

    public static void openWithBrowser(Context context, String url) {
        if (RegexDefinition.isLocalFile(url)) {
            return;
        }
        try {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                if (context instanceof Activity) {
                    context.startActivity(intent);
                } else {
                    intent.setFlags(0x10000000);
                    context.getApplicationContext().startActivity(intent);
                }
            } else {
                intent = Intent.parseUri((String)url, (int)1);
                if (intent != null) {
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setComponent(null);
                    intent.setSelector(null);
                    PackageManager packageManager = context.getPackageManager();
                    ResolveInfo info = packageManager.resolveActivity(intent, 65536);
                    if (info != null) {
                        context.startActivity(intent);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return true;
        }
        Context applicationContext = context.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = connectivityManager.getActiveNetwork();
            if (network == null) {
                return false;
            }
            NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
            return capabilities != null && (capabilities.hasCapability(12) || capabilities.hasTransport(0) || capabilities.hasTransport(1) || capabilities.hasTransport(3) || capabilities.hasTransport(4));
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean validateNetwork(Context context) {
        boolean isAvailable = AppInfoUtil.isNetworkAvailable(context);
        if (!isAvailable) {
            ToastUtil.INSTANCE.makeRawToast(context, ResResolver.getString("aihelp_network_no_connect"));
        }
        return isAvailable;
    }
}

