/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import androidx.annotation.RestrictTo;
import java.util.Locale;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.SpUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LocaleUtil {
    public static Locale getLocale() {
        Context aiHelpContext = AIHelpContext.getInstance().getContext();
        if (aiHelpContext != null) {
            Resources resources = aiHelpContext.getResources();
            Configuration configuration = resources.getConfiguration();
            return Build.VERSION.SDK_INT >= 24 ? configuration.getLocales().get(0) : configuration.locale;
        }
        return Locale.getDefault();
    }

    public static void updateLocale(Locale locale) {
        Context aiHelpContext = AIHelpContext.getInstance().getContext();
        if (aiHelpContext != null) {
            Resources resources = aiHelpContext.getResources();
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            Configuration configuration = resources.getConfiguration();
            configuration.locale = locale;
            resources.updateConfiguration(configuration, displayMetrics);
        }
    }

    public static String getSDKLanguage() {
        String sdkLanguage = SpUtil.getInstance().getString("sp_sdk_language");
        return TextUtils.isEmpty((CharSequence)sdkLanguage) ? "" : sdkLanguage;
    }

    public static Locale getCurrentLocale(String language) {
        Locale locale;
        if (TextUtils.isEmpty((CharSequence)language)) {
            locale = Locale.getDefault();
        } else if (language.contains("-")) {
            String[] languageArray = language.split("-");
            locale = new Locale(languageArray[0], languageArray[1]);
        } else {
            locale = new Locale(language);
        }
        return locale;
    }

    public static String getFormatLanguage(String language) {
        if (TextUtils.isEmpty((CharSequence)language)) {
            language = "en";
        } else if (language.equalsIgnoreCase("in_id") || language.equalsIgnoreCase("in") || language.equalsIgnoreCase("id")) {
            language = "id";
        } else if (language.equalsIgnoreCase("zh")) {
            language = "zh-CN";
        }
        return LocaleUtil.filterSymbol(language);
    }

    private static String filterSymbol(String language) {
        String tempLanguage = "en";
        if (!TextUtils.isEmpty((CharSequence)language)) {
            tempLanguage = language;
            if (tempLanguage.contains("_")) {
                tempLanguage = tempLanguage.replace("_", "-");
            }
            if (tempLanguage.contains("#")) {
                tempLanguage = tempLanguage.replace("#", "");
            }
        }
        return tempLanguage;
    }
}

