/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.RestrictTo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.request.animation.GlideAnimation;
import net.aihelp.core.ui.glide.request.target.SimpleTarget;
import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.RegexDefinition;
import net.aihelp.utils.Styles;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MediaUtils {
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;

    public static void scaleImageView(String source, final ImageView targetView, final View paramsView, final OnImageScaledListener listener) {
        if (targetView == null || paramsView == null || TextUtils.isEmpty((CharSequence)source)) {
            return;
        }
        final String adjustedSource = DomainSupportHelper.getAdjustedUrl(source);
        final Context context = targetView.getContext();
        Glide.with(context).load(adjustedSource).asBitmap().into(new SimpleTarget<Bitmap>(){

            @Override
            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                Glide.with(context).load(adjustedSource).into(targetView);
                ViewGroup.LayoutParams params = paramsView.getLayoutParams();
                int[] size = BitmapHelper.computeSize(resource.getWidth(), resource.getHeight());
                params.width = Math.max(size[0], Styles.dpToPx(context, 50.0f));
                params.height = Math.max(size[1], Styles.dpToPx(context, 50.0f));
                paramsView.setLayoutParams(params);
                if (listener != null) {
                    listener.onImageScaled();
                }
            }
        });
    }

    public static File getOutputMediaFile(String urlPath) {
        Context context = AIHelpContext.getInstance().getContext();
        if (context != null) {
            File mediaStorageDir = new File(context.getExternalCacheDir() + "/aihelp/image");
            if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
                return null;
            }
            String fileName = "IMG_" + System.currentTimeMillis() + ".jpg";
            if (!TextUtils.isEmpty((CharSequence)urlPath)) {
                int lastSeparator = urlPath.lastIndexOf("/");
                int extensionIndex = urlPath.lastIndexOf(".");
                if (lastSeparator != -1 && extensionIndex != -1 && lastSeparator < extensionIndex) {
                    fileName = urlPath.substring(lastSeparator + 1, extensionIndex) + ".jpg";
                }
            }
            return new File(mediaStorageDir.getPath() + File.separator + fileName);
        }
        return null;
    }

    public static void getImageForVideo(String videoPath, OnLoadVideoImageListener listener) {
        LoadVideoImageTask task = new LoadVideoImageTask(listener);
        task.execute(new String[]{videoPath});
    }

    public static String getImageForVideoSync(String videoPath) {
        File thumbnail = MediaUtils.getVideoThumbnail(videoPath);
        return thumbnail != null ? thumbnail.getAbsolutePath() : "";
    }

    private static File getVideoThumbnail(String videoPath) {
        try {
            File mediaFile = MediaUtils.getOutputMediaFile(videoPath);
            if (mediaFile != null && mediaFile.exists()) {
                return mediaFile;
            }
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            if (RegexDefinition.isLocalMediaFile(videoPath)) {
                mmr.setDataSource(videoPath);
            } else {
                mmr.setDataSource(videoPath, new HashMap());
            }
            Bitmap bitmap = mmr.getFrameAtTime();
            if (mediaFile != null) {
                try {
                    FileOutputStream out = new FileOutputStream(mediaFile);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            mmr.release();
            return mediaFile;
        }
        catch (Exception e) {
            return new File(videoPath);
        }
    }

    public static interface OnImageScaledListener {
        public void onImageScaled();
    }

    public static interface OnLoadVideoImageListener {
        public void onLoadImage(File var1);
    }

    public static class LoadVideoImageTask
    extends AsyncTask<String, Integer, File> {
        private OnLoadVideoImageListener listener;

        public LoadVideoImageTask(OnLoadVideoImageListener listener) {
            this.listener = listener;
        }

        protected File doInBackground(String ... params) {
            return MediaUtils.getVideoThumbnail(params[0]);
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.listener != null) {
                this.listener.onLoadImage(file);
            }
        }
    }
}

