/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.glide.DrawableRequestBuilder;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Styles {
    public static void reRenderTextView(TextView targetView, String text) {
        Styles.reRenderTextView(targetView, text, true);
    }

    public static void reRenderTextView(TextView targetView, String text, boolean visible) {
        Styles.reRenderTextView(targetView, text, Color.parseColor((String)CustomConfig.CommonSetting.textColor), visible, 15);
    }

    public static void reRenderTextView(TextView targetView, String text, float alpha) {
        Styles.reRenderTextView(targetView, text, Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)alpha));
    }

    public static void reRenderTextView(TextView targetView, String text, int color) {
        Styles.reRenderTextView(targetView, text, color, true, 15);
    }

    public static void reRenderTextView(TextView targetView, String text, int color, boolean visible, int textSize) {
        if (targetView != null) {
            targetView.setVisibility(visible ? 0 : 8);
            targetView.setText((CharSequence)text);
            targetView.setTextColor(color);
            targetView.setTextSize((float)textSize);
            if (targetView instanceof EditText) {
                EditText editText = (EditText)targetView;
                editText.setText((CharSequence)"");
                editText.setHint((CharSequence)text);
                editText.setHintTextColor(Styles.getColorWithAlpha(Styles.getHexColor(color), (double)0.35f));
            }
        }
    }

    public static StateListDrawable getClickableDrawableForList() {
        int upperBackgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        return Styles.getClickableDrawable(upperBackgroundColor, 0, 0);
    }

    public static StateListDrawable getClickableDrawableForButton() {
        int buttonColor = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
        return Styles.getClickableDrawable(buttonColor, buttonColor, 8);
    }

    public static StateListDrawable getClickableDrawable(int anchorColor, int normalBgColor, int cornerRadius) {
        StateListDrawable drawable = new StateListDrawable();
        int pressedBgColor = Styles.getColorWithAlpha(Styles.isLightColor(anchorColor) ? -16777216 : -1, 0.1);
        drawable.addState(new int[]{16842919}, Styles.getDrawable(pressedBgColor, cornerRadius));
        drawable.addState(new int[]{-16842919}, Styles.getDrawable(normalBgColor, cornerRadius));
        return drawable;
    }

    public static Drawable getClickableDrawable(Context context, String svgResource, int color, boolean clickable) {
        StateListDrawable drawable = new StateListDrawable();
        int drawableId = ResResolver.getDrawableId(svgResource);
        if (drawableId != 0) {
            VectorDrawableCompat normalDrawable = VectorDrawableCompat.create((Resources)context.getResources(), (int)drawableId, null);
            if (normalDrawable != null) {
                DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)normalDrawable).mutate(), (int)Styles.getColorWithAlpha(color, 1.0));
            }
            drawable.addState(new int[]{-16842919}, (Drawable)normalDrawable);
            if (clickable) {
                VectorDrawableCompat pressedDrawable = VectorDrawableCompat.create((Resources)context.getResources(), (int)drawableId, null);
                if (pressedDrawable != null) {
                    DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)pressedDrawable).mutate(), (int)Styles.getColorWithAlpha(color, (double)0.7f));
                }
                drawable.addState(new int[]{16842919}, (Drawable)pressedDrawable);
            }
        }
        return drawable;
    }

    public static ColorStateList getClickableTextColor(String color) {
        return Styles.getClickableTextColor(Color.parseColor((String)color));
    }

    public static ColorStateList getClickableTextColor(int color) {
        int[][] states = new int[][]{{16842919}, new int[0]};
        int[] colors = new int[]{Styles.getColorWithAlpha(color, (double)0.8f), Styles.getColorWithAlpha(color, 1.0)};
        return new ColorStateList((int[][])states, colors);
    }

    public static void loadIcon(ImageView targetView, String iconResource) {
        Styles.loadIcon(targetView, iconResource, true);
    }

    public static void loadIcon(ImageView targetView, String iconResource, boolean visible) {
        Styles.loadIcon(targetView, iconResource, visible, "aihelp_svg_ic_placeholder");
    }

    public static void loadIcon(ImageView targetView, String iconResource, boolean visible, String placeHolderRes) {
        try {
            if (targetView != null) {
                targetView.setVisibility(visible ? 0 : 8);
                Context context = targetView.getContext();
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    TLog.d("You cannot start a load for a destroyed activity, interrupt current invoke.");
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)iconResource)) {
                    Drawable placeholderDrawable = AppCompatResources.getDrawable((Context)context, (int)ResResolver.getDrawableId(placeHolderRes));
                    String adjustedUrl = DomainSupportHelper.getAdjustedUrl(iconResource);
                    ((DrawableRequestBuilder)Glide.with(context).load(adjustedUrl).placeholder(placeholderDrawable)).into(targetView);
                    if (Build.VERSION.SDK_INT >= 17 && context.getResources().getConfiguration().getLayoutDirection() == 1) {
                        targetView.setScaleX(-1.0f);
                    }
                } else {
                    targetView.setImageDrawable(AppCompatResources.getDrawable((Context)context, (int)ResResolver.getDrawableId(placeHolderRes)));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void reRenderImageView(ImageView targetView, String svgResource, boolean clickable) {
        Styles.reRenderImageView(targetView, svgResource, Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), clickable);
    }

    public static void reRenderImageView(ImageView targetView, String svgResource) {
        Styles.reRenderImageView(targetView, svgResource, false);
    }

    public static void reRenderImageView(ImageView targetView, String svgResource, int color) {
        Styles.reRenderImageView(targetView, svgResource, color, false);
    }

    public static void reRenderImageView(ImageView targetView, String svgResource, int color, boolean clickable) {
        try {
            int drawableId = ResResolver.getDrawableId(svgResource);
            if (targetView != null && drawableId != 0) {
                Context context = targetView.getContext();
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    TLog.d("You cannot start a load for a destroyed activity, interrupt current invoke.");
                    return;
                }
                targetView.setImageDrawable(Styles.getClickableDrawable(context, svgResource, color, clickable));
                if (Build.VERSION.SDK_INT >= 17 && context.getResources().getConfiguration().getLayoutDirection() == 1) {
                    targetView.setScaleX(-1.0f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isLandscape() {
        return CustomConfig.CommonSetting.isLandscape;
    }

    public static int getScreenWidth(Context context) {
        int widthPixels = context.getResources().getDisplayMetrics().widthPixels;
        int heightPixels = context.getResources().getDisplayMetrics().heightPixels;
        int screenWidth = Math.min(widthPixels, heightPixels);
        int screenHeight = Math.max(widthPixels, heightPixels);
        return Styles.isLandscape() ? screenHeight : screenWidth;
    }

    public static int getScreenHeight(Context context) {
        int widthPixels = context.getResources().getDisplayMetrics().widthPixels;
        int heightPixels = context.getResources().getDisplayMetrics().heightPixels;
        int screenWidth = Math.min(widthPixels, heightPixels);
        int screenHeight = Math.max(widthPixels, heightPixels);
        return Styles.isLandscape() ? screenWidth : screenHeight;
    }

    public static int getColorFromAttr(Context context, int attribute) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attribute});
        int color = typedArray.getColor(0, -1);
        typedArray.recycle();
        return color;
    }

    public static int getColor(Context context, int color) {
        return context.getResources().getColor(color);
    }

    public static String getHexColor(Context context, int attribute) {
        return Styles.getHexColor(Styles.getColor(context, attribute));
    }

    public static String getHexColor(int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }

    public static boolean isLightColor(int color) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / 255.0;
        return darkness < 0.5;
    }

    public static int getColor(String colorString) {
        return Styles.getColorWithAlpha(colorString, 1.0);
    }

    public static int getColorWithAlpha(int color, double alpha) {
        try {
            float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float green = (float)((color & 0xFF00) >> 8) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            return Styles.argb(alpha, red, green, blue);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getColorWithAlpha(String colorString, double alpha) {
        return Styles.getColorWithAlpha(Color.parseColor((String)colorString), alpha);
    }

    public static int[] getColorRGB(String colorString) {
        int color = Color.parseColor((String)colorString);
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        return new int[]{red, green, blue};
    }

    public static int argb(double alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0 + 0.5) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public static void setColorFilter(Context context, Drawable drawable, int attr2) {
        if (drawable != null) {
            drawable.setColorFilter(Styles.getColor(context, attr2), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static void setColorFilter(Drawable drawable, int color) {
        if (drawable != null) {
            drawable.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static int dpToPx(Context context, float dp) {
        if (context == null) {
            return 0;
        }
        return (int)(dp * context.getResources().getDisplayMetrics().density);
    }

    public static int px2dp(Context context, float pxVal) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxVal / scale + 0.5f);
    }

    public static StateListDrawable makeSelector(Context context) {
        VectorDrawableCompat uncheckedDrawable;
        StateListDrawable res = new StateListDrawable();
        VectorDrawableCompat checkedDrawable = VectorDrawableCompat.create((Resources)context.getResources(), (int)ResResolver.getDrawableId("aihelp_svg_ic_bill_checked"), null);
        if (checkedDrawable != null) {
            DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)checkedDrawable).mutate(), (int)Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        }
        if ((uncheckedDrawable = VectorDrawableCompat.create((Resources)context.getResources(), (int)ResResolver.getDrawableId("aihelp_svg_ic_bill_unchecked"), null)) != null) {
            DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)uncheckedDrawable).mutate(), (int)Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.3));
        }
        res.addState(new int[]{0x10100A0}, (Drawable)checkedDrawable);
        res.addState(new int[0], (Drawable)uncheckedDrawable);
        return res;
    }

    public static Drawable getDrawable(int color, int cornerRadius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadius((float)cornerRadius);
        drawable.setColor(color);
        return drawable;
    }

    public static Drawable getDrawableWithCorner(int color, int topLeft, int topRight, int bottomRight, int bottomLeft) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadii(new float[]{topLeft, topLeft, topRight, topRight, bottomRight, bottomRight, bottomLeft, bottomLeft});
        drawable.setColor(color);
        return drawable;
    }

    public static Drawable getDrawableWithStroke(Context context, int cornerRadius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.mutate();
        drawable.setCornerRadius((float)cornerRadius);
        drawable.setColor(0);
        drawable.setStroke(Styles.dpToPx(context, 1.0f), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        return drawable;
    }

    public static void setGradientBackground(@NonNull View view, int startColor, int endColor, GradientDrawable.Orientation orientation) {
        int[] colors = new int[]{startColor, endColor};
        GradientDrawable gradientDrawable = new GradientDrawable(orientation, colors);
        ViewCompat.setBackground((View)view, (Drawable)gradientDrawable);
    }

    public static FaqContentEntity getFAQWithHighlightedSearchTerms(Context context, FaqContentEntity faq, String searchTerms) {
        FaqContentEntity newQuestion = null;
        if (!TextUtils.isEmpty((CharSequence)searchTerms)) {
            String content;
            String bodyTextCopy;
            String titleText = faq.getFaqTitle();
            String bodyText = faq.getFaqContent();
            String hexColor = CustomConfig.CommonSetting.highlightedColor;
            bodyText = ">" + bodyText + "<";
            titleText = ">" + titleText + "<";
            Pattern pattern = Pattern.compile(">[^<]+<");
            String titleTextCopy = titleText;
            Matcher matcher = pattern.matcher(titleText);
            while (matcher.find()) {
                bodyTextCopy = titleTextCopy.substring(matcher.start(), matcher.end());
                content = bodyTextCopy.replaceAll("(?i)(" + searchTerms + ")", "<span style=\"color: " + hexColor + "\"></span>");
                titleText = titleText.replace(bodyTextCopy, content);
            }
            bodyTextCopy = bodyText;
            matcher = pattern.matcher(bodyText);
            while (matcher.find()) {
                content = bodyTextCopy.substring(matcher.start(), matcher.end());
                String word = content.replaceAll("(?i)(" + searchTerms + ")", "<span style=\"color: " + hexColor + "\">$1</span>");
                bodyText = bodyText.replace(content, word);
            }
            titleText = titleText.substring(1, titleText.length() - 1);
            bodyText = bodyText.substring(1, bodyText.length() - 1);
            newQuestion = new FaqContentEntity(faq.getSecId(), titleText, faq.getFaqKeywords(), faq.getFaqMainId(), faq.getFaqDisplayId(), faq.getFaqContentId(), bodyText, faq.isHelpful(), faq.getSearchTerm());
        }
        return newQuestion;
    }

    public static String getNoTemplateFaqContent(String originFaqContent) {
        StringBuilder stringBuilder = new StringBuilder();
        originFaqContent = ">" + originFaqContent + "<";
        Matcher matcher = Pattern.compile(">[^<]+").matcher(originFaqContent);
        while (matcher.find()) {
            String group = matcher.toMatchResult().group().replace(">", "").replace("<", "");
            if (group.trim().contains("body {") || TextUtils.isEmpty((CharSequence)group.trim())) continue;
            stringBuilder.append(group);
        }
        if (TextUtils.isEmpty((CharSequence)stringBuilder.toString())) {
            stringBuilder.append(originFaqContent);
        }
        return stringBuilder.toString();
    }

    public static int getRandomColor() {
        Random random = new Random();
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < 2; ++i) {
            int temp = random.nextInt(16);
            r = r * 16 + temp;
            temp = random.nextInt(16);
            g = g * 16 + temp;
            temp = random.nextInt(16);
            b = b * 16 + temp;
        }
        return Color.rgb((int)r, (int)g, (int)b);
    }

    public static boolean isNightMode(Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
        return uiModeManager.getNightMode() == 2;
    }

    public static boolean isLayoutRtl(View view) {
        if (view == null) {
            return false;
        }
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }
}

