/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class TLog {
    private static boolean DEBUG = false;
    private static final int MAX_LENGTH = 3072;

    public static void initLog(boolean isDebug) {
        DEBUG = isDebug;
    }

    private static synchronized String getTAG(String ... tag) {
        StackTraceElement[] sts;
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement st : sts = Thread.currentThread().getStackTrace()) {
            if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(TLog.class.getName())) continue;
            String customTag = "AIHelp ";
            if (tag != null && tag.length > 0) {
                customTag = String.format("%s ", tag[0]);
            }
            builder.append(customTag).append(">> (").append(st.getFileName()).append(":").append(st.getLineNumber()).append(")");
            return builder.toString();
        }
        return "";
    }

    public static synchronized void d(String text) {
        TLog.d("", text);
    }

    public static synchronized void d(String tag, String text) {
        if (DEBUG && !TextUtils.isEmpty((CharSequence)text)) {
            for (String str : TLog.splitStr(text)) {
                Log.d((String)TLog.getTAG(tag), (String)str);
            }
        }
    }

    public static synchronized void json(String jsonDescription, String json) {
        if (DEBUG && !TextUtils.isEmpty((CharSequence)json)) {
            String tag = TLog.getTAG(new String[0]);
            try {
                String logStr = TLog.formatJson(jsonDescription, json);
                for (String str : TLog.splitStr(logStr)) {
                    Log.d((String)TLog.getTAG(new String[0]), (String)str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.d((String)tag, (String)e.toString());
            }
        }
    }

    private static String[] splitStr(String str) {
        try {
            int length = str.length();
            String[] strArr = new String[length / 3072 + 1];
            int start = 0;
            for (int i = 0; i < strArr.length; ++i) {
                if (start + 3072 < length) {
                    strArr[i] = str.substring(start, start + 3072);
                    start += 3072;
                    continue;
                }
                strArr[i] = str.substring(start, length);
                start = length;
            }
            return strArr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    private static String formatJson(String desc, String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        boolean isInQuotationMarks = false;
        block6: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '\"': {
                    if (last != '\\') {
                        isInQuotationMarks = !isInQuotationMarks;
                    }
                    sb.append(current);
                    continue block6;
                }
                case '[': 
                case '{': {
                    if (i == 0) {
                        sb.append("\t\n");
                        sb.append(desc).append(": \n\n");
                    }
                    sb.append(current);
                    if (isInQuotationMarks) continue block6;
                    sb.append('\n');
                    TLog.addIndentBlank(sb, ++indent);
                    continue block6;
                }
                case ']': 
                case '}': {
                    if (!isInQuotationMarks) {
                        sb.append('\n');
                        TLog.addIndentBlank(sb, --indent);
                    }
                    sb.append(current);
                    if (i != jsonStr.length() - 1) continue block6;
                    sb.append("\n\t");
                    continue block6;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\' || isInQuotationMarks) continue block6;
                    sb.append('\n');
                    TLog.addIndentBlank(sb, indent);
                    continue block6;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }

    public static void l(String url, boolean isTop) {
        if (DEBUG) {
            String tag = TLog.getTAG(new String[0]);
            if (isTop) {
                // empty if block
            }
        }
    }
}

