/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.toolkit.ActiveComponent;
import net.wimpi.telnetd.io.toolkit.BufferOverflowException;
import net.wimpi.telnetd.io.toolkit.CharBuffer;
import net.wimpi.telnetd.io.toolkit.Dimension;
import net.wimpi.telnetd.io.toolkit.InputFilter;
import net.wimpi.telnetd.io.toolkit.InputValidator;

public class Editfield
extends ActiveComponent {
    private InputFilter m_InputFilter = null;
    private InputValidator m_InputValidator = null;
    private Buffer m_Buffer;
    private int m_Cursor = 0;
    private boolean m_InsertMode = true;
    private int m_LastSize = 0;
    private boolean m_PasswordField = false;
    private boolean m_JustBackspace;

    public Editfield(BasicTerminalIO io, String name, int length) {
        super(io, name);
        this.m_Buffer = new Buffer(length);
        this.setDimension(new Dimension(length, 1));
        this.m_Cursor = 0;
        this.m_InsertMode = true;
    }

    public int getLength() {
        return this.m_Dim.getWidth();
    }

    public int getSize() {
        return this.m_Buffer.size();
    }

    public String getValue() {
        return this.m_Buffer.toString();
    }

    public void setValue(String str) throws BufferOverflowException, IOException {
        this.clear();
        this.append(str);
    }

    public void clear() throws IOException {
        this.positionCursorAtBegin();
        for (int i = 0; i < this.m_Buffer.size(); ++i) {
            this.m_IO.write(' ');
        }
        this.positionCursorAtBegin();
        this.m_Buffer.clear();
        this.m_Cursor = 0;
        this.m_LastSize = 0;
        this.m_IO.flush();
    }

    public char getCharAt(int pos) throws IndexOutOfBoundsException {
        return this.m_Buffer.getCharAt(pos);
    }

    public void setCharAt(int pos, char ch) throws IndexOutOfBoundsException, IOException {
        this.m_Buffer.setCharAt(pos, ch);
        this.draw();
    }

    public void insertCharAt(int pos, char ch) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.insertCharAt(pos, ch);
        if (this.m_Cursor >= pos) {
            this.moveRight();
        }
        this.draw();
    }

    public void removeCharAt(int pos) throws IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.removeCharAt(pos);
        if (this.m_Cursor > pos) {
            this.moveLeft();
        }
        this.draw();
    }

    public void insertStringAt(int pos, String str) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.m_Buffer.insertCharAt(pos, str.charAt(i));
            ++this.m_Cursor;
        }
        this.draw();
    }

    public void append(char ch) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.append(ch);
        ++this.m_Cursor;
        if (!this.m_PasswordField) {
            this.m_IO.write(ch);
        } else {
            this.m_IO.write('.');
        }
    }

    public void append(String str) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.m_Buffer.append(str.charAt(i));
            ++this.m_Cursor;
        }
        if (!this.m_PasswordField) {
            this.m_IO.write(str);
        } else {
            StringBuffer sbuf = new StringBuffer();
            for (int n = 0; n < str.length(); ++n) {
                sbuf.append('.');
            }
            this.m_IO.write(sbuf.toString());
        }
    }

    public int getCursorPosition() {
        return this.m_Cursor;
    }

    public boolean isJustBackspace() {
        return this.m_JustBackspace;
    }

    public void setJustBackspace(boolean b) {
        this.m_JustBackspace = true;
    }

    public void registerInputFilter(InputFilter filter) {
        this.m_InputFilter = filter;
    }

    public void registerInputValidator(InputValidator validator) {
        this.m_InputValidator = validator;
    }

    public boolean isInInsertMode() {
        return this.m_InsertMode;
    }

    public void setInsertMode(boolean b) {
        this.m_InsertMode = b;
    }

    public boolean isPasswordField() {
        return this.m_PasswordField;
    }

    public void setPasswordField(boolean b) {
        this.m_PasswordField = b;
    }

    public void run() throws IOException {
        int in = 0;
        this.draw();
        this.m_IO.flush();
        block16: do {
            in = this.m_IO.read();
            if (this.m_JustBackspace && in == 1302) {
                in = 1303;
            }
            if (this.m_InputFilter != null) {
                in = this.m_InputFilter.filterInput(in);
            }
            switch (in) {
                case -1: {
                    this.m_Buffer.clear();
                    break;
                }
                case -2000: {
                    continue block16;
                }
                case -2001: {
                    this.m_IO.bell();
                    break;
                }
                case 1004: {
                    this.moveLeft();
                    break;
                }
                case 1003: {
                    this.moveRight();
                    break;
                }
                case 1001: 
                case 1002: {
                    this.m_IO.bell();
                    break;
                }
                case 10: {
                    if (this.m_InputValidator != null) {
                        if (this.m_InputValidator.validate(this.m_Buffer.toString())) {
                            in = -1;
                            break;
                        }
                        this.m_IO.bell();
                        break;
                    }
                    in = -1;
                    break;
                }
                case 1303: {
                    try {
                        this.removeCharAt(this.m_Cursor - 1);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 1302: {
                    try {
                        this.removeCharAt(this.m_Cursor);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 1301: {
                    in = -1;
                    break;
                }
                default: {
                    this.handleCharInput(in);
                }
            }
            this.m_IO.flush();
        } while (in != -1);
    }

    public void draw() throws IOException {
        int diff = this.m_LastSize - this.m_Buffer.size();
        String output = this.m_Buffer.toString();
        if (this.m_PasswordField) {
            StringBuffer stbuf = new StringBuffer();
            for (int n = 0; n < output.length(); ++n) {
                stbuf.append('.');
            }
            output = stbuf.toString();
        }
        if (diff > 0) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(output);
            for (int i = 0; i < diff; ++i) {
                sbuf.append(" ");
            }
            output = sbuf.toString();
        }
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        } else {
            this.m_IO.moveLeft(this.m_Cursor);
        }
        this.m_IO.write(output);
        if (this.m_Cursor < output.length()) {
            this.m_IO.moveLeft(output.length() - this.m_Cursor);
        }
    }

    private void moveRight() throws IOException {
        if (this.m_Cursor < this.m_Buffer.size()) {
            ++this.m_Cursor;
            this.m_IO.moveRight(1);
        } else {
            this.m_IO.bell();
        }
    }

    private void moveLeft() throws IOException {
        if (this.m_Cursor > 0) {
            --this.m_Cursor;
            this.m_IO.moveLeft(1);
        } else {
            this.m_IO.bell();
        }
    }

    private void positionCursorAtBegin() throws IOException {
        if (this.m_Position == null) {
            this.m_IO.moveLeft(this.m_Cursor);
        } else {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        }
    }

    private boolean isCursorAtEnd() {
        return this.m_Cursor == this.m_Buffer.size();
    }

    private void handleCharInput(int ch) throws IOException {
        if (this.isCursorAtEnd()) {
            try {
                this.append((char)ch);
            }
            catch (BufferOverflowException bex) {
                this.m_IO.bell();
            }
        } else if (this.isInInsertMode()) {
            try {
                this.insertCharAt(this.m_Cursor, (char)ch);
            }
            catch (BufferOverflowException bex) {
                this.m_IO.bell();
            }
        } else {
            try {
                this.setCharAt(this.m_Cursor, (char)ch);
            }
            catch (IndexOutOfBoundsException bex) {
                this.m_IO.bell();
            }
        }
    }

    private void storeSize() {
        this.m_LastSize = this.m_Buffer.size();
    }

    class Buffer
    extends CharBuffer {
        public Buffer(int size) {
            super(size);
        }
    }
}

