/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.imgo.net;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hunantv.imgo.util.m;
import com.mgtv.json.JsonInterface;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.message.BasicNameValuePair;

public class RequestParams
implements JsonInterface,
Serializable {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    protected static final String LOG_TAG = "RequestParams";
    protected boolean isRepeatable;
    protected boolean useJsonStreamer;
    protected boolean autoCloseInputStreams;
    protected final ConcurrentHashMap<String, String> urlParams = new ConcurrentHashMap();
    protected String contentEncoding = "UTF-8";

    public void setContentEncoding(String string2) {
        if (string2 != null) {
            this.contentEncoding = string2;
        } else {
            m.a(LOG_TAG, "setContentEncoding called with null attribute");
        }
    }

    public RequestParams() {
        this(null);
    }

    public RequestParams(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public RequestParams(final String string2, final String string3) {
        this((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(string2, string3);
            }
        });
    }

    public RequestParams(Object ... objectArray) {
        int n2 = objectArray.length;
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string2 = String.valueOf(objectArray[i2]);
            String string3 = String.valueOf(objectArray[i2 + 1]);
            this.put(string2, string3);
        }
    }

    public void put(String string2, String string3) {
        if (string2 != null && string3 != null) {
            this.urlParams.put(string2, string3);
        }
    }

    public void put(String string2, int n2) {
        if (string2 != null) {
            this.urlParams.put(string2, String.valueOf(n2));
        }
    }

    public void put(String string2, long l2) {
        if (string2 != null) {
            this.urlParams.put(string2, String.valueOf(l2));
        }
    }

    public void add(String string2, String string3) {
        this.put(string2, string3);
    }

    public void remove(String string2) {
        this.urlParams.remove(string2);
    }

    public boolean has(String string2) {
        return this.urlParams.get(string2) != null;
    }

    public String toJson() {
        org.json.JSONObject jSONObject = new org.json.JSONObject();
        try {
            for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
                jSONObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONObject.toString();
    }

    public String toJsonNew() {
        JSONObject jSONObject = new JSONObject();
        try {
            for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
                if ("lob".equalsIgnoreCase(entry.getKey()) || "err_info".equalsIgnoreCase(entry.getKey())) {
                    if (TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                    jSONObject.put(entry.getKey(), JSON.parse((String)entry.getValue()));
                    continue;
                }
                jSONObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject.toJSONString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            String string2 = "";
            try {
                string2 = URLEncoder.encode(entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public List<BasicNameValuePair> getParams() {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            linkedList.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        return linkedList;
    }

    public Map<String, String> getParamsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            String string2 = entry.getValue();
            hashMap.put(entry.getKey(), string2);
        }
        return hashMap;
    }

    private List<BasicNameValuePair> getParamsList(String string2, Object object) {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        if (object instanceof Map) {
            Map map = (Map)object;
            ArrayList arrayList = new ArrayList(map.keySet());
            if (arrayList.size() > 0 && arrayList.get(0) instanceof Comparable) {
                Collections.sort(arrayList);
            }
            for (Object e2 : arrayList) {
                Object v2;
                if (!(e2 instanceof String) || (v2 = map.get(e2)) == null) continue;
                linkedList.addAll(this.getParamsList(string2 == null ? (String)e2 : String.format("%s[%s]", string2, e2), v2));
            }
        } else if (object instanceof List) {
            List list = (List)object;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                linkedList.addAll(this.getParamsList(String.format("%s[%d]", string2, i2), list.get(i2)));
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                linkedList.addAll(this.getParamsList(String.format("%s[%d]", string2, i3), objectArray[i3]));
            }
        } else if (object instanceof Set) {
            Set set = (Set)object;
            for (Object e3 : set) {
                linkedList.addAll(this.getParamsList(string2, e3));
            }
        } else {
            linkedList.add(new BasicNameValuePair(string2, object.toString()));
        }
        return linkedList;
    }

    public String toNoFormatString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            String string2 = entry.getValue();
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

