/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.ssp.control;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hunantv.imgo.log.e;
import com.mgtv.ssp.control.a;
import com.mgtv.ssp.control.b;
import com.mgtv.ssp.control.c;
import com.mgtv.ssp.control.d;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseVideoController
extends FrameLayout
implements c {
    protected a mControlWrapper;
    @Nullable
    protected Activity mActivity;
    protected boolean mShowing;
    protected boolean mIsLocked;
    protected int mDefaultTimeout = 4000;
    private boolean mEnableOrientation;
    private boolean mAdaptCutout;
    private Boolean mHasCutout;
    private int mCutoutHeight;
    private boolean mIsStartProgress;
    protected LinkedHashMap<b, Boolean> mControlComponents = new LinkedHashMap();
    private Animation mShowAnim;
    private Animation mHideAnim;
    private String TAG = "BaseVideoController";
    protected final Runnable mFadeOut = new Runnable(){

        @Override
        public void run() {
            BaseVideoController.this.hide();
        }
    };
    protected Runnable mShowProgress = new Runnable(){

        @Override
        public void run() {
            int n2 = BaseVideoController.this.setProgress();
            if (BaseVideoController.this.mControlWrapper.isPlaying()) {
                BaseVideoController.this.postDelayed(this, (long)((float)(1000 - n2 % 1000) / BaseVideoController.this.mControlWrapper.getCurrentPlaySpeed()));
            } else {
                BaseVideoController.this.mIsStartProgress = false;
            }
        }
    };
    private int mOrientation = 0;

    public BaseVideoController(@NonNull Context context) {
        this(context, null);
    }

    public BaseVideoController(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BaseVideoController(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int n2) {
        super(context, attributeSet, n2);
        this.initView();
    }

    protected void initView() {
        if (this.getLayoutId() != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        }
        this.mShowAnim = new AlphaAnimation(0.0f, 1.0f);
        this.mShowAnim.setDuration(300L);
        this.mHideAnim = new AlphaAnimation(1.0f, 0.0f);
        this.mHideAnim.setDuration(300L);
        this.mActivity = com.mgtv.ssp.utils.c.d(this.getContext());
    }

    protected abstract int getLayoutId();

    @CallSuper
    public void setMediaPlayer(d d2) {
        this.mControlWrapper = new a(d2, this);
        for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
            b b2 = entry.getKey();
            b2.attach(this.mControlWrapper);
        }
    }

    public void addControlComponent(b ... bArray) {
        for (b b2 : bArray) {
            this.addControlComponent(b2, false);
        }
    }

    public void addControlComponent(b b2, boolean bl2) {
        View view;
        if (b2 == null) {
            return;
        }
        this.mControlComponents.put(b2, bl2);
        if (this.mControlWrapper != null) {
            b2.attach(this.mControlWrapper);
        }
        if ((view = b2.getView()) != null && !bl2) {
            this.addView(view, 0);
        }
    }

    public void addControlComponent(FrameLayout.LayoutParams layoutParams, b b2, boolean bl2) {
        View view;
        if (b2 == null) {
            return;
        }
        this.mControlComponents.put(b2, bl2);
        if (this.mControlWrapper != null) {
            b2.attach(this.mControlWrapper);
        }
        if ((view = b2.getView()) != null && !bl2) {
            this.addView(view, 0, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void removeControlComponent(b b2) {
        this.removeView(b2.getView());
        this.mControlComponents.remove(b2);
    }

    public void removeAllControlComponent() {
        for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
            this.removeView(entry.getKey().getView());
        }
        this.mControlComponents.clear();
    }

    public void removeAllDissociateComponents() {
        Iterator<Map.Entry<b, Boolean>> iterator = this.mControlComponents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<b, Boolean> entry = iterator.next();
            if (!entry.getValue().booleanValue()) continue;
            iterator.remove();
        }
    }

    @CallSuper
    public void setPlayState(int n2) {
        this.handlePlayStateChanged(n2);
    }

    @CallSuper
    public void setPlayerState(int n2) {
        this.handlePlayerStateChanged(n2);
    }

    public void setDismissTimeout(int n2) {
        if (n2 > 0) {
            this.mDefaultTimeout = n2;
        }
    }

    @Override
    public void hide() {
        if (this.mShowing) {
            this.stopFadeOut();
            if (this.mControlWrapper.isPlaying()) {
                this.handleVisibilityChanged(false, this.mHideAnim);
                this.mShowing = false;
            }
        }
    }

    @Override
    public void forceHide() {
        if (this.mShowing) {
            this.stopFadeOut();
            this.handleVisibilityChanged(false, this.mHideAnim);
            this.mShowing = false;
        }
    }

    @Override
    public void show() {
        if (!this.mShowing) {
            this.handleVisibilityChanged(true, this.mShowAnim);
            this.startFadeOut();
            this.mShowing = true;
        }
    }

    @Override
    public boolean isShowing() {
        return this.mShowing;
    }

    @Override
    public void startFadeOut() {
        this.stopFadeOut();
        this.postDelayed(this.mFadeOut, this.mDefaultTimeout);
    }

    @Override
    public void stopFadeOut() {
        this.removeCallbacks(this.mFadeOut);
    }

    @Override
    public void setLocked(boolean bl2) {
        this.mIsLocked = bl2;
        this.handleLockStateChanged(bl2);
    }

    @Override
    public boolean isLocked() {
        return this.mIsLocked;
    }

    @Override
    public void startProgress() {
        if (this.mIsStartProgress) {
            return;
        }
        this.post(this.mShowProgress);
        this.mIsStartProgress = true;
    }

    @Override
    public void stopProgress() {
        if (!this.mIsStartProgress) {
            return;
        }
        this.removeCallbacks(this.mShowProgress);
        this.mIsStartProgress = false;
    }

    private int setProgress() {
        int n2 = this.mControlWrapper.getCurrentPosition();
        int n3 = this.mControlWrapper.getVideoTotalTime();
        this.handleSetProgress(n3, n2);
        return n2;
    }

    public void setAdaptCutout(boolean bl2) {
        this.mAdaptCutout = bl2;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.checkCutout();
    }

    private void checkCutout() {
        if (!this.mAdaptCutout) {
            return;
        }
        if (this.mActivity != null && this.mHasCutout == null) {
            this.mHasCutout = com.mgtv.ssp.utils.b.a(this.mActivity);
            if (this.mHasCutout.booleanValue()) {
                this.mCutoutHeight = (int)com.mgtv.ssp.utils.c.a((Context)this.mActivity);
            }
        }
        e.a("", "hasCutout: " + this.mHasCutout + " cutout height: " + this.mCutoutHeight, true);
    }

    @Override
    public boolean hasCutout() {
        return this.mHasCutout != null && this.mHasCutout != false;
    }

    @Override
    public int getCutoutHeight() {
        return this.mCutoutHeight;
    }

    protected void togglePlay() {
        this.startFadeOut();
        this.mControlWrapper.togglePlay();
    }

    protected void toggleFullScreen() {
    }

    protected boolean startFullScreen() {
        if (this.mActivity == null || this.mActivity.isFinishing()) {
            return false;
        }
        this.mActivity.setRequestedOrientation(0);
        return true;
    }

    protected boolean stopFullScreen() {
        if (this.mActivity == null || this.mActivity.isFinishing()) {
            return false;
        }
        this.mActivity.setRequestedOrientation(1);
        return true;
    }

    public boolean onBackPressed() {
        return false;
    }

    public void onWindowFocusChanged(boolean bl2) {
        super.onWindowFocusChanged(bl2);
    }

    public void setEnableOrientation(boolean bl2) {
        this.mEnableOrientation = bl2;
    }

    protected void onOrientationPortrait(Activity activity) {
        if (this.mIsLocked) {
            return;
        }
        if (!this.mEnableOrientation) {
            return;
        }
        activity.setRequestedOrientation(1);
    }

    protected void onOrientationLandscape(Activity activity) {
        activity.setRequestedOrientation(0);
    }

    protected void onOrientationReverseLandscape(Activity activity) {
        activity.setRequestedOrientation(8);
    }

    private void handleVisibilityChanged(boolean bl2, Animation animation) {
        if (!this.mIsLocked) {
            for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
                b b2 = entry.getKey();
                b2.onVisibilityChanged(bl2, animation);
            }
        }
        this.onVisibilityChanged(bl2, animation);
    }

    public void setLockButtonVisibility(int n2) {
    }

    protected void onVisibilityChanged(boolean bl2, Animation animation) {
    }

    private void handlePlayStateChanged(int n2) {
        for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
            b b2 = entry.getKey();
            b2.onPlayStateChanged(n2);
        }
        this.onPlayStateChanged(n2);
    }

    @CallSuper
    protected void onPlayStateChanged(int n2) {
        switch (n2) {
            case 0: {
                this.mOrientation = 0;
                this.mIsLocked = false;
                this.mShowing = false;
                System.out.println("gesture  onPlayStateChanged IDLE mShowing " + this.mShowing);
                this.removeAllDissociateComponents();
                break;
            }
            case 11: {
                this.mIsLocked = false;
                this.mShowing = false;
                System.out.println("gesture  onPlayStateChanged COMPLETE mShowing " + this.mShowing);
                break;
            }
            case 13: {
                this.mShowing = false;
                System.out.println("gesture  onPlayStateChanged STATE_ERROR mShowing " + this.mShowing);
            }
        }
    }

    private void handlePlayerStateChanged(int n2) {
        for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
            b b2 = entry.getKey();
            b2.onPlayerStateChanged(n2);
        }
        this.onPlayerStateChanged(n2);
    }

    @CallSuper
    protected void onPlayerStateChanged(int n2) {
        switch (n2) {
            case 10: {
                if (this.mEnableOrientation) {
                    // empty if block
                }
                if (!this.hasCutout()) break;
                com.mgtv.ssp.utils.b.a(this.getContext(), false);
                break;
            }
            case 11: {
                if (!this.hasCutout()) break;
                com.mgtv.ssp.utils.b.a(this.getContext(), true);
                break;
            }
        }
    }

    private void handleSetProgress(int n2, int n3) {
        for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
            b b2 = entry.getKey();
            b2.setProgress(n2, n3);
        }
        this.setProgress(n2, n3);
    }

    protected void setProgress(int n2, int n3) {
    }

    private void handleLockStateChanged(boolean bl2) {
        for (Map.Entry<b, Boolean> entry : this.mControlComponents.entrySet()) {
            b b2 = entry.getKey();
            b2.onLockStateChanged(bl2);
        }
        this.onLockStateChanged(bl2);
    }

    protected void onLockStateChanged(boolean bl2) {
    }

    public void toggleShowState() {
        this.mControlWrapper.a();
    }
}

