/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.ssp.control;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mgtv.ssp.control.BaseVideoController;
import com.mgtv.ssp.control.IGestureComponent;
import com.mgtv.ssp.control.b;
import com.mgtv.ssp.utils.c;
import java.util.Map;

public abstract class GestureVideoController
extends BaseVideoController
implements GestureDetector.OnDoubleTapListener,
GestureDetector.OnGestureListener,
View.OnTouchListener {
    private GestureDetector mGestureDetector;
    private AudioManager mAudioManager;
    private boolean mIsGestureEnabled = false;
    private int mStreamVolume;
    private float mBrightness;
    private int mSeekPosition;
    private boolean mFirstTouch;
    private boolean mChangePosition;
    private boolean mChangeBrightness;
    private boolean mChangeVolume;
    private boolean mCanChangePosition = true;
    private boolean mEnableInNormal;
    private boolean mCanSlide;
    private int mCurPlayState;
    private boolean mIsDoubleTapTogglePlayEnabled = true;

    public GestureVideoController(@NonNull Context context) {
        super(context);
    }

    public GestureVideoController(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public GestureVideoController(@NonNull Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    @Override
    protected void initView() {
        super.initView();
        if (this.getContext() != null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
            this.setOnTouchListener(this);
        }
    }

    public void setCanChangePosition(boolean bl2) {
        this.mCanChangePosition = bl2;
    }

    public void setEnableInNormal(boolean bl2) {
        this.mEnableInNormal = bl2;
    }

    public void setGestureEnabled(boolean bl2) {
        this.mIsGestureEnabled = bl2;
    }

    public void setDoubleTapTogglePlayEnabled(boolean bl2) {
        this.mIsDoubleTapTogglePlayEnabled = bl2;
    }

    @Override
    public void setPlayerState(int n2) {
        super.setPlayerState(n2);
        if (n2 == 10) {
            this.mCanSlide = this.mEnableInNormal;
        } else if (n2 == 11) {
            this.mCanSlide = true;
        }
    }

    @Override
    public void setPlayState(int n2) {
        super.setPlayState(n2);
        this.mCurPlayState = n2;
    }

    private boolean isInPlaybackState() {
        return this.mControlWrapper != null && this.mCurPlayState != 0 && this.mCurPlayState != 1 && this.mCurPlayState != 2 && this.mCurPlayState != 3 && this.mCurPlayState != 4 && this.mCurPlayState != 5 && this.mCurPlayState != 12 && this.mCurPlayState != 13 && this.mCurPlayState != 14 && this.mCurPlayState != 16 && this.mCurPlayState != 17;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return this.mGestureDetector.onTouchEvent(motionEvent);
    }

    public boolean onDown(MotionEvent motionEvent) {
        Activity activity;
        if (!this.isInPlaybackState() || !this.mIsGestureEnabled || c.a(this.getContext(), motionEvent)) {
            return true;
        }
        if (this.mAudioManager != null) {
            this.mStreamVolume = this.mAudioManager.getStreamVolume(3);
        }
        this.mBrightness = (activity = c.d(this.getContext())) == null ? 0.0f : activity.getWindow().getAttributes().screenBrightness;
        this.mFirstTouch = true;
        this.mChangePosition = false;
        this.mChangeBrightness = false;
        this.mChangeVolume = false;
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        System.out.println("gesture onSingleTapConfirmed isInPlaybackState " + this.isInPlaybackState());
        if (this.isInPlaybackState()) {
            this.mControlWrapper.a();
        }
        return true;
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        if (this.mIsDoubleTapTogglePlayEnabled && !this.isLocked() && this.isInPlaybackState()) {
            this.togglePlay();
        }
        return true;
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
        if (!this.isInPlaybackState() || !this.mIsGestureEnabled || !this.mCanSlide || this.isLocked() || c.a(this.getContext(), motionEvent)) {
            return true;
        }
        float f4 = motionEvent.getX() - motionEvent2.getX();
        float f5 = motionEvent.getY() - motionEvent2.getY();
        if (this.mFirstTouch) {
            boolean bl2 = this.mChangePosition = Math.abs(f2) >= Math.abs(f3);
            if (!this.mChangePosition) {
                int n2 = c.a(this.getContext(), true) / 2;
                if (motionEvent2.getX() > (float)n2) {
                    this.mChangeVolume = true;
                } else {
                    this.mChangeBrightness = true;
                }
            }
            if (this.mChangePosition) {
                this.mChangePosition = this.mCanChangePosition;
            }
            if (this.mChangePosition || this.mChangeBrightness || this.mChangeVolume) {
                for (Map.Entry entry : this.mControlComponents.entrySet()) {
                    b b2 = (b)entry.getKey();
                    if (!(b2 instanceof IGestureComponent)) continue;
                    ((IGestureComponent)b2).a();
                }
            }
            this.mFirstTouch = false;
        }
        if (this.mChangePosition) {
            this.slideToChangePosition(f4);
        } else if (this.mChangeBrightness) {
            this.slideToChangeBrightness(f5);
        } else if (this.mChangeVolume) {
            this.slideToChangeVolume(f5);
        }
        return true;
    }

    protected void slideToChangePosition(float f2) {
        f2 = -f2;
        int n2 = this.getMeasuredWidth();
        int n3 = this.mControlWrapper.getCurrentVideoInfo().getVideoDuration();
        int n4 = this.mControlWrapper.getCurrentPosition();
        int n5 = (int)(f2 / (float)n2 * 120000.0f + (float)n4);
        if (n5 > n3) {
            n5 = n3;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        for (Map.Entry entry : this.mControlComponents.entrySet()) {
            b b2 = (b)entry.getKey();
            if (!(b2 instanceof IGestureComponent)) continue;
            ((IGestureComponent)b2).a(n5, n4, n3);
        }
        this.mSeekPosition = n5;
    }

    protected void slideToChangeBrightness(float f2) {
        float f3;
        Activity activity = c.d(this.getContext());
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        int n2 = this.getMeasuredHeight();
        if (this.mBrightness == -1.0f) {
            this.mBrightness = 0.5f;
        }
        if ((f3 = f2 * 2.0f / (float)n2 * 1.0f + this.mBrightness) < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        int n3 = (int)(f3 * 100.0f);
        layoutParams.screenBrightness = f3;
        window.setAttributes(layoutParams);
        for (Map.Entry entry : this.mControlComponents.entrySet()) {
            b b2 = (b)entry.getKey();
            if (!(b2 instanceof IGestureComponent)) continue;
            ((IGestureComponent)b2).a(n3);
        }
    }

    protected void slideToChangeVolume(float f2) {
        if (this.mAudioManager != null) {
            int n2 = this.mAudioManager.getStreamMaxVolume(3);
            int n3 = this.getMeasuredHeight();
            float f3 = f2 * 2.0f / (float)n3 * (float)n2;
            float f4 = (float)this.mStreamVolume + f3;
            if (f4 > (float)n2) {
                f4 = n2;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            int n4 = (int)(f4 / (float)n2 * 100.0f);
            this.mAudioManager.setStreamVolume(3, (int)f4, 0);
            for (Map.Entry entry : this.mControlComponents.entrySet()) {
                b b2 = (b)entry.getKey();
                if (!(b2 instanceof IGestureComponent)) continue;
                ((IGestureComponent)b2).b(n4);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mGestureDetector.onTouchEvent(motionEvent)) {
            int n2 = motionEvent.getAction();
            switch (n2) {
                case 1: {
                    this.stopSlide();
                    if (this.mSeekPosition <= 0) break;
                    this.mControlWrapper.seekTo(this.mSeekPosition);
                    this.mSeekPosition = 0;
                    break;
                }
                case 3: {
                    this.stopSlide();
                    this.mSeekPosition = 0;
                }
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    private void stopSlide() {
        for (Map.Entry entry : this.mControlComponents.entrySet()) {
            b b2 = (b)entry.getKey();
            if (!(b2 instanceof IGestureComponent)) continue;
            ((IGestureComponent)b2).b();
        }
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
        return false;
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public boolean onDoubleTapEvent(MotionEvent motionEvent) {
        return false;
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        return false;
    }
}

