/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.ssp.feed.control;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mgtv.ssp.R;
import com.mgtv.ssp.control.GestureVideoController;
import com.mgtv.ssp.utils.c;
import com.mgtv.ssp.widget.GestureView;
import com.mgtv.ssp.widget.ImmerBottomControlView;

public class StandardVideoControlView
extends GestureVideoController
implements View.OnClickListener {
    protected ImageView a;

    public StandardVideoControlView(@NonNull Context context) {
        this(context, null);
    }

    public StandardVideoControlView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public StandardVideoControlView(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int n2) {
        super(context, attributeSet, n2);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.mgplayer_layout_standard_control_view;
    }

    @Override
    protected void initView() {
        super.initView();
        this.a = (ImageView)this.findViewById(R.id.lock);
        this.a.setOnClickListener((View.OnClickListener)this);
    }

    public void a() {
        ImmerBottomControlView immerBottomControlView = new ImmerBottomControlView(this.getContext());
        this.addControlComponent(immerBottomControlView);
        this.addControlComponent(new GestureView(this.getContext()));
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (n2 == R.id.lock) {
            this.mControlWrapper.b();
        } else if (n2 == R.id.play_btn) {
            this.mControlWrapper.start();
        }
    }

    @Override
    protected void onLockStateChanged(boolean bl2) {
        if (bl2) {
            this.a.setSelected(true);
            Toast.makeText((Context)this.getContext(), (int)R.string.mgplayer_locked, (int)0).show();
        } else {
            this.a.setSelected(false);
            Toast.makeText((Context)this.getContext(), (int)R.string.mgplayer_unlocked, (int)0).show();
        }
    }

    @Override
    protected void onVisibilityChanged(boolean bl2, Animation animation) {
        if (this.mControlWrapper.isFullScreen()) {
            if (bl2) {
                if (this.a.getVisibility() == 8) {
                    this.a.setVisibility(0);
                    if (animation != null) {
                        this.a.startAnimation(animation);
                    }
                }
            } else {
                this.a.setVisibility(8);
                if (animation != null) {
                    this.a.startAnimation(animation);
                }
            }
        }
    }

    @Override
    protected void onPlayerStateChanged(int n2) {
        super.onPlayerStateChanged(n2);
        switch (n2) {
            case 10: {
                this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.a.setVisibility(8);
                break;
            }
            case 11: {
                if (this.isShowing()) {
                    this.a.setVisibility(0);
                    break;
                }
                this.a.setVisibility(8);
            }
        }
        if (this.mActivity != null && this.hasCutout()) {
            int n3 = this.mActivity.getRequestedOrientation();
            int n4 = c.a(this.getContext(), 24.0f);
            int n5 = this.getCutoutHeight();
            if (n3 == 1) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.a.getLayoutParams();
                layoutParams.setMargins(n4, 0, n4, 0);
            } else if (n3 == 0) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.a.getLayoutParams();
                layoutParams.setMargins(n4 + n5, 0, n4 + n5, 0);
            } else if (n3 == 8) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.a.getLayoutParams();
                layoutParams.setMargins(n4, 0, n4, 0);
            }
        }
    }

    @Override
    protected void onPlayStateChanged(int n2) {
        super.onPlayStateChanged(n2);
        switch (n2) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.a.setSelected(false);
                break;
            }
            case 11: {
                this.a.setVisibility(8);
                this.a.setSelected(false);
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.isLocked()) {
            this.show();
            Toast.makeText((Context)this.getContext(), (int)R.string.mgplayer_lock_tip, (int)0).show();
            return true;
        }
        if (this.mControlWrapper.isFullScreen()) {
            return this.stopFullScreen();
        }
        return super.onBackPressed();
    }
}

