/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.ssp.feed.control;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mgtv.ssp.R;
import com.mgtv.ssp.control.GestureVideoController;
import com.mgtv.ssp.utils.c;
import com.mgtv.ssp.widget.GestureView;
import com.mgtv.ssp.widget.ImmerBottomControlView;
import com.mgtv.thirdsdk.playcore.utils.f;

public class StandardVideoController
extends GestureVideoController
implements View.OnClickListener {
    protected ImageView mLockButton;
    protected ImageView mPlayBtn;
    protected LinearLayout mReplay;
    protected ProgressBar mLoadingProgress;

    public StandardVideoController(@NonNull Context context) {
        this(context, null);
    }

    public StandardVideoController(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public StandardVideoController(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int n2) {
        super(context, attributeSet, n2);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.mgplayer_layout_standard_control_view;
    }

    @Override
    protected void initView() {
        super.initView();
        this.mLockButton = (ImageView)this.findViewById(R.id.lock);
        this.mLockButton.setOnClickListener((View.OnClickListener)this);
        this.mLoadingProgress = (ProgressBar)this.findViewById(R.id.loading);
        this.mPlayBtn = (ImageView)this.findViewById(R.id.play_btn);
        this.mPlayBtn.setOnClickListener((View.OnClickListener)this);
        this.mReplay = (LinearLayout)this.findViewById(R.id.lay_replay);
        this.mReplay.setOnClickListener((View.OnClickListener)this);
    }

    public void addDefaultControlComponent(String string2, boolean bl2) {
    }

    public void addImmersionControlComponent() {
        ImmerBottomControlView immerBottomControlView = new ImmerBottomControlView(this.getContext());
        this.addControlComponent(immerBottomControlView);
        this.addControlComponent(new GestureView(this.getContext()));
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (this.mControlWrapper != null) {
            if (n2 == R.id.lock) {
                this.mControlWrapper.b();
            } else if (n2 == R.id.play_btn) {
                this.mControlWrapper.togglePlay();
            } else if (n2 == R.id.lay_replay) {
                this.mControlWrapper.reStart();
            }
        }
    }

    @Override
    protected void onLockStateChanged(boolean bl2) {
        if (bl2) {
            this.mLockButton.setSelected(true);
            Toast.makeText((Context)this.getContext(), (int)R.string.mgplayer_locked, (int)0).show();
        } else {
            this.mLockButton.setSelected(false);
            Toast.makeText((Context)this.getContext(), (int)R.string.mgplayer_unlocked, (int)0).show();
        }
    }

    @Override
    protected void onVisibilityChanged(boolean bl2, Animation animation) {
        if (this.mControlWrapper.isFullScreen()) {
            if (bl2) {
                if (this.mLockButton.getVisibility() == 8) {
                    this.mLockButton.setVisibility(0);
                    if (animation != null) {
                        this.mLockButton.startAnimation(animation);
                    }
                }
            } else {
                this.mLockButton.setVisibility(8);
                if (animation != null) {
                    this.mLockButton.startAnimation(animation);
                }
            }
        }
        this.mPlayBtn.setVisibility(8);
    }

    @Override
    protected void onPlayerStateChanged(int n2) {
        super.onPlayerStateChanged(n2);
        switch (n2) {
            case 10: {
                this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.mLockButton.setVisibility(8);
                break;
            }
            case 11: {
                if (this.isShowing()) {
                    this.mLockButton.setVisibility(0);
                    break;
                }
                this.mLockButton.setVisibility(8);
            }
        }
        if (this.mActivity != null && this.hasCutout()) {
            int n3 = this.mActivity.getRequestedOrientation();
            int n4 = c.a(this.getContext(), 24.0f);
            int n5 = this.getCutoutHeight();
            if (n3 == 1) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLockButton.getLayoutParams();
                layoutParams.setMargins(n4, 0, n4, 0);
            } else if (n3 == 0) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLockButton.getLayoutParams();
                layoutParams.setMargins(n4 + n5, 0, n4 + n5, 0);
            } else if (n3 == 8) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLockButton.getLayoutParams();
                layoutParams.setMargins(n4, 0, n4, 0);
            }
        }
    }

    @Override
    protected void onPlayStateChanged(int n2) {
        super.onPlayStateChanged(n2);
        switch (n2) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.mLockButton.setSelected(false);
                System.out.println("mLoadingProgress setVisibility(GONE)  playState =" + n2);
                this.mLoadingProgress.setVisibility(8);
                f.a((View)this.mReplay, 8);
                break;
            }
            case 9: {
                this.mPlayBtn.setSelected(false);
                System.out.println("mLoadingProgress setVisibility(GONE)  playState =" + n2);
                this.mLoadingProgress.setVisibility(8);
                f.a((View)this.mReplay, 8);
                break;
            }
            case 8: {
                this.mPlayBtn.setSelected(true);
            }
            case 6: 
            case 13: {
                this.mPlayBtn.setVisibility(8);
                System.out.println("mLoadingProgress setVisibility(GONE)  playState =" + n2);
                this.mLoadingProgress.setVisibility(8);
                f.a((View)this.mReplay, 8);
                break;
            }
            case 5: 
            case 7: {
                this.mLoadingProgress.setVisibility(0);
                f.a((View)this.mReplay, 8);
                break;
            }
            case 11: {
                System.out.println("mLoadingProgress setVisibility(GONE)  playState =" + n2);
                this.mLoadingProgress.setVisibility(8);
                this.mLockButton.setVisibility(8);
                this.mLockButton.setSelected(false);
                this.mPlayBtn.setVisibility(8);
                f.a((View)this.mReplay, 0);
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.isLocked()) {
            this.show();
            Toast.makeText((Context)this.getContext(), (int)R.string.mgplayer_lock_tip, (int)0).show();
            return true;
        }
        if (this.mControlWrapper.isFullScreen()) {
            return this.stopFullScreen();
        }
        return super.onBackPressed();
    }
}

