/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.ssp.play;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.hunantv.imgo.net.entity.AuthInfo;
import com.hunantv.imgo.report.d;
import com.hunantv.imgo.util.b;
import com.hunantv.imgo.util.j;
import com.mgtv.ssp.R;
import com.mgtv.ssp.authbase.AccountInfo;
import com.mgtv.ssp.play.BaseScene;
import com.mgtv.ssp.play.IScene;
import com.mgtv.ssp.play.PlayErrorView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PreviewEndScene
extends BaseScene {
    private ImageView mBgView;
    private LinearLayout mCenterLayout;
    PlayErrorView.OnErrorViewCallback clicked;
    private static final String URL_VIP_CASHIER = AccountInfo.defaultVipUrl;

    @Override
    public void attach(ViewGroup viewGroup) {
        if (viewGroup == null) {
            return;
        }
        if (this.mBgView == null) {
            this.mBgView = new ImageView(viewGroup.getContext());
            this.mBgView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        }
        this.addToViewGroup((View)this.mBgView, viewGroup);
        if (this.mCenterLayout == null) {
            this.mCenterLayout = new LinearLayout(viewGroup.getContext());
            this.mCenterLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mCenterLayout.setOrientation(1);
            this.mCenterLayout.setGravity(17);
        }
        this.addToViewGroup((View)this.mCenterLayout, viewGroup);
        this.loadBg(viewGroup.getContext());
        this.fillCenterLayout(viewGroup.getContext());
    }

    @Override
    public void detach(ViewGroup viewGroup) {
        if (viewGroup == null) {
            return;
        }
        if (this.mBgView != null) {
            viewGroup.removeView((View)this.mBgView);
        }
        if (this.mCenterLayout != null) {
            viewGroup.removeView((View)this.mCenterLayout);
        }
    }

    private void loadBg(Context context) {
        int n2;
        boolean bl2 = this.isPortrait(context);
        int n3 = n2 = bl2 ? R.drawable.vg_portrait_bg : R.drawable.vg_landspace_bg;
        if (this.mSceneData == null || this.mSceneData.bg == null) {
            this.mBgView.setImageResource(n2);
        } else {
            String string2 = bl2 ? this.mSceneData.bg.vertical_mode_bg : this.mSceneData.bg.wide_mode_bg;
            ((RequestBuilder)Glide.with((Context)context).load(string2).placeholder(n2)).into(this.mBgView);
        }
    }

    private void fillCenterLayout(Context context) {
        this.mCenterLayout.removeAllViews();
        if (this.mSceneData == null || this.mSceneData.components == null || this.mSceneData.components.isEmpty()) {
            this.mCenterLayout.setBackground(null);
            LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
            layoutInflater.inflate(R.layout.vg_preview_end_view_default, (ViewGroup)this.mCenterLayout, true);
        } else {
            List<AuthInfo.Component> list;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.mSceneData.bg != null) {
                this.mCenterLayout.setBackgroundColor(Color.parseColor((String)"#BF000000"));
            } else {
                this.mCenterLayout.setBackground(null);
            }
            List<AuthInfo.Component> list2 = this.mSceneData.components;
            SparseArray sparseArray = new SparseArray();
            for (AuthInfo.Component component : list2) {
                if (component == null) continue;
                list = (ArrayList<AuthInfo.Component>)sparseArray.get(component.line_num);
                if (list == null) {
                    list = new ArrayList<AuthInfo.Component>();
                    sparseArray.put(component.line_num, list);
                }
                list.add(component);
                if (component.show == null || component.show.size() <= 0) continue;
                arrayList.addAll(component.show);
            }
            int n2 = -1;
            for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
                list = (List)sparseArray.valueAt(i2);
                if (list.size() == 1) {
                    AuthInfo.Component component = (AuthInfo.Component)list.get(0);
                    this.addSingleView(context, component);
                    continue;
                }
                if (list.size() <= 1) continue;
                this.addMultipleView(context, list);
            }
            this.reportVip(arrayList);
        }
    }

    private void addSingleView(final Context context, AuthInfo.Component component) {
        final View view = this.createView(context, (ViewGroup)this.mCenterLayout, component);
        if (view == null) {
            return;
        }
        this.mCenterLayout.addView(view);
        if (component == null) {
            return;
        }
        if ("button".equals(component.code)) {
            view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    try {
                        View view2;
                        int n2 = PreviewEndScene.this.mCenterLayout.indexOfChild(view);
                        TextView textView = (TextView)view.findViewById(R.id.tv_btn);
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                        LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)textView.getLayoutParams();
                        if (n2 >= 1 && (view2 = PreviewEndScene.this.mCenterLayout.getChildAt(n2 - 1)) instanceof ViewGroup && ((ViewGroup)view2).getChildCount() > 1) {
                            ViewGroup viewGroup = (ViewGroup)view2;
                            TextView textView2 = (TextView)viewGroup.getChildAt(0).findViewById(R.id.tv_btn);
                            TextView textView3 = (TextView)viewGroup.getChildAt(1).findViewById(R.id.tv_btn);
                            layoutParams2.width = textView2.getMeasuredWidth() + textView3.getMeasuredWidth() + PreviewEndScene.this.dp2px(context, 16.0f);
                            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                        }
                        layoutParams.leftMargin = (view.getMeasuredWidth() - textView.getMeasuredWidth()) / 2;
                        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            });
        }
    }

    private void addMultipleView(final Context context, List<AuthInfo.Component> list) {
        if (!"button".equals(list.get((int)0).code) || !"button".equals(list.get((int)1).code)) {
            return;
        }
        final LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setGravity(17);
        linearLayout.setOrientation(0);
        ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        marginLayoutParams.rightMargin = marginLayoutParams.leftMargin = this.dp2px(context, 20.0f);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        for (int i2 = 0; i2 < list.size() && i2 <= 1; ++i2) {
            View view = this.createView(context, (ViewGroup)linearLayout, list.get(i2));
            if (view == null) continue;
            if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                if (i2 > 0) {
                    ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).setMargins(this.dp2px(context, 16.0f), 0, 0, 0);
                } else {
                    ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).setMargins(0, 0, 0, 0);
                }
            }
            linearLayout.addView(view);
        }
        linearLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                try {
                    TextView textView = (TextView)linearLayout.getChildAt(0).findViewById(R.id.tv_btn);
                    TextView textView2 = (TextView)linearLayout.getChildAt(1).findViewById(R.id.tv_btn);
                    int n2 = linearLayout.getMeasuredWidth() - textView.getMeasuredWidth() - textView2.getMeasuredWidth() - PreviewEndScene.this.dp2px(context, 16.0f);
                    linearLayout.setPadding(n2, 0, 0, PreviewEndScene.this.dp2px(context, 2.0f));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                linearLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        this.mCenterLayout.addView((View)linearLayout);
    }

    private View createView(Context context, ViewGroup viewGroup, AuthInfo.Component component) {
        if (component == null) {
            return null;
        }
        switch (component.code) {
            case "title": {
                return this.createTitleTextView(context, component);
            }
            case "subtitle": {
                return this.createSubTitleTextView(context, component);
            }
            case "button": {
                return this.createButtonView(context, viewGroup, component);
            }
            case "link": {
                return this.createLinkView(context, viewGroup, component);
            }
        }
        return null;
    }

    private View createTitleTextView(Context context, AuthInfo.Component component) {
        TextView textView = new TextView(context);
        ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        marginLayoutParams.bottomMargin = this.dp2px(context, 10.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        textView.setGravity(17);
        textView.setTextColor(-1);
        textView.setTextSize(16.0f);
        textView.setText((CharSequence)component.text);
        return textView;
    }

    private View createSubTitleTextView(Context context, AuthInfo.Component component) {
        TextView textView = new TextView(context);
        ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        marginLayoutParams.bottomMargin = this.dp2px(context, 10.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        textView.setGravity(17);
        textView.setTextColor(Color.parseColor((String)"#CCFFFFFF"));
        textView.setTextSize(12.0f);
        textView.setText((CharSequence)component.text);
        return textView;
    }

    private View createButtonView(final Context context, ViewGroup viewGroup, final AuthInfo.Component component) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View view = layoutInflater.inflate(R.layout.vg_button_view, viewGroup, false);
        TextView textView = (TextView)view.findViewById(R.id.tv_btn);
        TextView textView2 = (TextView)view.findViewById(R.id.tv_bubble);
        TextView textView3 = (TextView)view.findViewById(R.id.tv_tips);
        textView.setText((CharSequence)component.text);
        textView.setTextColor(component.selected == 1 ? -16777216 : Color.parseColor((String)"#DBB361"));
        textView.setBackgroundResource(component.selected == 1 ? R.drawable.vg_selected_btn_bg : R.drawable.vg_unselected_btn_bg);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (component != null && component.action != null) {
                    PreviewEndScene.this.onComponentAction(context, PreviewEndScene.this, component.action);
                    PreviewEndScene.this.reportVipClick(component);
                }
            }
        });
        if (TextUtils.isEmpty((CharSequence)component.superscript)) {
            textView2.setVisibility(8);
        } else {
            textView2.setVisibility(0);
            textView2.setText((CharSequence)component.superscript);
        }
        if (TextUtils.isEmpty((CharSequence)component.tips)) {
            textView3.setVisibility(8);
        } else {
            textView3.setVisibility(0);
            textView3.setText((CharSequence)component.tips);
        }
        return view;
    }

    private View createLinkView(final Context context, ViewGroup viewGroup, final AuthInfo.Component component) {
        if (component.action != null && component.action.tag == 10010) {
            return null;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View view = layoutInflater.inflate(R.layout.vg_link_view, viewGroup, false);
        TextView textView = (TextView)view.findViewById(R.id.tv_link);
        textView.setText((CharSequence)component.text);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (component != null && component.action != null) {
                    PreviewEndScene.this.onComponentAction(context, PreviewEndScene.this, component.action);
                    PreviewEndScene.this.reportVipClick(component);
                }
            }
        });
        return view;
    }

    private boolean isPortrait(Context context) {
        if (context == null) {
            return true;
        }
        return context.getResources().getConfiguration().orientation == 1;
    }

    private int dp2px(Context context, float f2) {
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void setOnViewClick(PlayErrorView.OnErrorViewCallback onErrorViewCallback) {
        this.clicked = onErrorViewCallback;
    }

    public void onComponentAction(Context context, IScene iScene, AuthInfo.Action action) {
        block11: {
            block10: {
                if (action == null) {
                    String string2 = iScene instanceof PreviewEndScene ? "20302" : "20301";
                    this.launchPay("VIPFirst", string2, null);
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)action.url)) break block10;
                switch (action.tag) {
                    case 10001: {
                        String string3 = "20302";
                        this.launchPay("VIPFirst", string3, action);
                        break;
                    }
                    case 10002: {
                        String string4 = "20303";
                        this.launchPay("SingleFirst", string4, action);
                        break;
                    }
                    case 10003: {
                        String string5 = "1";
                        this.launchPay("VIPOnly", string5, action);
                        break;
                    }
                    case 10004: {
                        break;
                    }
                    case 10010: {
                        if (this.clicked != null) {
                            this.clicked.toLogin();
                            break;
                        }
                        break block11;
                    }
                    default: {
                        String string6 = "1";
                        this.launchPay("VIPFirst", string6, action);
                        break;
                    }
                }
                break block11;
            }
            if (!j.a(context, action.url, false)) {
                this.clicked.toVip(action.url);
            }
        }
    }

    private void launchPay(String string2, String string3, AuthInfo.Action action) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_VIP_CASHIER);
        if (this.playData != null) {
            stringBuilder.append("&plid=").append(this.playData.f);
            stringBuilder.append("&clipid=").append(this.playData.e);
            stringBuilder.append("&vid=").append(this.playData.c);
            stringBuilder.append("&videoId=").append(this.playData.c);
            stringBuilder.append("&iapType=").append(string2);
            stringBuilder.append("&lcid=").append("");
        }
        if (action != null && !TextUtils.isEmpty((CharSequence)action.tag_ext)) {
            stringBuilder.append("&").append(action.tag_ext);
        }
        String string4 = "2.1.2";
        String string5 = "3";
        stringBuilder.append("&bid=").append(b.e());
        stringBuilder.append("&ftype=").append(string5);
        stringBuilder.append("&clocation=").append(string3);
        if (this.clicked != null) {
            this.clicked.toVip(stringBuilder.toString());
        }
    }

    private void reportVipClick(AuthInfo.Component component) {
        if (component != null && component.click != null) {
            this.reportVip(component.click);
        }
    }

    private void reportVip(List<String> list) {
        if (list != null && list.size() > 0) {
            for (String string2 : list) {
                if (TextUtils.isEmpty((CharSequence)string2)) continue;
                d.a().a(string2, new HashMap<String, String>());
            }
        }
    }

    public static final class IapType {
        public static final String OPEN_VIP = "VIPFirst";
        public static final String PAY_SINGLE_VID = "SingleFirst";
        public static final String PAY_SINGLE_ONLY = "SingleOnly";
        public static final String PAY_VIP_TIP = "VIPOnly";
    }
}

