/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.task.http;

import com.mgtv.json.JsonInterface;
import com.mgtv.task.http.MultiParts;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class HttpParams
implements JsonInterface {
    private final Map<String, String> get = new LinkedHashMap<String, String>();
    private final Map<String, String> header = new TreeMap<String, String>();
    private final Map<String, String> body = new LinkedHashMap<String, String>();
    private String bodyJson;
    private String bodyXml;
    private MultiParts multiParts;
    private String method;
    private String contentTypeS;
    private boolean isBodyGZip;

    public HttpParams put(String string2, String string3) {
        return this.put(string2, string3, null);
    }

    public HttpParams put(String string2, Number number) {
        return this.put(string2, String.valueOf(number), null);
    }

    public HttpParams put(String string2, String string3, Type type) {
        Map<String, String> map = this.getParams(type);
        map.put(string2, string3);
        return this;
    }

    public HttpParams put(String string2, Number number, Type type) {
        Map<String, String> map = this.getParams(type);
        map.put(string2, String.valueOf(number));
        return this;
    }

    public HttpParams putParams(Map<String, String> map) {
        return this.putParams(map, null);
    }

    public HttpParams putParams(Map<String, String> map, Type type) {
        Map<String, String> map2 = this.getParams(type);
        map2.putAll(map);
        return this;
    }

    public String get(String string2) {
        return this.get(string2, null);
    }

    public String get(String string2, Type type) {
        Map<String, String> map = this.getParams(type);
        return map.get(string2);
    }

    public Map<String, String> getParams() {
        return this.getParams(null);
    }

    public Map<String, String> getParams(Type type) {
        Map<String, String> map;
        if (type == null) {
            return this.get;
        }
        switch (type) {
            case HEADER: {
                map = this.header;
                break;
            }
            case BODY: {
                map = this.body;
                break;
            }
            default: {
                map = this.get;
            }
        }
        return map;
    }

    public String getBodyJson() {
        return this.bodyJson;
    }

    public HttpParams setBodyJson(String string2) {
        this.bodyJson = string2;
        return this;
    }

    public String getBodyXml() {
        return this.bodyXml;
    }

    public HttpParams setBodyXml(String string2) {
        this.bodyXml = string2;
        return this;
    }

    public MultiParts getMultiParts() {
        return this.multiParts;
    }

    public HttpParams setMultiParts(MultiParts multiParts) {
        this.multiParts = multiParts;
        return this;
    }

    public boolean isBodyGZip() {
        return this.isBodyGZip;
    }

    public HttpParams setBodyGZip(boolean bl2) {
        this.isBodyGZip = bl2;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string2) {
        this.method = string2;
    }

    public String toString() {
        return "HttpParams{get=" + this.get + ", header=" + this.header + ", body=" + this.body + ", bodyJson='" + this.bodyJson + '\'' + ", bodyXml='" + this.bodyXml + '\'' + ", multiParts=" + this.multiParts + ", method='" + this.method + '\'' + ", isBodyGZip=" + this.isBodyGZip + '}';
    }

    public String buildParameter() {
        if (this.getParams() == null || this.getParams().entrySet() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = this.getParams().entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, String> entry = iterator.next();
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                if (string3 == null) {
                    string3 = "";
                }
                stringBuilder.append(string2.toString());
                stringBuilder.append("=");
                if (string3 != null) {
                    stringBuilder.append(URLEncoder.encode(string3.toString(), "UTF-8"));
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    public String getContentTypeS() {
        return this.contentTypeS;
    }

    public void setContentTypeS(String string2) {
        this.contentTypeS = string2;
    }

    public static enum Type {
        GET,
        HEADER,
        BODY;

    }
}

