/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.task.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mgtv.json.JsonInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class MultiParts
implements JsonInterface {
    private String boundary = UUID.randomUUID().toString();
    private List<Part> parts = new ArrayList<Part>();

    public String getBoundary() {
        return this.boundary;
    }

    public MultiParts setBoundary(@NonNull String string2) {
        this.boundary = string2;
        return this;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public MultiParts put(@NonNull String string2, @Nullable String string3) {
        Part part;
        if (string3 == null) {
            part = null;
        } else {
            part = new Part();
            part.value = string3;
        }
        part.contentType = "text/plain";
        this.put(string2, part);
        return this;
    }

    public MultiParts put(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull byte[] byArray) {
        Part part = new Part();
        part.fileName = string3;
        part.contentType = string4;
        this.put(string2, part);
        return this;
    }

    public MultiParts put(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull byte[] byArray, int n2, int n3) {
        Part part = new Part();
        part.fileName = string3;
        part.contentType = string4;
        this.put(string2, part);
        return this;
    }

    public MultiParts put(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull File file) {
        Part part = new Part();
        part.fileName = string3;
        part.contentType = string4;
        part.file = file;
        this.put(string2, part);
        return this;
    }

    private void put(@NonNull String string2, @Nullable Part part) {
        int n2 = 0;
        int n3 = -1;
        for (Part part2 : this.parts) {
            if (part2.name.equals(string2)) {
                n3 = n2;
                break;
            }
            ++n2;
        }
        if (part == null) {
            if (n3 != -1) {
                this.parts.remove(n3);
            }
        } else {
            part.name = string2;
            if (n3 != -1) {
                this.parts.set(n3, part);
            } else {
                this.parts.add(part);
            }
        }
    }

    public void writeTo(MultipartBody.Builder builder) {
        builder.setType(MultipartBody.FORM);
        for (Part part : this.parts) {
            if (part.file != null) {
                builder.addFormDataPart(part.name, part.fileName, RequestBody.create((MediaType)MediaType.parse((String)part.contentType), (File)part.file));
                continue;
            }
            builder.addPart(MultipartBody.Part.createFormData((String)part.name, null, (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)part.contentType), (String)part.value)));
        }
    }

    private static class Part
    implements JsonInterface {
        private static final long serialVersionUID = -4650049538168025353L;
        String name;
        String value;
        String fileName;
        String contentType;
        File file;

        private Part() {
        }
    }
}

