/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.thirdsdk.playcore.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.hunantv.imgo.log.e;
import com.hunantv.imgo.util.PreferencesUtil;
import com.hunantv.imgo.util.s;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.player.MgtvByteBufferPlayerDataSource;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerDataSource;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.MgtvPlayerLogger;
import com.hunantv.media.player.helper.BuildHelper;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.subtitle.MediaFormat;
import com.hunantv.media.player.subtitle.SubtitleConfig;
import com.hunantv.media.player.subtitle.SubtitleSource;
import com.hunantv.media.recoder.GifRecorder;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.widget.ISubtitle;
import com.hunantv.media.widget.IVideoView;
import com.hunantv.media.widget.MgtvVideoView;
import com.mgtv.thirdsdk.playcore.a.a;
import com.mgtv.thirdsdk.playcore.b.b;
import com.mgtv.thirdsdk.playcore.b.c;
import com.mgtv.thirdsdk.playcore.callback.ImgoPlayerReportInterface;
import com.mgtv.thirdsdk.playcore.callback.PlayerListener;
import com.mgtv.thirdsdk.playcore.utils.ExTicker;
import com.mgtv.thirdsdk.playcore.utils.d;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ImgoPlayerView
extends FrameLayout
implements ImgoPlayerReportInterface {
    public static final String TAG = "[ImgoPlayerView]";
    public static final int INFO_EXTRA_BUFFER_FIRST_LOAD = 0;
    public static final int EXTRA_NORMAL_BUFFER = 1;
    public static final int EXTRA_SEEK_BUFFER = 2;
    public static final int DISPLAY_TYPE_FULL_VIDEO = 0;
    public static final int DISPLAY_TYPE_FULL_SCREEN = 1;
    public static final int DISPLAY_TYPE_DEFAULT = 0;
    public static final String LOGMSG_PLAYER_CALLBACK = "PlayerCallBack";
    public static final int DISMISS_BUFFERING_LAYOUT = 14;
    public static final int GET_BUFFER_NETSPEED = 15;
    public static final int RENDER_TYPE_SURFACE = 0;
    public static final int RENDER_TYPE_TEXTURE = 1;
    public Context context;
    public IVideoView mVideoView;
    public PlayerListener.OnCompletionListener mOnCompletionListener;
    public PlayerListener.OnSeekCompleteListener mOnSeekCompleteListener;
    public PlayerListener.OnPreparedListener mOnPreparedListener;
    public PlayerListener.OnStartListener mOnStartListener;
    public PlayerListener.OnPauseListener mOnPauseListener;
    public PlayerListener.OnErrorListener mOnErrorListener;
    public PlayerListener.OnInfoListener mOnInfoListener;
    public PlayerListener.OnBufferListener mBufferListener;
    public PlayerListener.onEventInfoListener mOnEventInfoListener;
    public OnBufferingListener mOnBufferingListener;
    public PlayerListener.OnTickListener mOnTickListener;
    public PlayerListener.OnWarningListener mOnWarningListener;
    public PlayerListener.OnChangeSourceListener mOnChangeSourceListener;
    public PlayerListener.OnUpdateStatusListener mOnUpdateStatusListener;
    public PlayerListener.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    public PlayerListener.OnSubtitleCallback mOnSubtitlesCallback;
    public String videoId;
    public String videoPath;
    public a breakPoint;
    public boolean mBuffering;
    public View mBufferingView;
    public boolean showBufferingView = true;
    public Handler handler = new InternalHandler(this);
    public View mGestureView;
    public int mDataReceiveMillis;
    public int mNetworkConnectMillis;
    public int mBufferTimeoutMs;
    public com.mgtv.thirdsdk.playcore.a.b breakPointDao;
    public boolean isPlayOK;
    public boolean isFirstPlay;
    public ExTicker mPlayerTick;
    public boolean mBeforeFirstFrame = true;
    public long mStartPlayTime;
    public long mFirstFrameCostMs;
    public long mErrorCostMs;
    public int mPerformanceTimes;
    public int mTotalCPUAdd;
    public int mTotalRSSAdd;
    public long mStartBufferingTime;
    public int mBufferingNum;
    public long mBufferingTime;
    public int mSeekingNum;
    public long mSeekingTime;
    public BufferTime mLastBufferTime = new BufferTime();
    public String mErrorMsg = "";
    public boolean isPosPlay;
    public static final int MAX_LIST_SIZE = 20;
    public List<Integer> mDownloadSpeedList;
    public boolean isBufferStart = false;
    public int mCurrentDisplayType = 0;
    public int mTargetDisplayType = 0;
    public com.mgtv.thirdsdk.playcore.utils.a mCpuMonitor = new com.mgtv.thirdsdk.playcore.utils.a();
    public boolean mFirstPlay = true;
    public int mJustLookDuration;
    public int mDataSourceType;
    public static final String TAG_PLAYER_ADSDK = "adsdk";
    public int mRenderType;
    public boolean mAccurateSeekEnable;
    public boolean mPlayBreakPoint = true;
    public b mNetStatusMonitor;
    private boolean isEnableQualityEnhance;
    public ReportParams mReportParams;
    private boolean changeDefinition;
    public boolean isLive;
    public IVideoView.OnVideoSizeChangedListener mVideoSizeChangedListener = new IVideoView.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(int n2, int n3) {
            e.b(ImgoPlayerView.TAG, "onVideoSizeChanged: w:" + n2 + "; h:" + n3, true);
            if (ImgoPlayerView.this.mOnVideoSizeChangedListener != null) {
                ImgoPlayerView.this.mOnVideoSizeChangedListener.onVideoSizeChanged(n2, n3);
            }
        }
    };
    public IVideoView.OnUpdateStatusListener mUpdateStatusListener = new IVideoView.OnUpdateStatusListener(){

        public void onUpdateStatus() {
            if (ImgoPlayerView.this.mOnUpdateStatusListener != null && ImgoPlayerView.this.mVideoView != null) {
                ImgoPlayerView.this.mOnUpdateStatusListener.onUpdateStatus(ImgoPlayerView.this.isPlaying(), ImgoPlayerView.this.mVideoView.isPrepared(), ImgoPlayerView.this.mVideoView.isCompletion());
            }
        }
    };
    public boolean mHandPause;
    public IVideoView.OnPreparedListener mPreparedListener = new IVideoView.OnPreparedListener(){

        public void onPrepared() {
            if (!ImgoPlayerView.this.isFirstPlay) {
                return;
            }
            if (ImgoPlayerView.this.mFirstPlay) {
                ImgoPlayerView.this.mFirstPlay = false;
            }
            if (com.mgtv.thirdsdk.playcore.utils.c.g()) {
                ImgoPlayerView.this.breakPoint = com.mgtv.thirdsdk.playcore.utils.c.a(ImgoPlayerView.this.breakPointDao, ImgoPlayerView.this.videoId);
            }
            if (com.mgtv.thirdsdk.playcore.utils.c.g() && ImgoPlayerView.this.breakPoint != null && ImgoPlayerView.this.breakPoint.e() != 0) {
                if (ImgoPlayerView.this.mPlayBreakPoint) {
                    int n2 = ImgoPlayerView.this.breakPoint.e();
                    ImgoPlayerView.this.seekTo(n2);
                }
                ImgoPlayerView.this.isPosPlay = true;
            } else if (ImgoPlayerView.this.changeDefinition && !ImgoPlayerView.this.isLive && ImgoPlayerView.this.mPlayBreakPoint && ImgoPlayerView.this.breakPoint != null) {
                int n3 = ImgoPlayerView.this.breakPoint.e();
                ImgoPlayerView.this.seekTo(n3);
            }
            if (ImgoPlayerView.this.mOnPreparedListener != null) {
                ImgoPlayerView.this.mOnPreparedListener.onPrepared();
            }
        }
    };
    public IVideoView.OnEventInfoListener mEventInfoListener = new IVideoView.OnEventInfoListener(){

        public void onInfo(int n2, int n3) {
            if (ImgoPlayerView.this.mOnEventInfoListener != null) {
                ImgoPlayerView.this.mOnEventInfoListener.onInfo(n2, n3);
            }
        }
    };
    public IVideoView.OnStartListener mStartListener = new IVideoView.OnStartListener(){

        public void onStart() {
            ImgoPlayerView.this.mNetStatusMonitor.c();
            if (!ImgoPlayerView.this.isBufferStart && ImgoPlayerView.this.mPlayerTick != null) {
                ImgoPlayerView.this.mPlayerTick.c();
            }
            ImgoPlayerView.this.mCpuMonitor.b();
            if (ImgoPlayerView.this.mOnStartListener != null) {
                ImgoPlayerView.this.mOnStartListener.onStart();
            }
        }
    };
    public IVideoView.OnPauseListener mPauseListener = new IVideoView.OnPauseListener(){

        public void onPause() {
            ImgoPlayerView.this.mNetStatusMonitor.a();
            if (ImgoPlayerView.this.mPlayerTick != null) {
                ImgoPlayerView.this.mPlayerTick.b();
            }
            ImgoPlayerView.this.mCpuMonitor.a();
            if (ImgoPlayerView.this.mOnPauseListener != null) {
                ImgoPlayerView.this.mOnPauseListener.onPause();
            }
        }
    };
    public IVideoView.OnCompletionListener mCompletionListener = new IVideoView.OnCompletionListener(){

        public void onCompletion(int n2, int n3) {
            ImgoPlayerView.this.onInnerCompletion(n2, n3);
        }
    };
    public IVideoView.OnErrorListener mErrorListener = new IVideoView.OnErrorListener(){

        public boolean onError(int n2, int n3) {
            if (ImgoPlayerView.this.mVideoView != null) {
                ImgoPlayerView.this.mErrorMsg = ImgoPlayerView.this.mErrorMsg + "_ErrorUrl_" + ImgoPlayerView.this.mVideoView.getErrorUrl() + "/n";
            }
            if (ImgoPlayerView.this.mVideoView != null && ImgoPlayerView.this.isMgtvPlayer()) {
                DecimalFormat decimalFormat = new DecimalFormat(".00");
            }
            if (ImgoPlayerView.this.mPlayerTick != null) {
                ImgoPlayerView.this.mPlayerTick.d();
            }
            if (ImgoPlayerView.this.isPlayOK) {
                try {
                    com.mgtv.thirdsdk.playcore.utils.c.a(ImgoPlayerView.this.breakPointDao, ImgoPlayerView.this.videoId, ImgoPlayerView.this.videoPath, ImgoPlayerView.this.getCurrentPosition(), ImgoPlayerView.this.getDuration());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ImgoPlayerView.this.callbackError(n2, n3);
            ImgoPlayerView.this.mNetStatusMonitor.b(ImgoPlayerView.this.context);
            return true;
        }
    };
    public IVideoView.OnSeekCompleteListener mSeekCompleteListener = new IVideoView.OnSeekCompleteListener(){

        public void onSeekComplete() {
            long l2 = ImgoPlayerView.this.getCurrentPosition();
            if (ImgoPlayerView.this.mOnSeekCompleteListener != null) {
                ImgoPlayerView.this.mOnSeekCompleteListener.onSeekComplete();
            }
        }
    };
    public IVideoView.OnInfoListener mInfoListener = new IVideoView.OnInfoListener(){

        public boolean onInfo(int n2, int n3) {
            if (n2 == 900) {
                ImgoPlayerView.this.isPlayOK = true;
            }
            System.out.println("onInfo what = " + n2);
            switch (n2) {
                case 701: {
                    e.b(ImgoPlayerView.this.getLogTag(), "start buffering:what" + n2 + "extra:" + n3, true);
                    ImgoPlayerView.this.isBufferStart = true;
                    ImgoPlayerView.this.mStartBufferingTime = System.currentTimeMillis();
                    if (ImgoPlayerView.this.mPlayerTick != null) {
                        ImgoPlayerView.this.mPlayerTick.b();
                    }
                    ImgoPlayerView.this.mCpuMonitor.a();
                    ImgoPlayerView.this.startBuffering(n3);
                    break;
                }
                case 702: {
                    e.b(ImgoPlayerView.this.getLogTag(), "end buffering:what" + n2 + "extra:" + n3, true);
                    if (ImgoPlayerView.this.isBufferStart) {
                        ImgoPlayerView.this.mLastBufferTime.buffertime = ImgoPlayerView.this.mStartBufferingTime > 0L ? System.currentTimeMillis() - ImgoPlayerView.this.mStartBufferingTime : 0L;
                        ImgoPlayerView.this.mLastBufferTime.type = 0;
                        if (n3 == 2) {
                            ImgoPlayerView.this.mLastBufferTime.type = 1;
                            ++ImgoPlayerView.this.mSeekingNum;
                            ImgoPlayerView.this.mSeekingTime += ImgoPlayerView.this.mLastBufferTime.buffertime;
                        } else {
                            ImgoPlayerView.this.mLastBufferTime.type = 0;
                            ++ImgoPlayerView.this.mBufferingNum;
                            ImgoPlayerView.this.mBufferingTime += ImgoPlayerView.this.mLastBufferTime.buffertime;
                        }
                        e.a(ImgoPlayerView.this.getLogTag(), "buffering cost(ms):" + ImgoPlayerView.this.mLastBufferTime.buffertime + ",type:" + n3, true);
                        e.a(ImgoPlayerView.this.getLogTag(), "buffering_end(ms) mBufferingNum:" + ImgoPlayerView.this.mBufferingNum + ",mBufferingTime:" + ImgoPlayerView.this.mBufferingTime, true);
                        e.a(ImgoPlayerView.this.getLogTag(), "buffering_end(ms) mSeekingTime:" + ImgoPlayerView.this.mSeekingNum + ",mSeekingTime:" + ImgoPlayerView.this.mSeekingTime, true);
                        if (ImgoPlayerView.this.mBufferListener != null) {
                            ImgoPlayerView.this.mBufferListener.onBufferUpdate("100");
                        }
                        ImgoPlayerView.this.isBufferStart = false;
                    }
                    if (ImgoPlayerView.this.mPlayerTick != null && ImgoPlayerView.this.isPlaying()) {
                        ImgoPlayerView.this.mPlayerTick.c();
                    }
                    ImgoPlayerView.this.mCpuMonitor.b();
                    ImgoPlayerView.this.endBuffering(n3);
                    break;
                }
                case 900: {
                    if (ImgoPlayerView.this.mBeforeFirstFrame) {
                        ImgoPlayerView.this.mFirstFrameCostMs = System.currentTimeMillis() - ImgoPlayerView.this.mStartPlayTime;
                        ImgoPlayerView.this.mBeforeFirstFrame = false;
                        e.a(ImgoPlayerView.this.getLogTag(), "MEDIA_INFO_RENDERING_START cost(ms):" + ImgoPlayerView.this.mFirstFrameCostMs, true);
                    }
                    if (ImgoPlayerView.this.isFirstPlay) {
                        if (ImgoPlayerView.this.mPlayerTick != null) {
                            ImgoPlayerView.this.mPlayerTick.a();
                        }
                        if (ImgoPlayerView.this.mOnInfoListener != null) {
                            ImgoPlayerView.this.mOnInfoListener.onInfo(n2, n3);
                        }
                        if (ImgoPlayerView.this.mVideoView != null) {
                            // empty if block
                        }
                        ImgoPlayerView.this.isFirstPlay = false;
                    }
                    return true;
                }
                case 700001: {
                    try {
                        if (ImgoPlayerView.this.mDownloadSpeedList != null) {
                            if (ImgoPlayerView.this.mDownloadSpeedList.size() >= 20) {
                                ImgoPlayerView.this.mDownloadSpeedList.remove(0);
                            }
                            ImgoPlayerView.this.mDownloadSpeedList.add(n3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
                case 2803: {
                    ImgoPlayerView.this.mDataSourceType = n3;
                    break;
                }
            }
            if (ImgoPlayerView.this.mOnInfoListener != null) {
                ImgoPlayerView.this.mOnInfoListener.onInfo(n2, n3);
            }
            return true;
        }
    };
    public MgtvPlayerListener.OnWarningListener mWaringListener = new MgtvPlayerListener.OnWarningListener(){

        public void onTsSkip(String string2, int n2, int n3) {
            if (ImgoPlayerView.this.isBeforeFirstFrame()) {
                return;
            }
            if (ImgoPlayerView.this.mOnWarningListener != null) {
                ImgoPlayerView.this.mOnWarningListener.onTsSkip(string2, n2, n3);
            }
        }

        public void onWarning(int n2, String string2, String string3, Object object) {
            if (ImgoPlayerView.this.mOnWarningListener != null) {
                ImgoPlayerView.this.mOnWarningListener.onWarning(n2, string2, string3);
            }
        }
    };
    public IVideoView.SurfaceHolderListener mSurfaceHolderListener = new IVideoView.SurfaceHolderListener(){

        public void surfaceDestroyed() {
            if (ImgoPlayerView.this.isPlayOK && !ImgoPlayerView.this.mVideoView.isCompletion()) {
                com.mgtv.thirdsdk.playcore.utils.c.a(ImgoPlayerView.this.breakPointDao, ImgoPlayerView.this.videoId, ImgoPlayerView.this.videoPath, ImgoPlayerView.this.getCurrentPosition(), ImgoPlayerView.this.getDuration());
            }
            System.out.println("mSurfaceHolderListener surfaceDestroyed ");
        }

        public void surfaceCreated() {
            System.out.println("mSurfaceHolderListener surfaceCreated ");
        }

        public void surfaceChanged() {
            System.out.println("mSurfaceHolderListener surfaceChanged ");
        }
    };
    public IVideoView.OnChangeSourceListener mChangeSourceListener = new IVideoView.OnChangeSourceListener(){

        public void onChangeSourceInfo(String string2, int n2, int n3) {
            if (ImgoPlayerView.this.mOnChangeSourceListener != null) {
                ImgoPlayerView.this.mOnChangeSourceListener.onChangeSourceInfo(string2, n2, n3);
            }
        }

        public void onChangeSourceSuccess(String string2, int n2, int n3) {
            if (ImgoPlayerView.this.mOnChangeSourceListener != null) {
                ImgoPlayerView.this.mOnChangeSourceListener.onChangeSourceSuccess(string2, n2, n3);
            }
        }

        public void onChangeSourceFailed(String string2, int n2, int n3) {
            if (ImgoPlayerView.this.mOnChangeSourceListener != null) {
                ImgoPlayerView.this.mOnChangeSourceListener.onChangeSourceFailed(string2, n2, n3);
            }
        }
    };
    public String playerTag = "default";
    public ISubtitle.SubtitleCallback mSubTitleCallback = new ISubtitle.SubtitleCallback(){

        public void onSuccess(SubtitleSource subtitleSource) {
            if (ImgoPlayerView.this.mOnSubtitlesCallback != null) {
                ImgoPlayerView.this.mOnSubtitlesCallback.onSuccess(subtitleSource);
            }
        }

        public void onError(SubtitleSource subtitleSource) {
            if (ImgoPlayerView.this.mOnSubtitlesCallback != null) {
                ImgoPlayerView.this.mOnSubtitlesCallback.onError(subtitleSource);
            }
        }
    };

    public String getLogTag() {
        return this.mVideoView == null ? TAG : "[" + this.mVideoView.getLogTagKey() + "]" + TAG;
    }

    public void setIsLive(boolean bl2) {
        this.isLive = bl2;
    }

    public long getLoadingSpeed() {
        if (this.mVideoView != null) {
            return this.mVideoView.getDLSpeedB();
        }
        return 0L;
    }

    public ImgoPlayerView(Context context) {
        super(context);
        this.initContent(context, 0, true);
    }

    public ImgoPlayerView(Context context, int n2) {
        super(context);
        this.initContent(context, n2, true);
    }

    public ImgoPlayerView(Context context, int n2, boolean bl2) {
        super(context);
        this.isEnableQualityEnhance = bl2;
        this.initContent(context, n2, true);
    }

    public ImgoPlayerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initContent(context, 0, true);
    }

    public ImgoPlayerView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initContent(context, 0, true);
    }

    public void initContent(Context context, int n2, boolean bl2) {
        if (context instanceof Activity && n2 == 1) {
            s.a((Activity)context);
        }
        this.context = context;
        if (this.isInEditMode()) {
            return;
        }
        this.attachVideoView(n2);
        this.mNetStatusMonitor = new b();
        this.initGlobalLayoutListener();
    }

    public void attachVideoView(int n2) {
        if (this.mVideoView != null) {
            d.a((ViewGroup)this, (View)this.mVideoView);
        }
        if (!this.isTextureViewValid()) {
            n2 = 0;
        }
        this.mVideoView = this.isEnableQualityEnhance ? new MgtvVideoView(this.context, n2, true, true) : new MgtvVideoView(this.context, n2);
        this.mRenderType = n2;
        e.b(TAG, "mRenderType:" + this.mRenderType, true);
        if (com.mgtv.thirdsdk.playcore.utils.c.g()) {
            this.breakPointDao = com.mgtv.thirdsdk.playcore.utils.c.a(this.context);
        }
        this.mVideoView.setOnCompletionListener(this.mCompletionListener);
        this.mVideoView.setOnPreparedListener(this.mPreparedListener);
        this.mVideoView.setOnStartListener(this.mStartListener);
        this.mVideoView.setOnPauseListener(this.mPauseListener);
        this.mVideoView.setOnSeekCompleteListener(this.mSeekCompleteListener);
        this.mVideoView.setSurfaceHolderListener(this.mSurfaceHolderListener);
        this.mVideoView.setOnInfoListener(this.mInfoListener);
        this.mVideoView.setOnErrorListener(this.mErrorListener);
        this.mVideoView.setOnWarningListener(this.mWaringListener);
        this.mVideoView.setOnChangeSourceListener(this.mChangeSourceListener);
        this.mVideoView.setOnUpdateStatusListener(this.mUpdateStatusListener);
        this.mVideoView.setOnEventInfoListener(this.mEventInfoListener);
        this.setLastFrameRecovery(false);
        this.mVideoView.setOnVideoSizeChangedListener(this.mVideoSizeChangedListener);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        d.a((ViewGroup)this, (View)this.mVideoView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setImgoPlayerDebug(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setPlayerDebug(bl2);
        }
    }

    public void netMonitorNotPause() {
        if (this.mNetStatusMonitor != null) {
            this.mNetStatusMonitor.b();
        }
    }

    public void initGlobalLayoutListener() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (!PreferencesUtil.b("pref_player_hardware_render_open", true) && ImgoPlayerView.this.isHardwareAccelerated() && ImgoPlayerView.this.mOnWarningListener != null) {
                    ImgoPlayerView.this.mOnWarningListener.onWarning(80000003, "0", "");
                }
                if (!ImgoPlayerView.this.isHardwareAccelerated() && ImgoPlayerView.this.mRenderType == 1 && ImgoPlayerView.this.isTextureViewValid()) {
                    if (ImgoPlayerView.this.mVideoView != null) {
                        ImgoPlayerView.this.mVideoView.stop();
                    }
                    ImgoPlayerView.this.attachVideoView(0);
                }
                PreferencesUtil.a("pref_player_hardware_render_open", ImgoPlayerView.this.isHardwareAccelerated());
                if (!ImgoPlayerView.this.isHardwareAccelerated() && !PreferencesUtil.b("pref_player_hardware_render_unsupport_reported", false) && ImgoPlayerView.this.mOnWarningListener != null) {
                    ImgoPlayerView.this.mOnWarningListener.onWarning(80000002, "0", "");
                    PreferencesUtil.a("pref_player_hardware_render_unsupport_reported", true);
                }
                e.b(ImgoPlayerView.this.getLogTag(), "onGlobalLayout PREF_PLAYER_HARDWARE_RENDER_OPEN:" + PreferencesUtil.b("pref_player_hardware_render_open", true), true);
                if (Build.VERSION.SDK_INT >= 16) {
                    ImgoPlayerView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    ImgoPlayerView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    public void setOnNetStatusChangedListener(c c2) {
        this.mNetStatusMonitor.a(c2);
    }

    public void setLastFrameRecovery(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setLastFrameRecovery(bl2);
        }
    }

    public boolean isTextureViewValid() {
        return PreferencesUtil.b("pref_player_hardware_render_open", true);
    }

    public void setVolume(float f2) {
        if (this.mVideoView != null) {
            this.mVideoView.setVolume(f2, f2);
        }
    }

    public void setAspectRatio(int n2) {
        if (this.mVideoView != null) {
            this.mVideoView.setAspectRatio(n2);
        }
    }

    public int getVideoHeight() {
        if (this.mVideoView != null) {
            if (this.mVideoView.getRenderView() != null) {
                return this.mVideoView.getRenderView().getHeight();
            }
            return this.mVideoView.getVideoHeight();
        }
        return 0;
    }

    public int getVideoWidth() {
        if (this.mVideoView != null) {
            if (this.mVideoView.getRenderView() != null) {
                return this.mVideoView.getRenderView().getWidth();
            }
            return this.mVideoView.getVideoWidth();
        }
        return 0;
    }

    public void setBufferStatus(boolean bl2) {
        if (this.mVideoView != null) {
            if (bl2) {
                if (this.isMgtvPlayer() && this.mVideoView.isPrepared()) {
                    this.mVideoView.resumeLoadData();
                }
            } else if (this.isMgtvPlayer() && this.mVideoView.isPrepared()) {
                this.mVideoView.pauseLoadData();
            }
        }
    }

    public void setDisplayType(int n2, boolean bl2) {
        if (this.mVideoView == null || this.mCurrentDisplayType == n2 && !bl2) {
            return;
        }
        this.mTargetDisplayType = n2;
        int n3 = this.mVideoView.getVideoWidth();
        int n4 = this.mVideoView.getVideoHeight();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        switch (this.mTargetDisplayType) {
            case 1: {
                int n5;
                Point point = s.d(this.context);
                if (point == null) {
                    return;
                }
                int n6 = n5 = point.x;
                int n7 = n4 * n5 / n3;
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n6, n7, 17);
                ((View)this.mVideoView).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                break;
            }
            default: {
                FrameLayout.LayoutParams layoutParams;
                if (((View)this.mVideoView).getParent() != null) {
                    int n8 = ((View)((View)this.mVideoView).getParent()).getHeight() * 16 / 9;
                    layoutParams = new FrameLayout.LayoutParams(n8, -1, 17);
                } else {
                    layoutParams = new FrameLayout.LayoutParams(1920, -1, 17);
                }
                ((View)this.mVideoView).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.mCurrentDisplayType = this.mTargetDisplayType;
    }

    public void setZOrderMediaOverlay(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setZOrderMediaOverlay(bl2);
        }
    }

    public void setRenderViewVisible(int n2) {
        if (this.mVideoView != null) {
            this.mVideoView.setRenderViewVisible(n2);
        }
    }

    public void callbackError(int n2, int n3) {
        this.mErrorCostMs = System.currentTimeMillis() - this.mStartPlayTime;
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onError(n2, n3);
        }
    }

    public void startPlayer(String string2, String string3, String string4, String string5, String string6) {
        if (this.mVideoView == null) {
            this.callbackError(110000, 0);
        }
        this.mErrorMsg = "";
        this.endBuffering(1);
        if (this.mPlayerTick != null) {
            this.mPlayerTick.d();
        }
        if (string4 == null || "".equals(string4.trim())) {
            this.callbackError(7000011, 0);
            this.mNetStatusMonitor.b(this.context);
            return;
        }
        int n2 = 0;
        n2 = com.mgtv.thirdsdk.playcore.utils.b.b(string4);
        if (n2 != 0 || !TextUtils.isEmpty((CharSequence)string5) && (n2 = com.mgtv.thirdsdk.playcore.utils.b.b(string5)) != 0) {
            this.callbackError(7000011, n2);
            this.mNetStatusMonitor.b(this.context);
            return;
        }
        if (this.mDownloadSpeedList != null) {
            this.mDownloadSpeedList.clear();
            this.mDownloadSpeedList = null;
        }
        this.saveBreakPoint();
        this.mDownloadSpeedList = new LinkedList<Integer>();
        this.isBufferStart = false;
        this.isPlayOK = false;
        this.isFirstPlay = true;
        this.videoId = string6;
        this.mBeforeFirstFrame = true;
        this.mFirstFrameCostMs = 0L;
        this.mErrorCostMs = 0L;
        this.mStartPlayTime = System.currentTimeMillis();
        this.isPosPlay = false;
        this.mPerformanceTimes = 0;
        this.mTotalCPUAdd = 0;
        this.mTotalRSSAdd = 0;
        this.mBufferingNum = 0;
        this.mBufferingTime = 0L;
        this.mSeekingNum = 0;
        this.mSeekingTime = 0L;
        this.mVideoView.setTimeout(this.mNetworkConnectMillis, this.mDataReceiveMillis);
        this.mVideoView.setBufferTimeout(this.mBufferTimeoutMs);
        if (!this.supportChangeSourceAsync() || !com.mgtv.thirdsdk.playcore.utils.c.f(string5)) {
            this.openImgoSourceModule(false);
        }
        this.mVideoView.setReportParams(this.mReportParams);
        e.b(TAG, "m3u8:" + string3, true);
        e.b(TAG, "path:" + string4, true);
        e.b(TAG, "proxypath:" + string5, true);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            if (this.isFirstPlay) {
                this.mVideoView.setVideoPath(string5);
            } else {
                this.mVideoView.resetVideoPath(string5);
            }
        } else {
            MgtvByteBufferPlayerDataSource mgtvByteBufferPlayerDataSource = new MgtvByteBufferPlayerDataSource(string3.getBytes());
            this.mVideoView.setVideoDataSource((MgtvPlayerDataSource)mgtvByteBufferPlayerDataSource);
        }
        this.videoPath = string4;
        this.mNetStatusMonitor.a(this.context);
    }

    public void setPrepareStartMode(MgtvMediaPlayer.Prepared4StartMode prepared4StartMode) {
        if (this.mVideoView != null) {
            this.mVideoView.setPrepared4StartMode(prepared4StartMode);
        }
    }

    public void setNetWorkConnectTimeout(int n2) {
        this.mNetworkConnectMillis = n2;
    }

    public void setNetConfig(NetPlayConfig netPlayConfig) {
        if (this.mVideoView != null) {
            this.mVideoView.setNetPlayConfig(netPlayConfig);
        }
    }

    public void setDataReceiveTimeout(int n2) {
        this.mDataReceiveMillis = n2;
    }

    public void setBufferTimeout(int n2) {
        this.mBufferTimeoutMs = n2;
    }

    public void stop() {
        if (this.mVideoView != null) {
            this.mVideoView.stop();
        }
        e.b(TAG, "stop()", true);
    }

    public void reset(boolean bl2) {
        this.reset(bl2, false);
        e.b(TAG, "reset(" + bl2 + ")", true);
    }

    public void reset(boolean bl2, boolean bl3) {
        if (bl2) {
            this.saveBreakPoint();
        }
        this.mBeforeFirstFrame = true;
        this.isBufferStart = false;
        this.isLive = false;
        if (this.mPlayerTick != null) {
            this.mPlayerTick.d();
        }
        if (this.mVideoView != null) {
            this.mVideoView.cleanUri();
            this.mVideoView.reset();
            if (bl3) {
                this.mVideoView.resetRender();
            }
        }
        e.b(TAG, "reset(" + bl2 + "," + bl3 + ")", true);
    }

    public void release() {
        if (this.mVideoView != null) {
            this.mVideoView.release();
        }
    }

    public void saveBreakPoint() {
        if (this.getCurrentPosition() != 0 && this.mPlayBreakPoint && this.mVideoView != null && this.videoId != null && !this.videoId.trim().equals("") && !this.mVideoView.isCompletion()) {
            e.b(this.getLogTag(), "saveBreakPoint videoId:" + this.videoId, true);
            com.mgtv.thirdsdk.playcore.utils.c.a(this.breakPointDao, this.videoId, this.videoPath, this.getCurrentPosition(), this.getDuration());
        }
    }

    public void play() {
        if (this.mVideoView != null) {
            this.mVideoView.start();
        }
        this.mHandPause = false;
        e.b(TAG, "play()", true);
    }

    public void seekTo(int n2) {
        if (n2 < 0) {
            return;
        }
        e.b(TAG, "mJustLookDuration:" + this.mJustLookDuration + "   realDuration:" + this.getRealDuration() + "    position:" + n2, true);
        if (this.mJustLookDuration > 0 && n2 >= this.getRealDuration()) {
            this.stop();
            this.onInnerCompletion(0, 0);
            return;
        }
        if (this.mVideoView != null) {
            this.mVideoView.seekTo(n2);
        }
    }

    public void setIsChangeDefinition(boolean bl2) {
        this.changeDefinition = bl2;
    }

    public boolean getIsChangeDefinition() {
        return this.changeDefinition;
    }

    public void pause() {
        this.mHandPause = true;
        System.out.println("mPlayerControl pause2  ");
        this.pauseInner();
        e.b(TAG, "pause()", true);
    }

    public void pauseInner() {
        this.saveBreakPoint();
        System.out.println("mPlayerControl pauseInner  " + this.mVideoView);
        if (this.mVideoView != null) {
            this.mVideoView.pause();
        }
        e.b(TAG, "pauseInner()", true);
    }

    public boolean isDataLoaderPaused() {
        if (this.mVideoView != null) {
            return this.mVideoView.isDataLoadPaused();
        }
        return false;
    }

    public void exPause() {
        e.b(TAG, "exPause", true);
        if (this.mVideoView != null) {
            this.mVideoView.pause();
            if (this.isMgtvPlayer()) {
                if (this.mVideoView.isPrepared()) {
                    this.mVideoView.pauseLoadData();
                } else {
                    this.mVideoView.release();
                }
            }
        }
    }

    public void pauseLoadData() {
        if (this.mVideoView != null && this.isMgtvPlayer()) {
            if (this.mVideoView.isPrepared()) {
                this.mVideoView.pauseLoadData();
            } else {
                this.mVideoView.release();
            }
        }
    }

    @Override
    public int getCurrentPosition() {
        if (this.mVideoView != null) {
            return this.mVideoView.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public int getDuration() {
        if (this.mJustLookDuration > 0) {
            return this.mJustLookDuration;
        }
        if (this.mVideoView != null) {
            return this.mVideoView.getDuration();
        }
        return 0;
    }

    public int getRealDuration() {
        if (this.mVideoView != null) {
            return this.mVideoView.getDuration();
        }
        return 0;
    }

    public void setJustLookDuration(int n2) {
        this.mJustLookDuration = n2;
    }

    public boolean isPlaying() {
        if (this.mVideoView != null) {
            return this.mVideoView.isPlaying();
        }
        return false;
    }

    public int getMemoryPlayType() {
        if (this.mVideoView != null) {
            return this.mVideoView.getMemoryPlayType();
        }
        return 0;
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (this.mVideoView != null && this.mVideoView.isPrepared() && n2 != 4 && n2 != 24 && n2 != 25 && n2 != 82 && n2 != 5 && n2 != 6) {
            if (n2 == 79 || n2 == 85) {
                if (this.isPlaying()) {
                    this.pause();
                    e.b(TAG, "onKeyDown():pause", true);
                } else {
                    this.play();
                    e.b(TAG, "onKeyDown():play", true);
                }
                return true;
            }
            if (n2 == 86 && this.isPlaying()) {
                this.pause();
            }
        }
        return super.onKeyDown(n2, keyEvent);
    }

    public void onInnerCompletion(int n2, int n3) {
        if (n2 == 0) {
            this.removeRecordPoint();
        }
        if (this.mPlayerTick != null) {
            this.mPlayerTick.d();
        }
        this.breakPoint = null;
        if (this.mOnCompletionListener != null) {
            this.mOnCompletionListener.onCompletion(n2, n3);
        }
        this.mNetStatusMonitor.b(this.context);
    }

    public void startBuffering(int n2) {
        if (this.mBufferListener != null) {
            this.mBufferListener.onStartBuffer(n2);
        }
        if (!this.isDataLoaderPaused()) {
            this.showBufferingView();
        }
    }

    public void setStartPosMs(int n2) {
        if (this.mVideoView != null) {
            this.mVideoView.setStartPosMs(n2);
        }
    }

    public void setFileStartTimeMs(float f2) {
        if (this.mVideoView != null) {
            this.mVideoView.setFileStartTimeFloatS(f2);
        }
    }

    public void showBufferingView() {
        this.hideBufferingView();
        if (this.showBufferingView && this.mBufferingView != null && this.mBufferingView.getVisibility() == 4) {
            this.handler.removeMessages(14);
            this.handler.sendEmptyMessageDelayed(14, 500L);
        }
        this.mBuffering = true;
        this.handler.sendEmptyMessage(15);
    }

    public void endBuffering(int n2) {
        if (!this.mBuffering) {
            return;
        }
        if (this.mBufferListener != null) {
            this.mBufferListener.onEndBuffer(n2);
        }
        this.hideBufferingView();
    }

    public void hideBufferingView() {
        this.handler.removeMessages(14);
        if (this.mBufferingView != null && this.mBufferingView.getVisibility() == 0 && this.mBuffering) {
            this.mBufferingView.startAnimation(AnimationUtils.loadAnimation((Context)this.context, (int)0x10A0001));
            this.mBufferingView.setVisibility(4);
        }
        this.mBuffering = false;
    }

    public void setOnPreparedListener(PlayerListener.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnCompletionListener(PlayerListener.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnUpdateStatusListener(PlayerListener.OnUpdateStatusListener onUpdateStatusListener) {
        this.mOnUpdateStatusListener = onUpdateStatusListener;
    }

    public void setOnVideoSizeChangedListener(PlayerListener.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.mOnVideoSizeChangedListener = onVideoSizeChangedListener;
    }

    public void setOnSeekCompleteListener(PlayerListener.OnSeekCompleteListener onSeekCompleteListener) {
        this.mOnSeekCompleteListener = onSeekCompleteListener;
    }

    public void setOnErrorListener(PlayerListener.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnStartListener(PlayerListener.OnStartListener onStartListener) {
        this.mOnStartListener = onStartListener;
    }

    public void setOnEventInfoListener(PlayerListener.onEventInfoListener onEventInfoListener2) {
        this.mOnEventInfoListener = onEventInfoListener2;
    }

    public void setOnPauseListener(PlayerListener.OnPauseListener onPauseListener) {
        this.mOnPauseListener = onPauseListener;
    }

    public void setOnInfoListener(PlayerListener.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOnBufferListener(PlayerListener.OnBufferListener onBufferListener) {
        this.mBufferListener = onBufferListener;
    }

    public void setOnWarningListener(PlayerListener.OnWarningListener onWarningListener) {
        this.mOnWarningListener = onWarningListener;
    }

    public void setOnChangeSourceListener(PlayerListener.OnChangeSourceListener onChangeSourceListener) {
        this.mOnChangeSourceListener = onChangeSourceListener;
    }

    public void cleanUp() {
        this.mCpuMonitor.c();
        this.mFirstPlay = true;
        this.isBufferStart = false;
        e.b(this.getLogTag(), "cleanup", true);
        this.endBuffering(1);
        if (this.mPlayerTick != null) {
            this.mPlayerTick.d();
        }
        if (this.mBufferingView != null) {
            this.mBufferingView.clearAnimation();
        }
        if (this.mDownloadSpeedList != null) {
            this.mDownloadSpeedList.clear();
            this.mDownloadSpeedList = null;
        }
        try {
            this.mVideoView.release();
            this.mVideoView.reset();
            if (this.breakPointDao != null) {
                this.breakPointDao.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mNetStatusMonitor.b(this.context);
    }

    @Override
    public boolean isHardware() {
        return this.mVideoView != null ? this.mVideoView.isHardware() : true;
    }

    public static String getH264Decoder() {
        try {
            if (BuildHelper.isApi16_JellyBeanOrLater()) {
                return MediaCodecHelp.getH264Decoder();
            }
        }
        catch (Exception exception) {
            return "unknown";
        }
        return "unknown";
    }

    @Override
    public boolean isCompletion() {
        if (this.mVideoView != null) {
            return this.mVideoView.isCompletion();
        }
        return true;
    }

    public static String getVersion() {
        return MgtvVideoView.getVersion();
    }

    @Override
    public String getPlayerVersion() {
        if (this.mVideoView != null) {
            return this.mVideoView.getPlayerVersion();
        }
        return "default";
    }

    public void setOnTickListener(PlayerListener.OnTickListener onTickListener, int n2) {
        this.mOnTickListener = onTickListener;
        if (this.mPlayerTick != null) {
            this.mPlayerTick.d();
            this.mPlayerTick = null;
        }
        this.mPlayerTick = new ExTicker(n2);
        this.mPlayerTick.a(new ExTicker.b(){

            @Override
            public void onTick(int n2) {
                e.b(ImgoPlayerView.this.getLogTag(), "onTick :" + n2, true);
                if (ImgoPlayerView.this.mOnTickListener != null) {
                    ImgoPlayerView.this.mOnTickListener.onTick(ImgoPlayerView.this.getCurrentPosition(), n2, ImgoPlayerView.this.mPlayerTick.e());
                }
            }
        });
    }

    public void removeRecordPoint() {
        if (this.breakPointDao == null) {
            return;
        }
        if (this.videoId != null && !this.videoId.trim().equals("")) {
            e.b(this.getLogTag(), "saveRecordPoint videoId:" + this.videoId, true);
            com.mgtv.thirdsdk.playcore.utils.c.a(this.getContext(), this.videoId);
        }
    }

    @Override
    public StreamInfo getStreamInfo() {
        StreamInfo streamInfo = new StreamInfo();
        if (this.mVideoView == null) {
            return streamInfo;
        }
        streamInfo.videoW = this.mVideoView.getVideoWidth();
        streamInfo.videoH = this.mVideoView.getVideoHeight();
        streamInfo.bitRate = this.mVideoView.getBitRate();
        streamInfo.fps = this.mVideoView.getFPS();
        return streamInfo;
    }

    @Override
    public PerformanceInfo getPerformanceInfo() {
        PerformanceInfo performanceInfo = new PerformanceInfo();
        if (this.mPerformanceTimes != 0) {
            performanceInfo.cpuRatio = this.mTotalCPUAdd / this.mPerformanceTimes;
            performanceInfo.RSS = this.mTotalRSSAdd / this.mPerformanceTimes;
        }
        performanceInfo.pos_play = this.isPosPlay ? 1 : 0;
        return performanceInfo;
    }

    @Override
    public TimeCostInfo getTimeCostInfo() {
        TimeCostInfo timeCostInfo = new TimeCostInfo();
        timeCostInfo.first_frame_cost_ms = this.mFirstFrameCostMs;
        timeCostInfo.error_cost_ms = this.mErrorCostMs;
        return timeCostInfo;
    }

    @Override
    public BufferingInfo getBufferingInfo() {
        BufferingInfo bufferingInfo = new BufferingInfo();
        bufferingInfo.buffering_num = this.mBufferingNum;
        bufferingInfo.buffering_time = this.mBufferingTime;
        return bufferingInfo;
    }

    @Override
    public SeekingInfo getSeekingInfo() {
        SeekingInfo seekingInfo = new SeekingInfo();
        seekingInfo.seeking_num = this.mSeekingNum;
        seekingInfo.seeking_time = this.mSeekingTime;
        return seekingInfo;
    }

    @Override
    public String getErrorMsg() {
        if (this.mVideoView == null) {
            return this.mErrorMsg;
        }
        this.mErrorMsg = this.mVideoView.getErrorMsg();
        return this.mErrorMsg;
    }

    public float getRecentDownloadSpeed() {
        if (this.mDownloadSpeedList == null || this.mDownloadSpeedList.size() <= 0) {
            return 0.0f;
        }
        float f2 = 0.0f;
        try {
            long l2 = 0L;
            LinkedList<Integer> linkedList = new LinkedList<Integer>(this.mDownloadSpeedList);
            for (Integer n2 : linkedList) {
                l2 += (long)n2.intValue();
            }
            f2 = (float)l2 / (float)(1000 * linkedList.size());
        }
        catch (Exception exception) {
            return 0.0f;
        }
        return f2;
    }

    @Override
    public BufferTime getLastBufferTime() {
        return this.mLastBufferTime;
    }

    @Override
    public boolean isBeforeFirstFrame() {
        return this.mBeforeFirstFrame;
    }

    public void setPlayBackSpeed(float f2) {
        if (this.mVideoView != null && this.isMgtvPlayer()) {
            this.mVideoView.setPlaybackSpeed(f2);
        }
    }

    public void changeSourceAsync(String string2, int n2, int n3, int n4) {
        if (this.mVideoView != null && this.isMgtvPlayer()) {
            if (this.supportChangeSourceAsync() && com.mgtv.thirdsdk.playcore.utils.c.f(string2)) {
                this.mVideoView.changeSourceAsync(string2, n2, n3, n4);
            } else {
                if (this.mOnChangeSourceListener != null) {
                    this.mOnChangeSourceListener.onChangeSourceFailed(string2, 7000013, 0);
                }
                this.openImgoSourceModule(false);
            }
        }
    }

    public boolean supportChangeSourceAsync() {
        return this.mVideoView != null && this.mVideoView.isImgoSourceModuleOpen() && !BuildHelper.supportX86() && this.mDataSourceType == 1;
    }

    public void openImgoSourceModule(boolean bl2) {
        this.mDataSourceType = bl2 ? 1 : 0;
        if (this.mVideoView != null) {
            this.mVideoView.openImgoDSModule(bl2);
        }
    }

    @Override
    public boolean isImgoSourceModuleOpen() {
        if (this.mVideoView != null) {
            return this.mVideoView.isImgoSourceModuleOpen();
        }
        return false;
    }

    public void setStreamKey(int n2) {
        if (this.mVideoView != null) {
            this.mVideoView.setStreamKey(n2);
        }
    }

    @Override
    public int getDataSourceType() {
        return this.mDataSourceType;
    }

    @Override
    public int getRenderType() {
        switch (this.mRenderType) {
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public boolean isMgtvPlayer() {
        return true;
    }

    public void reBindTexture() {
        if (this.mVideoView != null) {
            this.mVideoView.reBindTexture();
        }
    }

    public void setTag(String string2) {
        this.playerTag = string2;
    }

    public String getTag() {
        return this.playerTag;
    }

    public void setAccurateSeekEnable(boolean bl2) {
        this.mAccurateSeekEnable = bl2;
        if (this.mVideoView != null) {
            this.mVideoView.setAccurateSeekEnable(this.mAccurateSeekEnable);
        }
    }

    @Override
    public boolean isAccurateSeekEnable() {
        return this.mAccurateSeekEnable;
    }

    public void setNetAddrinfo(int n2, int n3) {
        if (this.mVideoView != null) {
            this.mVideoView.setNetAddrinfo(n2, n3);
        }
    }

    public void setNetAddrinfo(int n2, int n3, boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setNetAddrinfo(n2, n3, bl2);
        }
    }

    public Bitmap getSnapshot(int n2, int n3) {
        Bitmap bitmap = null;
        if (this.mVideoView != null) {
            bitmap = this.mVideoView.getSnapshot(n2, n3);
        }
        return bitmap;
    }

    public boolean isSupportedSnapshot() {
        if (this.mVideoView != null) {
            return this.mVideoView.isSupportedSnapshot();
        }
        return false;
    }

    public void setReportParams(ReportParams reportParams) {
        this.mReportParams = reportParams;
    }

    @Override
    public ReportParams getReportParams() {
        return this.mReportParams;
    }

    public void configTsNotSkip(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.configTsNotSkip(bl2);
        }
    }

    public void configLoadMaxRetryTime(int n2) {
        if (this.mVideoView != null) {
            this.mVideoView.configLoadMaxRetryTime(n2);
        }
    }

    public void configWeakNetSpeed(int n2) {
        if (this.mVideoView != null) {
            this.mVideoView.configWeakNetSpeed(n2);
        }
    }

    public int getTotalBuffering() {
        if (this.mVideoView != null) {
            int n2 = this.mVideoView.getTotalBuffering();
            return n2 * this.mVideoView.getDuration() / 100;
        }
        return 0;
    }

    public void setDataSourceInfo(MgtvMediaPlayer.DataSourceInfo dataSourceInfo) {
        if (this.mVideoView != null) {
            this.mVideoView.setDataSourceInfo(dataSourceInfo);
        }
    }

    public String getVideoId() {
        return this.videoId;
    }

    public void setPlayerHardwareMode(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setPlayerHardwareMode(bl2);
        }
    }

    public void setForceDecodeMode(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setForceDecodeMode(bl2);
        }
    }

    public void setSecure(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setSecure(bl2);
        }
    }

    public GifRecorder getGifRecorder() {
        if (this.mVideoView != null) {
            return this.mVideoView.getGifRecorder();
        }
        return null;
    }

    public MgtvMediaPlayer.PlayerExtraInfo getPlayerExtraInfo() {
        if (this.mVideoView != null) {
            return this.mVideoView.getPlayerExtraInfo();
        }
        return null;
    }

    public void toPlay() {
        this.play();
        e.b(TAG, "toPlay():", true);
    }

    public void toPause() {
        this.pause();
        e.b(TAG, "toPause():", true);
    }

    public void doubleClick() {
        if (this.mVideoView.isPrepared()) {
            if (this.isPlaying()) {
                this.pause();
                e.b(TAG, "doubleClick():pause", true);
            } else {
                this.play();
                e.b(TAG, "doubleClick():play", true);
            }
        }
    }

    public void setRenderFilter(IVideoView.RenderFilter renderFilter) {
        if (this.mVideoView != null) {
            this.mVideoView.setRenderFilter(renderFilter);
        }
    }

    public void setBackgroundStatus(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setBackground(bl2);
        }
    }

    public void setTsFlowTag(String string2) {
        if (this.mVideoView != null) {
            this.mVideoView.setTsFlowTag(string2);
        }
    }

    public void setOnSubtitlesCallback(PlayerListener.OnSubtitleCallback onSubtitleCallback) {
        this.mOnSubtitlesCallback = onSubtitleCallback;
    }

    public void setSubtitleSource(byte[] byArray) {
        if (this.mVideoView != null) {
            this.mVideoView.enableSubtitle(true);
            this.mVideoView.removeSubtitleSource();
            this.setSubtitlesConfig();
            this.mVideoView.setSubtitleCallback(this.mSubTitleCallback);
            Locale locale = com.mgtv.ssp.utils.language.c.a().b();
            String string2 = locale.getLanguage();
            this.mVideoView.setSubtitleSource(new SubtitleSource(byArray, MediaFormat.createSubtitleFormat((String)"application/x-subrip", (String)string2)));
        }
    }

    private void setSubtitlesConfig() {
        SubtitleConfig subtitleConfig = new SubtitleConfig();
        subtitleConfig.setBackgroundColor(0x7F000000);
        subtitleConfig.setPaddingBottomRatio(0.01f);
        subtitleConfig.setTextSizeRatio(0.06f);
        if (this.mVideoView != null) {
            this.mVideoView.setSubtitleConfig(subtitleConfig);
        }
    }

    public void removeSubtitle() {
        if (this.mVideoView != null) {
            this.mVideoView.removeSubtitleSource();
            this.mVideoView.enableSubtitle(false);
        }
    }

    static {
        MgtvPlayerLogger.setLogCallback((MgtvPlayerLogger.OnLogCallback)new MgtvPlayerLogger.OnLogCallback(){

            public void onLogCb(int n2, String string2, String string3, String string4) {
                switch (n2) {
                    case 0: {
                        e.a(string3, "(debug)" + string4, true);
                        break;
                    }
                    case 1: {
                        e.b(string3, "(info)" + string4, true);
                        break;
                    }
                    case 2: {
                        e.c(string3, "(warn)" + string4, true);
                        break;
                    }
                    case 3: {
                        e.d(string3, "(error)" + string4, true);
                        break;
                    }
                }
            }
        });
    }

    public static interface OnBufferingListener {
        public void onBuffering(String var1);
    }

    public static class InternalHandler
    extends Handler {
        WeakReference<ImgoPlayerView> wrObj;

        public InternalHandler(ImgoPlayerView imgoPlayerView) {
            this.wrObj = new WeakReference<ImgoPlayerView>(imgoPlayerView);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            if (this.wrObj != null && this.wrObj.get() != null) {
                ImgoPlayerView imgoPlayerView = (ImgoPlayerView)this.wrObj.get();
                switch (message.what) {
                    case 14: {
                        if (!imgoPlayerView.mBuffering) break;
                        Animation animation = AnimationUtils.loadAnimation((Context)imgoPlayerView.context, (int)0x10A0000);
                        animation.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }

                            public void onAnimationEnd(Animation animation) {
                                ImgoPlayerView imgoPlayerView = (ImgoPlayerView)InternalHandler.this.wrObj.get();
                                if (imgoPlayerView != null) {
                                    if (imgoPlayerView.mBuffering) {
                                        imgoPlayerView.mBufferingView.setVisibility(0);
                                    } else {
                                        imgoPlayerView.mBufferingView.startAnimation(AnimationUtils.loadAnimation((Context)imgoPlayerView.context, (int)0x10A0001));
                                    }
                                }
                            }
                        });
                        imgoPlayerView.mBufferingView.startAnimation(animation);
                        break;
                    }
                    case 15: {
                        if (!imgoPlayerView.mBuffering) break;
                        if (imgoPlayerView.mOnBufferingListener != null) {
                            imgoPlayerView.mOnBufferingListener.onBuffering(imgoPlayerView.mVideoView != null ? imgoPlayerView.mVideoView.getDLSpeedFormat() : "0KB/S");
                        }
                        if (imgoPlayerView.mBufferListener != null) {
                            imgoPlayerView.mBufferListener.onBufferUpdate(imgoPlayerView.mVideoView != null ? String.valueOf(imgoPlayerView.mVideoView.getBufferingPercentage()) : "0");
                        }
                        imgoPlayerView.handler.sendEmptyMessageDelayed(15, 100L);
                    }
                }
            }
        }
    }

    public static class SeekingInfo {
        public int seeking_num;
        public long seeking_time;
    }

    public static class BufferingInfo {
        public int buffering_num;
        public long buffering_time;
    }

    public static class TimeCostInfo {
        public long first_frame_cost_ms;
        public long error_cost_ms;
    }

    public static class PerformanceInfo {
        public int cpuRatio;
        public int RSS;
        public int pos_play;
    }

    public static class StreamInfo {
        public int videoW;
        public int videoH;
        public int bitRate;
        public int fps;
    }

    public static class BufferTime {
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_SEEK = 1;
        public int type;
        public long buffertime;
    }
}

