/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.thirdsdk.playcore.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.hunantv.imgo.util.p;
import com.mgtv.thirdsdk.playcore.utils.c;
import com.mgtv.thirdsdk.playcore.view.ImgoPlayerView;

public class MgtvPlayerView
extends FrameLayout {
    private static final String TAG = MgtvPlayerView.class.getSimpleName();
    private ImgoPlayerView mVideoPlayer;
    private FrameLayout mAdFrameLayout;
    private FrameLayout mAdControlFrameLayout;
    private FrameLayout mControlFrameLayout;

    public MgtvPlayerView(Context context) {
        this(context, null, 0);
    }

    public MgtvPlayerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MgtvPlayerView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init();
    }

    public void init() {
        this.initView();
    }

    public void initView() {
        this.initVideoView();
        this.initControlView();
        this.initAdVideoView();
    }

    public ImgoPlayerView getVideoPlayer() {
        return this.mVideoPlayer;
    }

    public FrameLayout getAdLayout() {
        return this.mAdFrameLayout;
    }

    public FrameLayout getAdControlFrameLayout() {
        return this.mAdControlFrameLayout;
    }

    public FrameLayout getControlLayout() {
        return this.mControlFrameLayout;
    }

    public void addFullView(View view) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeView(view);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void initVideoView() {
        this.mVideoPlayer = new ImgoPlayerView(this.getContext(), c.b(), false);
        this.configPlayer();
        this.addFullView((View)this.mVideoPlayer);
    }

    public void configPlayer() {
        this.mVideoPlayer.setPlayerHardwareMode(true);
        this.mVideoPlayer.setNetConfig(c.a());
        this.mVideoPlayer.setAccurateSeekEnable(false);
        int n2 = p.a(c.d(), -1) * 1000;
        int n3 = p.a(c.e(), -1) * 1000;
        int n4 = p.a(c.f(), -1) * 1000;
        if (n2 < 0) {
            this.mVideoPlayer.setNetWorkConnectTimeout(10000);
        }
        if (n3 < 0) {
            this.mVideoPlayer.setDataReceiveTimeout(10000);
        }
        if (n4 < 0) {
            this.mVideoPlayer.setBufferTimeout(180000);
        }
    }

    public void initControlView() {
        this.mControlFrameLayout = new FrameLayout(this.getContext());
        this.addFullView((View)this.mControlFrameLayout);
    }

    public void initAdVideoView() {
        this.mAdFrameLayout = new FrameLayout(this.getContext());
        this.addFullView((View)this.mAdFrameLayout);
        this.mAdControlFrameLayout = new FrameLayout(this.getContext());
        this.addFullView((View)this.mAdControlFrameLayout);
    }

    public void destory() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.cleanUp();
            this.mVideoPlayer = null;
        }
        if (this.mAdFrameLayout != null) {
            this.mAdFrameLayout = null;
        }
        if (this.mAdControlFrameLayout != null) {
            this.mAdControlFrameLayout = null;
        }
        if (this.mControlFrameLayout != null) {
            this.mControlFrameLayout = null;
        }
    }

    public void showRenderView() {
        if (this.mVideoPlayer == null) {
            return;
        }
        this.mVideoPlayer.setVisibility(0);
        this.mVideoPlayer.setAlpha(1.0f);
    }

    public void hideRenderView() {
        if (this.mVideoPlayer == null) {
            return;
        }
        this.mVideoPlayer.setVisibility(8);
        this.mVideoPlayer.setAlpha(0.0f);
    }

    public void removeSubtitleSource() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.removeSubtitle();
        }
    }

    public void setSubtitleSource(byte[] byArray) {
        if (this.mVideoPlayer == null) {
            return;
        }
        this.mVideoPlayer.setSubtitleSource(byArray);
    }
}

