/*
 * Decompiled with CFR 0.152.
 */
package com.mgtv.thirdsdk.playcore.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hunantv.imgo.util.b;
import com.hunantv.imgo.util.h;
import com.hunantv.imgo.util.s;
import java.lang.ref.WeakReference;

public class ScreenOrientationContainer
extends FrameLayout {
    private static final String TAG = "ScreenOrientationContainer";
    public static boolean isIgnoreScreenChange;
    private final InnerContentObserver observer = new InnerContentObserver(this, null);
    public boolean isAppLocked;
    public int currentOrientation = 1;
    protected int mCurrentRotation = 0;
    protected OrientationEventListener mOrientationEventListener;
    int mMarginLeft;
    int mMarginTop;
    int mMarginRight;
    int mMarginBottom;
    private boolean isSystemLocked;
    private boolean canChangeOrientation = true;
    private boolean needChangeScreenMode = true;
    private OnScreenOrientationChangeListener mOrientationChangeListener;
    private boolean isInChaosMode;
    private boolean isChaosPortrait;

    public ScreenOrientationContainer(Context context) {
        super(context);
        this.init(context);
    }

    public ScreenOrientationContainer(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public void setOrientationChangeListener(OnScreenOrientationChangeListener onScreenOrientationChangeListener) {
        this.mOrientationChangeListener = onScreenOrientationChangeListener;
    }

    private void handleChange() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ScreenOrientationContainer.this.setScreenOrientationAutoMode();
            }
        });
    }

    private void init(Context context) {
        int n2;
        if (this.isInEditMode()) {
            return;
        }
        if (context instanceof Activity && (n2 = ((Activity)context).getRequestedOrientation()) == 0) {
            this.currentOrientation = 2;
        }
        this.mCurrentRotation = this.getDisplayRotation();
        this.post(new Runnable(){

            @Override
            public void run() {
                ScreenOrientationContainer.this.setScreenOrientationAutoMode();
                ScreenOrientationContainer.this.getContext().getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"accelerometer_rotation"), true, (ContentObserver)ScreenOrientationContainer.this.observer);
            }
        });
        this.mOrientationEventListener = new OrientationEventListener(this.getContext()){

            public void onOrientationChanged(int n2) {
                if (ScreenOrientationContainer.this.isInChaosMode) {
                    if (Math.abs(n2 - 90) < 45 || Math.abs(n2 - 270) < 45) {
                        if (!ScreenOrientationContainer.this.isChaosPortrait) {
                            if (!(h.a(ScreenOrientationContainer.this.getContext()) && h.a() && h.b(ScreenOrientationContainer.this.getContext()))) {
                                ScreenOrientationContainer.this.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        ScreenOrientationContainer.this.setOrientation(ScreenOrientationContainer.this.getContext(), 4);
                                    }
                                }, 1000L);
                            }
                            ScreenOrientationContainer.this.isInChaosMode = false;
                            ScreenOrientationContainer.this.mOrientationEventListener.disable();
                        }
                    } else if ((n2 < 45 || n2 > 315) && ScreenOrientationContainer.this.isChaosPortrait) {
                        if (!(h.a(ScreenOrientationContainer.this.getContext()) && h.a() && h.b(ScreenOrientationContainer.this.getContext()))) {
                            ScreenOrientationContainer.this.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    ScreenOrientationContainer.this.setOrientation(ScreenOrientationContainer.this.getContext(), 4);
                                }
                            }, 1000L);
                        }
                        ScreenOrientationContainer.this.isInChaosMode = false;
                        ScreenOrientationContainer.this.mOrientationEventListener.disable();
                    }
                }
            }
        };
    }

    public void lockScreen() {
        if (!this.isAppLocked) {
            this.isAppLocked = true;
            this.autoFixedOrientation();
            if (this.isInChaosMode) {
                this.mOrientationEventListener.disable();
            }
        }
    }

    public void unlockScreen() {
        if (this.isAppLocked) {
            this.isAppLocked = false;
            if (this.isInChaosMode) {
                this.mOrientationEventListener.enable();
            } else if (!this.isSystemLocked) {
                this.setOrientation(this.getContext(), 4);
            }
        }
    }

    public boolean isFullScreen() {
        return this.currentOrientation == 2;
    }

    public void changeFullScreenState() {
        if (this.isAppLocked || !this.canChangeOrientation()) {
            return;
        }
        if (this.isFullScreen()) {
            this.setPortrait();
        } else {
            this.setLandScape();
        }
    }

    public void resume() {
        if (this.isInChaosMode) {
            this.mOrientationEventListener.enable();
        }
    }

    public void pause() {
        if (this.isInChaosMode) {
            this.mOrientationEventListener.disable();
        }
    }

    public void stop() {
        this.isInChaosMode = false;
    }

    public void destroy() {
        this.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.observer);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mOrientationEventListener.disable();
    }

    public void removeView(View view) {
        if (this.contain(view)) {
            super.removeView(view);
        }
    }

    private void setOrientation(Context context, int n2) {
        if (Build.VERSION.SDK_INT == 19 && context instanceof ContextWrapper && ((ContextWrapper)context).getBaseContext() != null && ((ContextWrapper)context).getBaseContext() instanceof Activity) {
            context = ((ContextWrapper)context).getBaseContext();
            if (n2 == 1) {
                ((Activity)context).getWindow().getDecorView().setSystemUiVisibility(0);
            }
        }
        if (!(context instanceof Activity) || !this.canChangeOrientation()) {
            return;
        }
        Activity activity = (Activity)context;
        activity.setRequestedOrientation(n2);
    }

    private boolean contain(View view) {
        return this.indexOfChild(view) >= 0;
    }

    protected void refreshLayoutForOrientation() {
        if (isIgnoreScreenChange) {
            return;
        }
        if (this.currentOrientation == 2) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                this.mMarginLeft = marginLayoutParams.leftMargin;
                this.mMarginTop = marginLayoutParams.topMargin;
                this.mMarginRight = marginLayoutParams.rightMargin;
                this.mMarginBottom = marginLayoutParams.bottomMargin;
                marginLayoutParams.bottomMargin = 0;
                marginLayoutParams.rightMargin = 0;
                marginLayoutParams.topMargin = 0;
                marginLayoutParams.leftMargin = 0;
            }
            layoutParams.height = -1;
            layoutParams.width = -1;
            this.setLayoutParams(layoutParams);
            if (this.needChangeScreenMode && this.getContext() instanceof Activity) {
                s.a((Activity)this.getContext(), true);
            }
        } else {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                marginLayoutParams.leftMargin = this.mMarginLeft;
                marginLayoutParams.topMargin = this.mMarginTop;
                marginLayoutParams.rightMargin = this.mMarginRight;
                marginLayoutParams.bottomMargin = this.mMarginBottom;
            }
            int n2 = s.a(this.getContext());
            if (h.a(this.getContext()) && h.a()) {
                n2 = ((View)this.getParent()).getWidth();
            }
            ViewParent viewParent = this.getParent();
            int n3 = -1;
            int n4 = -1;
            if (viewParent instanceof View) {
                n3 = ((View)viewParent).getWidth();
                n4 = ((View)viewParent).getHeight();
            }
            if (n3 <= 0 || n4 <= 0) {
                int n5 = Math.min(s.b(this.getContext()), n2) * 9 / 16;
                layoutParams.width = Math.min(s.b(this.getContext()), n2);
                layoutParams.height = n5;
            } else {
                int n6;
                layoutParams.width = Math.min(n3, n2);
                layoutParams.height = n6 = layoutParams.width * 9 / 16;
            }
            this.setLayoutParams(layoutParams);
            if (this.needChangeScreenMode && this.getContext() instanceof Activity) {
                s.a((Activity)this.getContext(), false);
            }
        }
        this.notifyListener();
    }

    public void setPortrait() {
        if (!this.isSystemLocked) {
            this.isInChaosMode = true;
            this.isChaosPortrait = true;
            this.setOrientation(this.getContext(), 1);
            this.mOrientationEventListener.enable();
        } else {
            this.setOrientation(this.getContext(), 1);
        }
    }

    public void setLandScape() {
        if (!this.isSystemLocked) {
            this.isInChaosMode = true;
            this.isChaosPortrait = false;
            this.setOrientation(this.getContext(), 0);
            this.mOrientationEventListener.enable();
        } else {
            this.setOrientation(this.getContext(), 6);
        }
    }

    protected int getDisplayRotation() {
        Context context = this.getContext();
        if (Build.VERSION.SDK_INT == 19 && context != null && context instanceof ContextWrapper && ((ContextWrapper)context).getBaseContext() != null && ((ContextWrapper)context).getBaseContext() instanceof Activity) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Activity) {
            try {
                int n2 = ((Activity)context).getWindowManager().getDefaultDisplay().getRotation();
                switch (n2) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 90;
                    }
                    case 2: {
                        return 180;
                    }
                    case 3: {
                        return 270;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        return 0;
    }

    public void setScreenOrientationAutoMode() {
        if (!(this.getContext() instanceof Activity) || this.isAppLocked || !this.canChangeOrientation()) {
            return;
        }
        this.isSystemLocked = s.c(this.getContext());
        if (this.isSystemLocked) {
            this.autoFixedOrientation();
        } else {
            this.setOrientation(this.getContext(), 4);
        }
    }

    protected void onConfigurationChanged(final Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isAppLocked) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ScreenOrientationContainer.this.postOnConfigurationChanged(configuration);
            }
        });
    }

    public void onConfigurationChangedCompat(final Configuration configuration) {
        if (this.isAppLocked) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ScreenOrientationContainer.this.postOnConfigurationChanged(configuration);
            }
        });
    }

    protected void postOnConfigurationChanged(Configuration configuration) {
        int n2 = this.getDisplayRotation();
        if (configuration.orientation != this.currentOrientation || this.mCurrentRotation != n2) {
            this.currentOrientation = configuration.orientation;
            this.mCurrentRotation = n2;
            b.f(this.currentOrientation == 2);
            if (h.a(this.getContext()) && h.a()) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        ScreenOrientationContainer.this.refreshLayoutForOrientation();
                    }
                });
            } else {
                this.refreshLayoutForOrientation();
            }
        }
    }

    private void notifyListener() {
        if (this.mOrientationChangeListener != null) {
            this.mOrientationChangeListener.onScreenOrientationChange(this.mCurrentRotation);
        }
    }

    private void autoFixedOrientation() {
        if (this.isFullScreen()) {
            this.setOrientation(this.getContext(), 6);
        } else {
            this.setOrientation(this.getContext(), 1);
        }
    }

    public void setSupportChangeOrientation(boolean bl2) {
        this.canChangeOrientation = bl2;
    }

    private boolean canChangeOrientation() {
        return this.canChangeOrientation;
    }

    public void setNeedChangeScreenMode(boolean bl2) {
        this.needChangeScreenMode = bl2;
    }

    private static class InnerContentObserver
    extends ContentObserver {
        private final WeakReference<ScreenOrientationContainer> mWeakReference;

        InnerContentObserver(ScreenOrientationContainer screenOrientationContainer, Handler handler) {
            super(handler);
            this.mWeakReference = new WeakReference<ScreenOrientationContainer>(screenOrientationContainer);
        }

        public void onChange(boolean bl2) {
            super.onChange(bl2);
            ScreenOrientationContainer screenOrientationContainer = (ScreenOrientationContainer)((Object)this.mWeakReference.get());
            if (screenOrientationContainer != null) {
                screenOrientationContainer.handleChange();
            }
        }
    }

    public static interface OnScreenOrientationChangeListener {
        public void onScreenOrientationChange(int var1);
    }
}

