/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorCreator;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.error.ShouldMatch;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractAssert<SELF extends AbstractAssert<SELF, ACTUAL>, ACTUAL>
implements Assert<SELF, ACTUAL> {
    public static boolean throwUnsupportedExceptionOnEquals = true;
    private static final String ORG_ASSERTJ = "org.assert";
    protected Objects objects = Objects.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();
    @VisibleForTesting
    public WritableAssertionInfo info;
    protected final ACTUAL actual;
    protected final SELF myself;
    private static Representation customRepresentation = null;
    @VisibleForTesting
    AssertionErrorCreator assertionErrorCreator;
    private static boolean printAssertionsDescription;
    private static Consumer<Description> descriptionConsumer;

    protected AbstractAssert(ACTUAL actual, Class<?> selfType) {
        this.myself = (AbstractAssert)selfType.cast(this);
        this.actual = actual;
        this.info = new WritableAssertionInfo(customRepresentation);
        this.assertionErrorCreator = new AssertionErrorCreator();
    }

    public WritableAssertionInfo getWritableAssertionInfo() {
        return this.info;
    }

    protected void failWithMessage(String errorMessage, Object ... arguments) {
        throw this.failure(errorMessage, arguments);
    }

    protected AssertionError failure(String errorMessage, Object ... arguments) {
        AssertionError assertionError = Failures.instance().failureIfErrorMessageIsOverridden(this.info);
        if (assertionError == null) {
            String description = MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]);
            assertionError = new AssertionError((Object)(description + String.format(errorMessage, arguments)));
        }
        Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(assertionError);
        return assertionError;
    }

    protected void failWithActualExpectedAndMessage(Object actual, Object expected, String errorMessageFormat, Object ... arguments) {
        throw this.failureWithActualExpected(actual, expected, errorMessageFormat, arguments);
    }

    protected AssertionError failureWithActualExpected(Object actual, Object expected, String errorMessageFormat, Object ... arguments) {
        String errorMessage = Optional.ofNullable(this.info.overridingErrorMessage()).orElse(String.format(errorMessageFormat, arguments));
        String description = MessageFormatter.instance().format(this.info.description(), this.info.representation(), errorMessage, new Object[0]);
        AssertionError assertionError = this.assertionErrorCreator.assertionError(description, actual, expected, this.info.representation());
        Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(assertionError);
        return assertionError;
    }

    protected void throwAssertionError(ErrorMessageFactory errorMessageFactory) {
        throw this.assertionError(errorMessageFactory);
    }

    protected AssertionError assertionError(ErrorMessageFactory errorMessageFactory) {
        AssertionError failure = Failures.instance().failure((AssertionInfo)this.info, errorMessageFactory);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(failure);
        return failure;
    }

    private void removeCustomAssertRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (!Failures.instance().isRemoveAssertJRelatedElementsFromStackTrace()) {
            return;
        }
        if (this.isAssertjAssertClass()) {
            return;
        }
        StackTraceElement[] newStackTrace = (StackTraceElement[])Arrays.stream(((Throwable)((Object)assertionError)).getStackTrace()).filter(element -> !this.isElementOfCustomAssert((StackTraceElement)element)).toArray(StackTraceElement[]::new);
        ((Throwable)((Object)assertionError)).setStackTrace(newStackTrace);
    }

    private boolean isAssertjAssertClass() {
        return this.getClass().getName().startsWith(ORG_ASSERTJ);
    }

    protected boolean isElementOfCustomAssert(StackTraceElement stackTraceElement) {
        for (Class<?> currentAssertClass = this.getClass(); currentAssertClass != AbstractAssert.class; currentAssertClass = currentAssertClass.getSuperclass()) {
            if (!stackTraceElement.getClassName().equals(currentAssertClass.getName())) continue;
            return true;
        }
        return false;
    }

    @CheckReturnValue
    protected SELF inHexadecimal() {
        this.info.useHexadecimalRepresentation();
        return this.myself;
    }

    @CheckReturnValue
    protected SELF inBinary() {
        this.info.useBinaryRepresentation();
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description) {
        this.info.description(description);
        if (printAssertionsDescription) {
            this.printDescriptionText();
        }
        if (descriptionConsumer != null) {
            descriptionConsumer.accept(description);
        }
        return this.myself;
    }

    private void printDescriptionText() {
        String descriptionText = this.info.descriptionText();
        if (!descriptionText.isEmpty()) {
            System.out.println(descriptionText);
        }
    }

    @Override
    public SELF isEqualTo(Object expected) {
        this.objects.assertEqual(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        this.objects.assertNotEqual(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public void isNull() {
        this.objects.assertNull(this.info, this.actual);
    }

    @Override
    public SELF isNotNull() {
        this.objects.assertNotNull(this.info, this.actual);
        return this.myself;
    }

    @Override
    public SELF isSameAs(Object expected) {
        this.objects.assertSame(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public SELF isNotSameAs(Object other) {
        this.objects.assertNotSame(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF isIn(Object ... values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF isNotIn(Object ... values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        this.conditions.assertIs(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        this.conditions.assertIsNot(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        this.conditions.assertHas(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        this.conditions.assertDoesNotHave(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF satisfies(Condition<? super ACTUAL> condition) {
        this.conditions.assertSatisfies(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT asInstanceOf(InstanceOfAssertFactory<?, ASSERT> instanceOfAssertFactory) {
        java.util.Objects.requireNonNull(instanceOfAssertFactory, ShouldNotBeNull.shouldNotBeNull("instanceOfAssertFactory").create());
        this.objects.assertIsInstanceOf(this.info, this.actual, instanceOfAssertFactory.getType());
        return (ASSERT)((AbstractAssert)instanceOfAssertFactory.createAssert(this.actual)).withAssertionState((AbstractAssert)this.myself);
    }

    @Override
    public SELF isInstanceOf(Class<?> type) {
        this.objects.assertIsInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public <T> SELF isInstanceOfSatisfying(Class<T> type, Consumer<T> requirements) {
        this.objects.assertIsInstanceOf(this.info, this.actual, type);
        java.util.Objects.requireNonNull(requirements, "The Consumer<T> expressing the assertions requirements must not be null");
        requirements.accept(this.actual);
        return this.myself;
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type) {
        this.objects.assertIsNotInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsNotInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        this.objects.assertHasSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF hasToString(String expectedToString) {
        this.objects.assertHasToString(this.info, this.actual, expectedToString);
        return this.myself;
    }

    @Override
    public SELF doesNotHaveToString(String otherToString) {
        this.objects.assertDoesNotHaveToString(this.info, this.actual, otherToString);
        return this.myself;
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        this.objects.assertDoesNotHaveSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsNotExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsNotOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> asList() {
        this.objects.assertIsInstanceOf(this.info, this.actual, List.class);
        return this.newListAssertInstance((List)this.actual).as(this.info.description());
    }

    @CheckReturnValue
    public AbstractStringAssert<?> asString() {
        this.objects.assertNotNull(this.info, this.actual);
        return Assertions.assertThat(this.actual.toString());
    }

    public String descriptionText() {
        return this.info.descriptionText();
    }

    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        this.info.overridingErrorMessage(Strings.formatIfArgs(newErrorMessage, args));
        return this.myself;
    }

    @CheckReturnValue
    public SELF overridingErrorMessage(Supplier<String> supplier) {
        this.info.overridingErrorMessage(supplier);
        return this.myself;
    }

    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        return this.overridingErrorMessage(newErrorMessage, args);
    }

    @CheckReturnValue
    public SELF withFailMessage(Supplier<String> supplier) {
        return this.overridingErrorMessage(supplier);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        this.objects = new Objects(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.objects = Objects.instance();
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        Failures.instance().enablePrintThreadDump();
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF withRepresentation(Representation representation) {
        this.info.useRepresentation(representation);
        return this.myself;
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        if (throwUnsupportedExceptionOnEquals) {
            throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 1;
    }

    public SELF matches(Predicate<? super ACTUAL> predicate) {
        return this.matches(predicate, PredicateDescription.GIVEN);
    }

    public SELF matches(Predicate<? super ACTUAL> predicate, String predicateDescription) {
        return this.matches(predicate, new PredicateDescription(predicateDescription));
    }

    @Override
    public SELF satisfies(Consumer<ACTUAL> requirements) {
        java.util.Objects.requireNonNull(requirements, "The Consumer<T> expressing the assertions requirements must not be null");
        requirements.accept(this.actual);
        return this.myself;
    }

    public SELF satisfiesAnyOf(Consumer<ACTUAL> assertions1, Consumer<ACTUAL> assertions2) {
        return this.satisfiesAnyOfAssertionsGroups(assertions1, assertions2);
    }

    public SELF satisfiesAnyOf(Consumer<ACTUAL> assertions1, Consumer<ACTUAL> assertions2, Consumer<ACTUAL> assertions3) {
        return this.satisfiesAnyOfAssertionsGroups(assertions1, assertions2, assertions3);
    }

    public SELF satisfiesAnyOf(Consumer<ACTUAL> assertions1, Consumer<ACTUAL> assertions2, Consumer<ACTUAL> assertions3, Consumer<ACTUAL> assertions4) {
        return this.satisfiesAnyOfAssertionsGroups(assertions1, assertions2, assertions3, assertions4);
    }

    @SafeVarargs
    private final SELF satisfiesAnyOfAssertionsGroups(Consumer<ACTUAL> ... assertionsGroups) throws AssertionError {
        Preconditions.checkArgument(Arrays.stream(assertionsGroups).allMatch(java.util.Objects::nonNull), "No assertions group should be null", new Object[0]);
        if (Arrays.stream(assertionsGroups).anyMatch(this::satisfiesAssertions)) {
            return this.myself;
        }
        List<AssertionError> assertionErrors = Arrays.stream(assertionsGroups).map(this::catchAssertionError).collect(Collectors.toList());
        throw this.multipleAssertionsError(assertionErrors);
    }

    private AssertionError multipleAssertionsError(List<AssertionError> assertionErrors) {
        return this.assertionErrorCreator.multipleAssertionsError(this.info.description(), assertionErrors);
    }

    private boolean satisfiesAssertions(Consumer<ACTUAL> assertions) {
        try {
            assertions.accept(this.actual);
        }
        catch (AssertionError e) {
            return false;
        }
        return true;
    }

    private AssertionError catchAssertionError(Consumer<ACTUAL> assertions) {
        try {
            assertions.accept(this.actual);
        }
        catch (AssertionError assertionError) {
            return assertionError;
        }
        throw new IllegalStateException("Shouldn't arrived here, assertions should have raised an AssertionError (please file a bug)");
    }

    private SELF matches(Predicate<? super ACTUAL> predicate, PredicateDescription predicateDescription) {
        java.util.Objects.requireNonNull(predicate, "The predicate must not be null");
        if (predicate.test(this.actual)) {
            return this.myself;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldMatch.shouldMatch(this.actual, predicate, predicateDescription));
    }

    public static void setCustomRepresentation(Representation customRepresentation) {
        ConfigurationProvider.loadRegisteredConfiguration();
        AbstractAssert.customRepresentation = customRepresentation;
    }

    public static void setPrintAssertionsDescription(boolean printAssertionsDescription) {
        ConfigurationProvider.loadRegisteredConfiguration();
        AbstractAssert.printAssertionsDescription = printAssertionsDescription;
    }

    public static void setDescriptionConsumer(Consumer<Description> descriptionConsumer) {
        AbstractAssert.descriptionConsumer = descriptionConsumer;
    }

    @Override
    public SELF hasSameHashCodeAs(Object other) {
        this.objects.assertHasSameHashCodeAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF doesNotHaveSameHashCodeAs(Object other) {
        this.objects.assertDoesNotHaveSameHashCodeAs(this.info, this.actual, other);
        return this.myself;
    }

    protected <E> AbstractListAssert<?, List<? extends E>, E, ObjectAssert<E>> newListAssertInstance(List<? extends E> newActual) {
        return new ListAssert<E>(newActual);
    }

    SELF withAssertionState(AbstractAssert assertInstance) {
        this.objects = assertInstance.objects;
        this.propagateAssertionInfoFrom(assertInstance);
        return this.myself;
    }

    private void propagateAssertionInfoFrom(AbstractAssert<?, ?> assertInstance) {
        this.info.useRepresentation(assertInstance.info.representation());
        this.info.description(assertInstance.info.description());
        this.info.overridingErrorMessage(assertInstance.info.overridingErrorMessage());
    }

    protected RecursiveComparisonAssert<?> usingRecursiveComparison(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        return (RecursiveComparisonAssert)new RecursiveComparisonAssert(this.actual, recursiveComparisonConfiguration).withAssertionState((AbstractAssert)this.myself);
    }

    protected RecursiveComparisonAssert<?> usingRecursiveComparison() {
        return this.usingRecursiveComparison(new RecursiveComparisonConfiguration());
    }

    @CheckReturnValue
    protected <ASSERT extends AbstractAssert<?, ?>> ASSERT extracting(String propertyOrField, AssertFactory<Object, ASSERT> assertFactory) {
        java.util.Objects.requireNonNull(propertyOrField, ShouldNotBeNull.shouldNotBeNull("propertyOrField").create());
        java.util.Objects.requireNonNull(assertFactory, ShouldNotBeNull.shouldNotBeNull("assertFactory").create());
        Object value = Extractors.byName(propertyOrField).apply(this.actual);
        String extractedPropertyOrFieldDescription = Extractors.extractedDescriptionOf(propertyOrField);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertyOrFieldDescription);
        return (ASSERT)((AbstractAssert)((AbstractAssert)assertFactory.createAssert(value)).withAssertionState((AbstractAssert)this.myself).as(description, new Object[0]));
    }

    @CheckReturnValue
    protected <T, ASSERT extends AbstractAssert<?, ?>> ASSERT extracting(Function<? super ACTUAL, ? extends T> extractor, AssertFactory<T, ASSERT> assertFactory) {
        java.util.Objects.requireNonNull(extractor, ShouldNotBeNull.shouldNotBeNull("extractor").create());
        java.util.Objects.requireNonNull(assertFactory, ShouldNotBeNull.shouldNotBeNull("assertFactory").create());
        T extractedValue = extractor.apply(this.actual);
        return (ASSERT)((AbstractAssert)assertFactory.createAssert(extractedValue)).withAssertionState((AbstractAssert)this.myself);
    }
}

