/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Double2DArrays;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class Double2DArrayAssert
extends Abstract2DArrayAssert<Double2DArrayAssert, double[][], Double> {
    private final Failures failures = Failures.instance();
    @VisibleForTesting
    protected Double2DArrays double2dArrays = Double2DArrays.instance();

    public Double2DArrayAssert(double[][] actual) {
        super(actual, Double2DArrayAssert.class);
    }

    @Override
    public Double2DArrayAssert isDeepEqualTo(double[][] expected) {
        if (this.actual == expected) {
            return (Double2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((double[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((double[][])this.actual).length, expected.length));
        }
        for (int i = 0; i < ((double[][])this.actual).length; ++i) {
            double[] actualSubArray = ((double[][])this.actual)[i];
            double[] expectedSubArray = expected[i];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Double2DArrayAssert)this.myself;
    }

    @Override
    public Double2DArrayAssert isEqualTo(Object expected) {
        return (Double2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.double2dArrays.assertNullOrEmpty(this.info, (double[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.double2dArrays.assertEmpty(this.info, (double[][])this.actual);
    }

    @Override
    public Double2DArrayAssert isNotEmpty() {
        this.double2dArrays.assertNotEmpty(this.info, (double[][])this.actual);
        return (Double2DArrayAssert)this.myself;
    }

    @Override
    public Double2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.double2dArrays.assertHasDimensions(this.info, (double[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Double2DArrayAssert)this.myself;
    }

    @Override
    public Double2DArrayAssert hasSameDimensionsAs(Object array) {
        this.double2dArrays.assertHasSameDimensionsAs(this.info, (double[][])this.actual, array);
        return (Double2DArrayAssert)this.myself;
    }

    public Double2DArrayAssert contains(double[] value, Index index) {
        this.double2dArrays.assertContains(this.info, (double[][])this.actual, value, index);
        return (Double2DArrayAssert)this.myself;
    }

    public Double2DArrayAssert doesNotContain(double[] value, Index index) {
        this.double2dArrays.assertDoesNotContain(this.info, (double[][])this.actual, value, index);
        return (Double2DArrayAssert)this.myself;
    }
}

