/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresOptIn;
import java.time.Duration;

public final class DnsOptions {
    @Nullable
    private final Boolean mUseBuiltInDnsResolver;
    @Nullable
    private final Boolean mPersistHostCache;
    @Nullable
    private final Boolean mEnableStaleDns;
    @Nullable
    private final Long mPersistHostCachePeriodMillis;
    @Nullable
    private final Boolean mPreestablishConnectionsToStaleDnsResults;
    @Nullable
    private final StaleDnsOptions mStaleDnsOptions;

    DnsOptions(Builder builder) {
        this.mEnableStaleDns = builder.mEnableStaleDns;
        this.mStaleDnsOptions = builder.mStaleDnsOptions;
        this.mPersistHostCachePeriodMillis = builder.mPersistHostCachePeriodMillis;
        this.mPreestablishConnectionsToStaleDnsResults = builder.mPreestablishConnectionsToStaleDnsResults;
        this.mUseBuiltInDnsResolver = builder.mUseBuiltInDnsResolver;
        this.mPersistHostCache = builder.mPersistHostCache;
    }

    @Nullable
    public Boolean getUseBuiltInDnsResolver() {
        return this.mUseBuiltInDnsResolver;
    }

    @Nullable
    public Boolean getPersistHostCache() {
        return this.mPersistHostCache;
    }

    @Nullable
    public Boolean getEnableStaleDns() {
        return this.mEnableStaleDns;
    }

    @Nullable
    public Long getPersistHostCachePeriodMillis() {
        return this.mPersistHostCachePeriodMillis;
    }

    @Nullable
    public Boolean getPreestablishConnectionsToStaleDnsResults() {
        return this.mPreestablishConnectionsToStaleDnsResults;
    }

    @Nullable
    public StaleDnsOptions getStaleDnsOptions() {
        return this.mStaleDnsOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean mUseBuiltInDnsResolver;
        @Nullable
        private Boolean mEnableStaleDns;
        @Nullable
        private StaleDnsOptions mStaleDnsOptions;
        @Nullable
        private Boolean mPersistHostCache;
        @Nullable
        private Long mPersistHostCachePeriodMillis;
        @Nullable
        private Boolean mPreestablishConnectionsToStaleDnsResults;

        Builder() {
        }

        public Builder useBuiltInDnsResolver(boolean enable) {
            this.mUseBuiltInDnsResolver = enable;
            return this;
        }

        public Builder enableStaleDns(boolean enable) {
            this.mEnableStaleDns = enable;
            return this;
        }

        public Builder setStaleDnsOptions(StaleDnsOptions staleDnsOptions) {
            this.mStaleDnsOptions = staleDnsOptions;
            return this;
        }

        @Experimental
        public Builder setStaleDnsOptions(StaleDnsOptions.Builder staleDnsOptionsBuilder) {
            return this.setStaleDnsOptions(staleDnsOptionsBuilder.build());
        }

        @Experimental
        public Builder preestablishConnectionsToStaleDnsResults(boolean enable) {
            this.mPreestablishConnectionsToStaleDnsResults = enable;
            return this;
        }

        public Builder persistHostCache(boolean persistHostCache) {
            this.mPersistHostCache = persistHostCache;
            return this;
        }

        public Builder setPersistHostCachePeriodMillis(long persistHostCachePeriodMillis) {
            this.mPersistHostCachePeriodMillis = persistHostCachePeriodMillis;
            return this;
        }

        @RequiresApi(api=26)
        public Builder setPersistDelay(Duration persistToDiskPeriod) {
            return this.setPersistHostCachePeriodMillis(persistToDiskPeriod.toMillis());
        }

        public DnsOptions build() {
            return new DnsOptions(this);
        }
    }

    public static class StaleDnsOptions {
        @Nullable
        private final Long mFreshLookupTimeoutMillis;
        @Nullable
        private final Long mMaxExpiredDelayMillis;
        @Nullable
        private final Boolean mAllowCrossNetworkUsage;
        @Nullable
        private final Boolean mUseStaleOnNameNotResolved;

        @Nullable
        public Long getFreshLookupTimeoutMillis() {
            return this.mFreshLookupTimeoutMillis;
        }

        @Nullable
        public Long getMaxExpiredDelayMillis() {
            return this.mMaxExpiredDelayMillis;
        }

        @Nullable
        public Boolean getAllowCrossNetworkUsage() {
            return this.mAllowCrossNetworkUsage;
        }

        @Nullable
        public Boolean getUseStaleOnNameNotResolved() {
            return this.mUseStaleOnNameNotResolved;
        }

        public static Builder builder() {
            return new Builder();
        }

        StaleDnsOptions(Builder builder) {
            this.mFreshLookupTimeoutMillis = builder.mFreshLookupTimeoutMillis;
            this.mMaxExpiredDelayMillis = builder.mMaxExpiredDelayMillis;
            this.mAllowCrossNetworkUsage = builder.mAllowCrossNetworkUsage;
            this.mUseStaleOnNameNotResolved = builder.mUseStaleOnNameNotResolved;
        }

        public static final class Builder {
            private Long mFreshLookupTimeoutMillis;
            private Long mMaxExpiredDelayMillis;
            private Boolean mAllowCrossNetworkUsage;
            private Boolean mUseStaleOnNameNotResolved;

            Builder() {
            }

            public Builder setFreshLookupTimeoutMillis(long freshLookupTimeoutMillis) {
                this.mFreshLookupTimeoutMillis = freshLookupTimeoutMillis;
                return this;
            }

            @RequiresApi(value=26)
            public Builder setFreshLookupTimeout(Duration freshLookupTimeout) {
                return this.setFreshLookupTimeoutMillis(freshLookupTimeout.toMillis());
            }

            public Builder setMaxExpiredDelayMillis(long maxExpiredDelayMillis) {
                this.mMaxExpiredDelayMillis = maxExpiredDelayMillis;
                return this;
            }

            @RequiresApi(value=26)
            public Builder setMaxExpiredDelayMillis(Duration maxExpiredDelay) {
                return this.setMaxExpiredDelayMillis(maxExpiredDelay.toMillis());
            }

            public Builder allowCrossNetworkUsage(boolean allowCrossNetworkUsage) {
                this.mAllowCrossNetworkUsage = allowCrossNetworkUsage;
                return this;
            }

            public Builder useStaleOnNameNotResolved(boolean useStaleOnNameNotResolved) {
                this.mUseStaleOnNameNotResolved = useStaleOnNameNotResolved;
                return this;
            }

            public StaleDnsOptions build() {
                return new StaleDnsOptions(this);
            }
        }
    }

    @RequiresOptIn
    public static @interface Experimental {
    }
}

