/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.ConnectionMigrationOptions;
import org.chromium.net.CronetEngine;
import org.chromium.net.DnsOptions;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.ExperimentalUrlRequest;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.QuicOptions;
import org.chromium.net.UrlRequest;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public abstract class ExperimentalCronetEngine
extends CronetEngine {
    public static final int CONNECTION_METRIC_UNKNOWN = -1;
    public static final int EFFECTIVE_CONNECTION_TYPE_UNKNOWN = 0;
    public static final int EFFECTIVE_CONNECTION_TYPE_OFFLINE = 1;
    public static final int EFFECTIVE_CONNECTION_TYPE_SLOW_2G = 2;
    public static final int EFFECTIVE_CONNECTION_TYPE_2G = 3;
    public static final int EFFECTIVE_CONNECTION_TYPE_3G = 4;
    public static final int EFFECTIVE_CONNECTION_TYPE_4G = 5;
    public static final long UNBIND_NETWORK_HANDLE = -1L;

    @Override
    public abstract ExperimentalUrlRequest.Builder newUrlRequestBuilder(String var1, UrlRequest.Callback var2, Executor var3);

    public abstract ExperimentalBidirectionalStream.Builder newBidirectionalStreamBuilder(String var1, BidirectionalStream.Callback var2, Executor var3);

    public void bindToNetwork(long networkHandle) {
    }

    public URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        return url.openConnection(proxy);
    }

    public static class Builder
    extends CronetEngine.Builder {
        private JSONObject mParsedExperimentalOptions;
        private final List<ExperimentalOptionsPatch> mExperimentalOptionsPatches = new ArrayList<ExperimentalOptionsPatch>();

        public Builder(Context context) {
            super(context);
        }

        public Builder(ICronetEngineBuilder builderDelegate) {
            super(builderDelegate);
        }

        public Builder setExperimentalOptions(String options) {
            this.mParsedExperimentalOptions = options == null || options.isEmpty() ? null : Builder.parseExperimentalOptions(options);
            return this;
        }

        @VisibleForTesting
        public ICronetEngineBuilder getBuilderDelegate() {
            return this.mBuilderDelegate;
        }

        @Override
        public Builder setUserAgent(String userAgent) {
            super.setUserAgent(userAgent);
            return this;
        }

        @Override
        public Builder setStoragePath(String value) {
            super.setStoragePath(value);
            return this;
        }

        @Override
        public Builder setLibraryLoader(CronetEngine.Builder.LibraryLoader loader) {
            super.setLibraryLoader(loader);
            return this;
        }

        @Override
        public Builder enableQuic(boolean value) {
            super.enableQuic(value);
            return this;
        }

        @Override
        public Builder enableHttp2(boolean value) {
            super.enableHttp2(value);
            return this;
        }

        @Override
        @QuicOptions.Experimental
        public Builder setQuicOptions(QuicOptions options) {
            if (this.mBuilderDelegate.getSupportedConfigOptions().contains(3)) {
                this.mBuilderDelegate.setQuicOptions(options);
                return this;
            }
            this.mExperimentalOptionsPatches.add(experimentalOptions -> {
                JSONObject quicOptions = Builder.createDefaultIfAbsent(experimentalOptions, "QUIC");
                if (!options.getQuicHostAllowlist().isEmpty()) {
                    quicOptions.put("host_whitelist", (Object)String.join((CharSequence)",", options.getQuicHostAllowlist()));
                }
                if (!options.getEnabledQuicVersions().isEmpty()) {
                    quicOptions.put("quic_version", (Object)String.join((CharSequence)",", options.getEnabledQuicVersions()));
                }
                if (!options.getConnectionOptions().isEmpty()) {
                    quicOptions.put("connection_options", (Object)String.join((CharSequence)",", options.getConnectionOptions()));
                }
                if (!options.getClientConnectionOptions().isEmpty()) {
                    quicOptions.put("client_connection_options", (Object)String.join((CharSequence)",", options.getClientConnectionOptions()));
                }
                if (!options.getExtraQuicheFlags().isEmpty()) {
                    quicOptions.put("set_quic_flags", (Object)String.join((CharSequence)",", options.getExtraQuicheFlags()));
                }
                if (options.getInMemoryServerConfigsCacheSize() != null) {
                    quicOptions.put("max_server_configs_stored_in_properties", (Object)options.getInMemoryServerConfigsCacheSize());
                }
                if (options.getHandshakeUserAgent() != null) {
                    quicOptions.put("user_agent_id", (Object)options.getHandshakeUserAgent());
                }
                if (options.getRetryWithoutAltSvcOnQuicErrors() != null) {
                    quicOptions.put("retry_without_alt_svc_on_quic_errors", (Object)options.getRetryWithoutAltSvcOnQuicErrors());
                }
                if (options.getEnableTlsZeroRtt() != null) {
                    quicOptions.put("disable_tls_zero_rtt", options.getEnableTlsZeroRtt() == false);
                }
                if (options.getPreCryptoHandshakeIdleTimeoutSeconds() != null) {
                    quicOptions.put("max_idle_time_before_crypto_handshake_seconds", (Object)options.getPreCryptoHandshakeIdleTimeoutSeconds());
                }
                if (options.getCryptoHandshakeTimeoutSeconds() != null) {
                    quicOptions.put("max_time_before_crypto_handshake_seconds", (Object)options.getCryptoHandshakeTimeoutSeconds());
                }
                if (options.getIdleConnectionTimeoutSeconds() != null) {
                    quicOptions.put("idle_connection_timeout_seconds", (Object)options.getIdleConnectionTimeoutSeconds());
                }
                if (options.getRetransmittableOnWireTimeoutMillis() != null) {
                    quicOptions.put("retransmittable_on_wire_timeout_milliseconds", (Object)options.getRetransmittableOnWireTimeoutMillis());
                }
                if (options.getCloseSessionsOnIpChange() != null) {
                    quicOptions.put("close_sessions_on_ip_change", (Object)options.getCloseSessionsOnIpChange());
                }
                if (options.getGoawaySessionsOnIpChange() != null) {
                    quicOptions.put("goaway_sessions_on_ip_change", (Object)options.getGoawaySessionsOnIpChange());
                }
                if (options.getInitialBrokenServicePeriodSeconds() != null) {
                    quicOptions.put("initial_delay_for_broken_alternative_service_seconds", (Object)options.getInitialBrokenServicePeriodSeconds());
                }
                if (options.getIncreaseBrokenServicePeriodExponentially() != null) {
                    quicOptions.put("exponential_backoff_on_initial_delay", (Object)options.getIncreaseBrokenServicePeriodExponentially());
                }
                if (options.getDelayJobsWithAvailableSpdySession() != null) {
                    quicOptions.put("delay_main_job_with_available_spdy_session", (Object)options.getDelayJobsWithAvailableSpdySession());
                }
            });
            return this;
        }

        @Override
        @DnsOptions.Experimental
        public Builder setDnsOptions(DnsOptions options) {
            if (this.mBuilderDelegate.getSupportedConfigOptions().contains(2)) {
                this.mBuilderDelegate.setDnsOptions(options);
                return this;
            }
            this.mExperimentalOptionsPatches.add(experimentalOptions -> {
                JSONObject asyncDnsOptions = Builder.createDefaultIfAbsent(experimentalOptions, "AsyncDNS");
                if (options.getUseBuiltInDnsResolver() != null) {
                    asyncDnsOptions.put("enable", (Object)options.getUseBuiltInDnsResolver());
                }
                JSONObject staleDnsOptions = Builder.createDefaultIfAbsent(experimentalOptions, "StaleDNS");
                if (options.getEnableStaleDns() != null) {
                    staleDnsOptions.put("enable", (Object)options.getEnableStaleDns());
                }
                if (options.getPersistHostCache() != null) {
                    staleDnsOptions.put("persist_to_disk", (Object)options.getPersistHostCache());
                }
                if (options.getPersistHostCachePeriodMillis() != null) {
                    staleDnsOptions.put("persist_delay_ms", (Object)options.getPersistHostCachePeriodMillis());
                }
                if (options.getStaleDnsOptions() != null) {
                    DnsOptions.StaleDnsOptions staleDnsOptionsJava = options.getStaleDnsOptions();
                    if (staleDnsOptionsJava.getAllowCrossNetworkUsage() != null) {
                        staleDnsOptions.put("allow_other_network", (Object)staleDnsOptionsJava.getAllowCrossNetworkUsage());
                    }
                    if (staleDnsOptionsJava.getFreshLookupTimeoutMillis() != null) {
                        staleDnsOptions.put("delay_ms", (Object)staleDnsOptionsJava.getFreshLookupTimeoutMillis());
                    }
                    if (staleDnsOptionsJava.getUseStaleOnNameNotResolved() != null) {
                        staleDnsOptions.put("use_stale_on_name_not_resolved", (Object)staleDnsOptionsJava.getUseStaleOnNameNotResolved());
                    }
                    if (staleDnsOptionsJava.getMaxExpiredDelayMillis() != null) {
                        staleDnsOptions.put("max_expired_time_ms", (Object)staleDnsOptionsJava.getMaxExpiredDelayMillis());
                    }
                }
                JSONObject quicOptions = Builder.createDefaultIfAbsent(experimentalOptions, "QUIC");
                if (options.getPreestablishConnectionsToStaleDnsResults() != null) {
                    quicOptions.put("race_stale_dns_on_connection", (Object)options.getPreestablishConnectionsToStaleDnsResults());
                }
            });
            return this;
        }

        @Override
        @ConnectionMigrationOptions.Experimental
        public Builder setConnectionMigrationOptions(ConnectionMigrationOptions options) {
            if (this.mBuilderDelegate.getSupportedConfigOptions().contains(1)) {
                this.mBuilderDelegate.setConnectionMigrationOptions(options);
                return this;
            }
            this.mExperimentalOptionsPatches.add(experimentalOptions -> {
                JSONObject quicOptions = Builder.createDefaultIfAbsent(experimentalOptions, "QUIC");
                if (options.getEnableDefaultNetworkMigration() != null) {
                    quicOptions.put("migrate_sessions_on_network_change_v2", (Object)options.getEnableDefaultNetworkMigration());
                }
                if (options.getAllowServerMigration() != null) {
                    quicOptions.put("allow_server_migration", (Object)options.getAllowServerMigration());
                }
                if (options.getMigrateIdleConnections() != null) {
                    quicOptions.put("migrate_idle_sessions", (Object)options.getMigrateIdleConnections());
                }
                if (options.getIdleMigrationPeriodSeconds() != null) {
                    quicOptions.put("idle_session_migration_period_seconds", (Object)options.getIdleMigrationPeriodSeconds());
                }
                if (options.getRetryPreHandshakeErrorsOnAlternateNetwork() != null) {
                    quicOptions.put("retry_on_alternate_network_before_handshake", (Object)options.getRetryPreHandshakeErrorsOnAlternateNetwork());
                }
                if (options.getMaxTimeOnNonDefaultNetworkSeconds() != null) {
                    quicOptions.put("max_time_on_non_default_network_seconds", (Object)options.getMaxTimeOnNonDefaultNetworkSeconds());
                }
                if (options.getMaxPathDegradingEagerMigrationsCount() != null) {
                    quicOptions.put("max_migrations_to_non_default_network_on_path_degrading", (Object)options.getMaxPathDegradingEagerMigrationsCount());
                }
                if (options.getMaxWriteErrorEagerMigrationsCount() != null) {
                    quicOptions.put("max_migrations_to_non_default_network_on_write_error", (Object)options.getMaxWriteErrorEagerMigrationsCount());
                }
                if (options.getEnablePathDegradationMigration() != null) {
                    boolean pathDegradationValue = options.getEnablePathDegradationMigration();
                    boolean skipPortMigrationFlag = false;
                    if (options.getAllowNonDefaultNetworkUsage() != null) {
                        boolean nonDefaultNetworkValue = options.getAllowNonDefaultNetworkUsage();
                        if (!pathDegradationValue && nonDefaultNetworkValue) {
                            throw new IllegalArgumentException("Unable to turn on non-default network usage without path degradation migration!");
                        }
                        if (pathDegradationValue && nonDefaultNetworkValue) {
                            quicOptions.put("migrate_sessions_early_v2", true);
                            skipPortMigrationFlag = true;
                        } else {
                            quicOptions.put("migrate_sessions_early_v2", false);
                        }
                    }
                    if (!skipPortMigrationFlag) {
                        quicOptions.put("allow_port_migration", pathDegradationValue);
                    }
                }
            });
            return this;
        }

        @Override
        public Builder enableSdch(boolean value) {
            return this;
        }

        @Override
        public Builder enableHttpCache(int cacheMode, long maxSize) {
            super.enableHttpCache(cacheMode, maxSize);
            return this;
        }

        @Override
        public Builder addQuicHint(String host, int port, int alternatePort) {
            super.addQuicHint(host, port, alternatePort);
            return this;
        }

        @Override
        public Builder addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
            super.addPublicKeyPins(hostName, pinsSha256, includeSubdomains, expirationDate);
            return this;
        }

        @Override
        public Builder enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
            super.enablePublicKeyPinningBypassForLocalTrustAnchors(value);
            return this;
        }

        @Override
        public Builder enableNetworkQualityEstimator(boolean value) {
            super.enableNetworkQualityEstimator(value);
            return this;
        }

        @Override
        public Builder setThreadPriority(int priority) {
            super.setThreadPriority(priority);
            return this;
        }

        @Override
        public ExperimentalCronetEngine build() {
            if (this.mParsedExperimentalOptions == null && this.mExperimentalOptionsPatches.isEmpty()) {
                return this.mBuilderDelegate.build();
            }
            if (this.mParsedExperimentalOptions == null) {
                this.mParsedExperimentalOptions = new JSONObject();
            }
            for (ExperimentalOptionsPatch patch : this.mExperimentalOptionsPatches) {
                try {
                    patch.applyTo(this.mParsedExperimentalOptions);
                }
                catch (JSONException e) {
                    throw new IllegalStateException("Unable to apply JSON patch!", e);
                }
            }
            this.mBuilderDelegate.setExperimentalOptions(this.mParsedExperimentalOptions.toString());
            return this.mBuilderDelegate.build();
        }

        private static JSONObject parseExperimentalOptions(String jsonString) {
            try {
                return new JSONObject(jsonString);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Experimental options parsing failed", e);
            }
        }

        private static JSONObject createDefaultIfAbsent(JSONObject jsonObject, String key) {
            JSONObject object = jsonObject.optJSONObject(key);
            if (object == null) {
                object = new JSONObject();
                try {
                    jsonObject.put(key, (Object)object);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("Failed adding a default object for key [" + key + "]", e);
                }
            }
            return object;
        }

        @FunctionalInterface
        private static interface ExperimentalOptionsPatch {
            public void applyTo(JSONObject var1) throws JSONException;
        }
    }
}

