/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.chromium.net.CronetException;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlResponseInfo;

public abstract class UrlRequest {
    public abstract void start();

    public abstract void followRedirect();

    public abstract void read(ByteBuffer var1);

    public abstract void cancel();

    public abstract boolean isDone();

    public abstract void getStatus(StatusListener var1);

    public static abstract class StatusListener {
        public abstract void onStatus(int var1);
    }

    public static class Status {
        public static final int INVALID = -1;
        public static final int IDLE = 0;
        public static final int WAITING_FOR_STALLED_SOCKET_POOL = 1;
        public static final int WAITING_FOR_AVAILABLE_SOCKET = 2;
        public static final int WAITING_FOR_DELEGATE = 3;
        public static final int WAITING_FOR_CACHE = 4;
        public static final int DOWNLOADING_PAC_FILE = 5;
        public static final int RESOLVING_PROXY_FOR_URL = 6;
        public static final int RESOLVING_HOST_IN_PAC_FILE = 7;
        public static final int ESTABLISHING_PROXY_TUNNEL = 8;
        public static final int RESOLVING_HOST = 9;
        public static final int CONNECTING = 10;
        public static final int SSL_HANDSHAKE = 11;
        public static final int SENDING_REQUEST = 12;
        public static final int WAITING_FOR_RESPONSE = 13;
        public static final int READING_RESPONSE = 14;

        private Status() {
        }
    }

    public static abstract class Callback {
        public abstract void onRedirectReceived(UrlRequest var1, UrlResponseInfo var2, String var3) throws Exception;

        public abstract void onResponseStarted(UrlRequest var1, UrlResponseInfo var2) throws Exception;

        public abstract void onReadCompleted(UrlRequest var1, UrlResponseInfo var2, ByteBuffer var3) throws Exception;

        public abstract void onSucceeded(UrlRequest var1, UrlResponseInfo var2);

        public abstract void onFailed(UrlRequest var1, UrlResponseInfo var2, CronetException var3);

        public void onCanceled(UrlRequest request, UrlResponseInfo info) {
        }
    }

    public static abstract class Builder {
        public static final int REQUEST_PRIORITY_IDLE = 0;
        public static final int REQUEST_PRIORITY_LOWEST = 1;
        public static final int REQUEST_PRIORITY_LOW = 2;
        public static final int REQUEST_PRIORITY_MEDIUM = 3;
        public static final int REQUEST_PRIORITY_HIGHEST = 4;

        public abstract Builder setHttpMethod(String var1);

        public abstract Builder addHeader(String var1, String var2);

        public abstract Builder disableCache();

        public abstract Builder setPriority(int var1);

        public abstract Builder setUploadDataProvider(UploadDataProvider var1, Executor var2);

        public abstract Builder allowDirectExecutor();

        public Builder addRequestAnnotation(Object annotation) {
            return this;
        }

        public Builder setTrafficStatsTag(int tag) {
            return this;
        }

        public Builder setTrafficStatsUid(int uid) {
            return this;
        }

        public Builder setRequestFinishedListener(RequestFinishedInfo.Listener listener) {
            return this;
        }

        public abstract UrlRequest build();
    }
}

