/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import androidx.annotation.Nullable;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Map;

final class ContentTypeParametersParser {
    private static final String TOKEN_ALLOWED_SPECIAL_CHARS = "!#$%&'*+-.^_`|~";
    private final String mHeaderValue;
    private int mCurrentPosition;

    ContentTypeParametersParser(String mHeaderValue) {
        this.mHeaderValue = mHeaderValue;
        int semicolonIndex = mHeaderValue.indexOf(59);
        this.mCurrentPosition = semicolonIndex != -1 ? semicolonIndex + 1 : mHeaderValue.length();
    }

    @Nullable
    Map.Entry<String, String> getNextParameter() throws ContentTypeParametersParserException {
        int startPos = this.mCurrentPosition;
        this.optionallySkipWhitespace();
        String parameterName = this.getNextToken();
        if (this.currentChar() != '=') {
            throw new ContentTypeParametersParserException("Invalid parameter format: expected = at " + this.mCurrentPosition + ": [" + this.mHeaderValue + "]", this.mCurrentPosition);
        }
        this.advance();
        String parameterValue = this.currentChar() == '\"' ? this.getNextQuotedString() : this.getNextToken();
        this.optionallySkipWhitespace();
        if (this.hasMore()) {
            if (this.currentChar() != ';') {
                throw new ContentTypeParametersParserException("Invalid parameter format: expected ; at " + this.mCurrentPosition + ": [" + this.mHeaderValue + "]", this.mCurrentPosition);
            }
            this.advance();
        }
        return new AbstractMap.SimpleEntry<String, String>(parameterName, parameterValue);
    }

    private String getNextQuotedString() throws ContentTypeParametersParserException {
        int start = this.mCurrentPosition;
        if (this.currentChar() != '\"') {
            throw new ContentTypeParametersParserException("Not a quoted string: expected \" at " + this.mCurrentPosition + ": [" + this.mHeaderValue + "]", this.mCurrentPosition);
        }
        this.advance();
        StringBuilder sb = new StringBuilder();
        boolean escapeNext = false;
        while (true) {
            if (!this.hasMore()) {
                throw new ContentTypeParametersParserException("Unterminated quoted string at " + start + ": [" + this.mHeaderValue + "]", start);
            }
            if (escapeNext) {
                if (!ContentTypeParametersParser.isQuotedPairChar(this.currentChar())) {
                    throw new ContentTypeParametersParserException("Invalid character at " + this.mCurrentPosition + ": [" + this.mHeaderValue + "]", this.mCurrentPosition);
                }
                escapeNext = false;
                sb.append(this.currentChar());
                this.advance();
                continue;
            }
            if (this.currentChar() == '\"') {
                this.advance();
                return sb.toString();
            }
            if (this.currentChar() == '\\') {
                escapeNext = true;
                this.advance();
                continue;
            }
            if (!ContentTypeParametersParser.isQdtextChar(this.currentChar())) {
                throw new ContentTypeParametersParserException("Invalid character at " + this.mCurrentPosition + ": [" + this.mHeaderValue + "]", this.mCurrentPosition);
            }
            sb.append(this.currentChar());
            this.advance();
        }
    }

    private String getNextToken() throws ContentTypeParametersParserException {
        int start = this.mCurrentPosition;
        while (this.hasMore() && ContentTypeParametersParser.isTokenCharacter(this.currentChar())) {
            this.advance();
        }
        if (start == this.mCurrentPosition) {
            throw new ContentTypeParametersParserException("Token not found at position " + start + ": [" + this.mHeaderValue + "]", start);
        }
        return this.mHeaderValue.substring(start, this.mCurrentPosition);
    }

    boolean hasMore() {
        return this.mCurrentPosition < this.mHeaderValue.length();
    }

    private char currentChar() throws ContentTypeParametersParserException {
        if (!this.hasMore()) {
            throw new ContentTypeParametersParserException("End of header reached", this.mCurrentPosition);
        }
        return this.mHeaderValue.charAt(this.mCurrentPosition);
    }

    private void advance() throws ContentTypeParametersParserException {
        if (!this.hasMore()) {
            throw new ContentTypeParametersParserException("End of header reached", this.mCurrentPosition);
        }
        ++this.mCurrentPosition;
    }

    private void optionallySkipWhitespace() throws ContentTypeParametersParserException {
        while (this.hasMore() && ContentTypeParametersParser.isWhitespace(this.currentChar())) {
            this.advance();
        }
    }

    private static boolean isQdtextChar(char c) {
        return c != '\\' && c != '\"' && ContentTypeParametersParser.isQuotedPairChar(c);
    }

    private static boolean isQuotedPairChar(char c) {
        return ContentTypeParametersParser.isWhitespace(c) || '!' <= c && c <= '\u00ff' && c != '\u007f';
    }

    private static boolean isTokenCharacter(char ch) {
        return ContentTypeParametersParser.isAscii(ch) && (Character.isLetterOrDigit(ch) || TOKEN_ALLOWED_SPECIAL_CHARS.indexOf(ch) != -1);
    }

    private static boolean isAscii(char ch) {
        return '\u0000' <= ch && ch <= '\u007f';
    }

    private static boolean isWhitespace(char c) {
        return c == '\t' || c == ' ';
    }

    static class ContentTypeParametersParserException
    extends ParseException {
        ContentTypeParametersParserException(String reason, int offset) {
            super(reason, offset);
        }
    }
}

