/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import org.chromium.net.CronetException;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;

public abstract class ImplicitFlowControlCallback
extends UrlRequest.Callback {
    private static final int BYTE_BUFFER_CAPACITY = 32768;

    protected abstract boolean shouldFollowRedirect(UrlResponseInfo var1, String var2) throws Exception;

    protected abstract void onResponseStarted(UrlResponseInfo var1) throws Exception;

    protected abstract void onBodyChunkRead(UrlResponseInfo var1, ByteBuffer var2) throws Exception;

    protected abstract void onSucceeded(UrlResponseInfo var1);

    protected abstract void onFailed(@Nullable UrlResponseInfo var1, CronetException var2);

    protected abstract void onCanceled(@Nullable UrlResponseInfo var1);

    @Override
    public final void onResponseStarted(UrlRequest request, UrlResponseInfo info) throws Exception {
        this.onResponseStarted(info);
        request.read(ByteBuffer.allocateDirect(32768));
    }

    @Override
    public final void onRedirectReceived(UrlRequest request, UrlResponseInfo info, String newLocationUrl) throws Exception {
        if (this.shouldFollowRedirect(info, newLocationUrl)) {
            request.followRedirect();
        } else {
            request.cancel();
        }
    }

    @Override
    public final void onReadCompleted(UrlRequest request, UrlResponseInfo info, ByteBuffer byteBuffer) throws Exception {
        byteBuffer.flip();
        this.onBodyChunkRead(info, byteBuffer);
        byteBuffer.clear();
        request.read(byteBuffer);
    }

    @Override
    public final void onSucceeded(UrlRequest request, UrlResponseInfo info) {
        this.onSucceeded(info);
    }

    @Override
    public final void onFailed(UrlRequest request, UrlResponseInfo info, CronetException error) {
        this.onFailed(info, error);
    }

    @Override
    public final void onCanceled(UrlRequest request, UrlResponseInfo info) {
        this.onCanceled(info);
    }
}

