/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import androidx.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.chromium.net.CronetException;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.apihelpers.ByteArrayCronetCallback;
import org.chromium.net.apihelpers.CronetRequestCompletionListener;
import org.chromium.net.apihelpers.CronetResponse;
import org.chromium.net.apihelpers.InMemoryTransformCronetCallback;
import org.chromium.net.apihelpers.JsonCronetCallback;
import org.chromium.net.apihelpers.RedirectHandler;
import org.chromium.net.apihelpers.StringCronetCallback;
import org.json.JSONObject;

public class UrlRequestCallbacks {
    public static ByteArrayCronetCallback forByteArrayBody(RedirectHandler redirectHandler, CronetRequestCompletionListener<byte[]> listener) {
        return UrlRequestCallbacks.newByteArrayCallback(redirectHandler).addCompletionListener(listener);
    }

    public static CallbackAndResponseFuturePair<byte[], ByteArrayCronetCallback> forByteArrayBody(RedirectHandler redirectHandler) {
        ByteArrayCronetCallback callback = UrlRequestCallbacks.newByteArrayCallback(redirectHandler);
        Future future = UrlRequestCallbacks.addResponseFutureListener(callback);
        return new CallbackAndResponseFuturePair<byte[], ByteArrayCronetCallback>(future, callback);
    }

    public static StringCronetCallback forStringBody(RedirectHandler redirectHandler, CronetRequestCompletionListener<String> listener) {
        return UrlRequestCallbacks.newStringCallback(redirectHandler).addCompletionListener(listener);
    }

    public static CallbackAndResponseFuturePair<String, StringCronetCallback> forStringBody(RedirectHandler redirectHandler) {
        StringCronetCallback callback = UrlRequestCallbacks.newStringCallback(redirectHandler);
        Future future = UrlRequestCallbacks.addResponseFutureListener(callback);
        return new CallbackAndResponseFuturePair<String, StringCronetCallback>(future, callback);
    }

    public static JsonCronetCallback forJsonBody(RedirectHandler redirectHandler, CronetRequestCompletionListener<JSONObject> listener) {
        return UrlRequestCallbacks.newJsonCallback(redirectHandler).addCompletionListener(listener);
    }

    public static CallbackAndResponseFuturePair<JSONObject, JsonCronetCallback> forJsonBody(RedirectHandler redirectHandler) {
        JsonCronetCallback callback = UrlRequestCallbacks.newJsonCallback(redirectHandler);
        Future future = UrlRequestCallbacks.addResponseFutureListener(callback);
        return new CallbackAndResponseFuturePair<JSONObject, JsonCronetCallback>(future, callback);
    }

    private static ByteArrayCronetCallback newByteArrayCallback(final RedirectHandler redirectHandler) {
        return new ByteArrayCronetCallback(){

            @Override
            protected boolean shouldFollowRedirect(UrlResponseInfo info, String newLocationUrl) throws Exception {
                return redirectHandler.shouldFollowRedirect(info, newLocationUrl);
            }
        };
    }

    private static StringCronetCallback newStringCallback(final RedirectHandler redirectHandler) {
        return new StringCronetCallback(){

            @Override
            protected boolean shouldFollowRedirect(UrlResponseInfo info, String newLocationUrl) throws Exception {
                return redirectHandler.shouldFollowRedirect(info, newLocationUrl);
            }
        };
    }

    private static JsonCronetCallback newJsonCallback(final RedirectHandler redirectHandler) {
        return new JsonCronetCallback(){

            @Override
            protected boolean shouldFollowRedirect(UrlResponseInfo info, String newLocationUrl) throws Exception {
                return redirectHandler.shouldFollowRedirect(info, newLocationUrl);
            }
        };
    }

    private static <T> Future<CronetResponse<T>> addResponseFutureListener(InMemoryTransformCronetCallback<T> callback) {
        final CompletableFuture<CronetResponse<T>> completableFuture = new CompletableFuture<CronetResponse<T>>();
        callback.addCompletionListener(new CronetRequestCompletionListener<T>(){

            @Override
            public void onFailed(@Nullable UrlResponseInfo info, CronetException exception) {
                completableFuture.completeExceptionally(exception);
            }

            @Override
            public void onCanceled(@Nullable UrlResponseInfo info) {
                completableFuture.completeExceptionally(new CronetException("The request was canceled!", null){});
            }

            @Override
            public void onSucceeded(UrlResponseInfo info, T body) {
                completableFuture.complete(new CronetResponse(info, body));
            }
        });
        return completableFuture;
    }

    private UrlRequestCallbacks() {
    }

    public static class CallbackAndResponseFuturePair<ResponseBodyT, CallbackT extends InMemoryTransformCronetCallback<ResponseBodyT>> {
        private final Future<CronetResponse<ResponseBodyT>> mFuture;
        private final CallbackT mCallback;

        CallbackAndResponseFuturePair(Future<CronetResponse<ResponseBodyT>> future, CallbackT callback) {
            this.mFuture = future;
            this.mCallback = callback;
        }

        public Future<CronetResponse<ResponseBodyT>> getFuture() {
            return this.mFuture;
        }

        public CallbackT getCallback() {
            return this.mCallback;
        }
    }
}

