/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.net.ConnectionMigrationOptions;
import org.chromium.net.CronetEngine;
import org.chromium.net.DnsOptions;
import org.chromium.net.ExperimentalCronetEngine;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.QuicOptions;
import org.json.JSONException;
import org.json.JSONObject;

final class ExperimentalOptionsTranslatingCronetEngineBuilder
extends ICronetEngineBuilder {
    private static final Set<Integer> SUPPORTED_OPTIONS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 3)));
    private JSONObject mParsedExperimentalOptions;
    private final List<ExperimentalOptionsPatch> mExperimentalOptionsPatches = new ArrayList<ExperimentalOptionsPatch>();
    private final ICronetEngineBuilder mDelegate;

    ExperimentalOptionsTranslatingCronetEngineBuilder(ICronetEngineBuilder delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public ICronetEngineBuilder setQuicOptions(QuicOptions options) {
        if (this.mDelegate.getSupportedConfigOptions().contains(3)) {
            this.mDelegate.setQuicOptions(options);
            return this;
        }
        this.mExperimentalOptionsPatches.add(experimentalOptions -> {
            JSONObject quicOptions = ExperimentalOptionsTranslatingCronetEngineBuilder.createDefaultIfAbsent(experimentalOptions, "QUIC");
            if (!options.getQuicHostAllowlist().isEmpty()) {
                quicOptions.put("host_whitelist", (Object)String.join((CharSequence)",", options.getQuicHostAllowlist()));
            }
            if (!options.getEnabledQuicVersions().isEmpty()) {
                quicOptions.put("quic_version", (Object)String.join((CharSequence)",", options.getEnabledQuicVersions()));
            }
            if (!options.getConnectionOptions().isEmpty()) {
                quicOptions.put("connection_options", (Object)String.join((CharSequence)",", options.getConnectionOptions()));
            }
            if (!options.getClientConnectionOptions().isEmpty()) {
                quicOptions.put("client_connection_options", (Object)String.join((CharSequence)",", options.getClientConnectionOptions()));
            }
            if (!options.getExtraQuicheFlags().isEmpty()) {
                quicOptions.put("set_quic_flags", (Object)String.join((CharSequence)",", options.getExtraQuicheFlags()));
            }
            if (options.getInMemoryServerConfigsCacheSize() != null) {
                quicOptions.put("max_server_configs_stored_in_properties", (Object)options.getInMemoryServerConfigsCacheSize());
            }
            if (options.getHandshakeUserAgent() != null) {
                quicOptions.put("user_agent_id", (Object)options.getHandshakeUserAgent());
            }
            if (options.getRetryWithoutAltSvcOnQuicErrors() != null) {
                quicOptions.put("retry_without_alt_svc_on_quic_errors", (Object)options.getRetryWithoutAltSvcOnQuicErrors());
            }
            if (options.getEnableTlsZeroRtt() != null) {
                quicOptions.put("disable_tls_zero_rtt", options.getEnableTlsZeroRtt() == false);
            }
            if (options.getPreCryptoHandshakeIdleTimeoutSeconds() != null) {
                quicOptions.put("max_idle_time_before_crypto_handshake_seconds", (Object)options.getPreCryptoHandshakeIdleTimeoutSeconds());
            }
            if (options.getCryptoHandshakeTimeoutSeconds() != null) {
                quicOptions.put("max_time_before_crypto_handshake_seconds", (Object)options.getCryptoHandshakeTimeoutSeconds());
            }
            if (options.getIdleConnectionTimeoutSeconds() != null) {
                quicOptions.put("idle_connection_timeout_seconds", (Object)options.getIdleConnectionTimeoutSeconds());
            }
            if (options.getRetransmittableOnWireTimeoutMillis() != null) {
                quicOptions.put("retransmittable_on_wire_timeout_milliseconds", (Object)options.getRetransmittableOnWireTimeoutMillis());
            }
            if (options.getCloseSessionsOnIpChange() != null) {
                quicOptions.put("close_sessions_on_ip_change", (Object)options.getCloseSessionsOnIpChange());
            }
            if (options.getGoawaySessionsOnIpChange() != null) {
                quicOptions.put("goaway_sessions_on_ip_change", (Object)options.getGoawaySessionsOnIpChange());
            }
            if (options.getInitialBrokenServicePeriodSeconds() != null) {
                quicOptions.put("initial_delay_for_broken_alternative_service_seconds", (Object)options.getInitialBrokenServicePeriodSeconds());
            }
            if (options.getIncreaseBrokenServicePeriodExponentially() != null) {
                quicOptions.put("exponential_backoff_on_initial_delay", (Object)options.getIncreaseBrokenServicePeriodExponentially());
            }
            if (options.getDelayJobsWithAvailableSpdySession() != null) {
                quicOptions.put("delay_main_job_with_available_spdy_session", (Object)options.getDelayJobsWithAvailableSpdySession());
            }
        });
        return this;
    }

    @Override
    public ICronetEngineBuilder setDnsOptions(DnsOptions options) {
        if (this.mDelegate.getSupportedConfigOptions().contains(2)) {
            this.mDelegate.setDnsOptions(options);
            return this;
        }
        this.mExperimentalOptionsPatches.add(experimentalOptions -> {
            JSONObject asyncDnsOptions = ExperimentalOptionsTranslatingCronetEngineBuilder.createDefaultIfAbsent(experimentalOptions, "AsyncDNS");
            if (options.getUseBuiltInDnsResolver() != null) {
                asyncDnsOptions.put("enable", (Object)options.getUseBuiltInDnsResolver());
            }
            JSONObject staleDnsOptions = ExperimentalOptionsTranslatingCronetEngineBuilder.createDefaultIfAbsent(experimentalOptions, "StaleDNS");
            if (options.getEnableStaleDns() != null) {
                staleDnsOptions.put("enable", (Object)options.getEnableStaleDns());
            }
            if (options.getPersistHostCache() != null) {
                staleDnsOptions.put("persist_to_disk", (Object)options.getPersistHostCache());
            }
            if (options.getPersistHostCachePeriodMillis() != null) {
                staleDnsOptions.put("persist_delay_ms", (Object)options.getPersistHostCachePeriodMillis());
            }
            if (options.getStaleDnsOptions() != null) {
                DnsOptions.StaleDnsOptions staleDnsOptionsJava = options.getStaleDnsOptions();
                if (staleDnsOptionsJava.getAllowCrossNetworkUsage() != null) {
                    staleDnsOptions.put("allow_other_network", (Object)staleDnsOptionsJava.getAllowCrossNetworkUsage());
                }
                if (staleDnsOptionsJava.getFreshLookupTimeoutMillis() != null) {
                    staleDnsOptions.put("delay_ms", (Object)staleDnsOptionsJava.getFreshLookupTimeoutMillis());
                }
                if (staleDnsOptionsJava.getUseStaleOnNameNotResolved() != null) {
                    staleDnsOptions.put("use_stale_on_name_not_resolved", (Object)staleDnsOptionsJava.getUseStaleOnNameNotResolved());
                }
                if (staleDnsOptionsJava.getMaxExpiredDelayMillis() != null) {
                    staleDnsOptions.put("max_expired_time_ms", (Object)staleDnsOptionsJava.getMaxExpiredDelayMillis());
                }
            }
            JSONObject quicOptions = ExperimentalOptionsTranslatingCronetEngineBuilder.createDefaultIfAbsent(experimentalOptions, "QUIC");
            if (options.getPreestablishConnectionsToStaleDnsResults() != null) {
                quicOptions.put("race_stale_dns_on_connection", (Object)options.getPreestablishConnectionsToStaleDnsResults());
            }
        });
        return this;
    }

    @Override
    public ICronetEngineBuilder setConnectionMigrationOptions(ConnectionMigrationOptions options) {
        if (this.mDelegate.getSupportedConfigOptions().contains(1)) {
            this.mDelegate.setConnectionMigrationOptions(options);
            return this;
        }
        this.mExperimentalOptionsPatches.add(experimentalOptions -> {
            JSONObject quicOptions = ExperimentalOptionsTranslatingCronetEngineBuilder.createDefaultIfAbsent(experimentalOptions, "QUIC");
            if (options.getEnableDefaultNetworkMigration() != null) {
                quicOptions.put("migrate_sessions_on_network_change_v2", (Object)options.getEnableDefaultNetworkMigration());
            }
            if (options.getAllowServerMigration() != null) {
                quicOptions.put("allow_server_migration", (Object)options.getAllowServerMigration());
            }
            if (options.getMigrateIdleConnections() != null) {
                quicOptions.put("migrate_idle_sessions", (Object)options.getMigrateIdleConnections());
            }
            if (options.getIdleMigrationPeriodSeconds() != null) {
                quicOptions.put("idle_session_migration_period_seconds", (Object)options.getIdleMigrationPeriodSeconds());
            }
            if (options.getRetryPreHandshakeErrorsOnAlternateNetwork() != null) {
                quicOptions.put("retry_on_alternate_network_before_handshake", (Object)options.getRetryPreHandshakeErrorsOnAlternateNetwork());
            }
            if (options.getMaxTimeOnNonDefaultNetworkSeconds() != null) {
                quicOptions.put("max_time_on_non_default_network_seconds", (Object)options.getMaxTimeOnNonDefaultNetworkSeconds());
            }
            if (options.getMaxPathDegradingEagerMigrationsCount() != null) {
                quicOptions.put("max_migrations_to_non_default_network_on_path_degrading", (Object)options.getMaxPathDegradingEagerMigrationsCount());
            }
            if (options.getMaxWriteErrorEagerMigrationsCount() != null) {
                quicOptions.put("max_migrations_to_non_default_network_on_write_error", (Object)options.getMaxWriteErrorEagerMigrationsCount());
            }
            if (options.getEnablePathDegradationMigration() != null) {
                boolean pathDegradationValue = options.getEnablePathDegradationMigration();
                boolean skipPortMigrationFlag = false;
                if (options.getAllowNonDefaultNetworkUsage() != null) {
                    boolean nonDefaultNetworkValue = options.getAllowNonDefaultNetworkUsage();
                    if (!pathDegradationValue && nonDefaultNetworkValue) {
                        throw new IllegalArgumentException("Unable to turn on non-default network usage without path degradation migration!");
                    }
                    if (pathDegradationValue && nonDefaultNetworkValue) {
                        quicOptions.put("migrate_sessions_early_v2", true);
                        skipPortMigrationFlag = true;
                    } else {
                        quicOptions.put("migrate_sessions_early_v2", false);
                    }
                }
                if (!skipPortMigrationFlag) {
                    quicOptions.put("allow_port_migration", pathDegradationValue);
                }
            }
        });
        return this;
    }

    @Override
    public ICronetEngineBuilder setExperimentalOptions(String options) {
        this.mParsedExperimentalOptions = options == null || options.isEmpty() ? null : ExperimentalOptionsTranslatingCronetEngineBuilder.parseExperimentalOptions(options);
        return this;
    }

    @Override
    protected Set<Integer> getSupportedConfigOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public ExperimentalCronetEngine build() {
        if (this.mParsedExperimentalOptions == null && this.mExperimentalOptionsPatches.isEmpty()) {
            return this.mDelegate.build();
        }
        if (this.mParsedExperimentalOptions == null) {
            this.mParsedExperimentalOptions = new JSONObject();
        }
        for (ExperimentalOptionsPatch patch : this.mExperimentalOptionsPatches) {
            try {
                patch.applyTo(this.mParsedExperimentalOptions);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Unable to apply JSON patch!", e);
            }
        }
        this.mDelegate.setExperimentalOptions(this.mParsedExperimentalOptions.toString());
        return this.mDelegate.build();
    }

    private static JSONObject parseExperimentalOptions(String jsonString) {
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Experimental options parsing failed", e);
        }
    }

    private static JSONObject createDefaultIfAbsent(JSONObject jsonObject, String key) {
        JSONObject object = jsonObject.optJSONObject(key);
        if (object == null) {
            object = new JSONObject();
            try {
                jsonObject.put(key, (Object)object);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Failed adding a default object for key [" + key + "]", e);
            }
        }
        return object;
    }

    @VisibleForTesting
    ICronetEngineBuilder getDelegate() {
        return this.mDelegate;
    }

    @Override
    public ICronetEngineBuilder addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
        this.mDelegate.addPublicKeyPins(hostName, pinsSha256, includeSubdomains, expirationDate);
        return this;
    }

    @Override
    public ICronetEngineBuilder addQuicHint(String host, int port, int alternatePort) {
        this.mDelegate.addQuicHint(host, port, alternatePort);
        return this;
    }

    @Override
    public ICronetEngineBuilder enableHttp2(boolean value) {
        this.mDelegate.enableHttp2(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder enableHttpCache(int cacheMode, long maxSize) {
        this.mDelegate.enableHttpCache(cacheMode, maxSize);
        return this;
    }

    @Override
    public ICronetEngineBuilder enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
        this.mDelegate.enablePublicKeyPinningBypassForLocalTrustAnchors(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder enableQuic(boolean value) {
        this.mDelegate.enableQuic(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder enableSdch(boolean value) {
        this.mDelegate.enableSdch(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder enableBrotli(boolean value) {
        this.mDelegate.enableBrotli(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder setLibraryLoader(CronetEngine.Builder.LibraryLoader loader) {
        this.mDelegate.setLibraryLoader(loader);
        return this;
    }

    @Override
    public ICronetEngineBuilder setStoragePath(String value) {
        this.mDelegate.setStoragePath(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder setUserAgent(String userAgent) {
        this.mDelegate.setUserAgent(userAgent);
        return this;
    }

    @Override
    public String getDefaultUserAgent() {
        return this.mDelegate.getDefaultUserAgent();
    }

    @Override
    public ICronetEngineBuilder enableNetworkQualityEstimator(boolean value) {
        this.mDelegate.enableNetworkQualityEstimator(value);
        return this;
    }

    @Override
    public ICronetEngineBuilder setThreadPriority(int priority) {
        this.mDelegate.setThreadPriority(priority);
        return this;
    }

    @FunctionalInterface
    private static interface ExperimentalOptionsPatch {
        public void applyTo(JSONObject var1) throws JSONException;
    }
}

