/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.chromium.net.ConnectionMigrationOptions;
import org.chromium.net.CronetEngine;
import org.chromium.net.DnsOptions;
import org.chromium.net.ExperimentalCronetEngine;
import org.chromium.net.QuicOptions;

public abstract class ICronetEngineBuilder {
    public static final int CONNECTION_MIGRATION_OPTIONS = 1;
    public static final int DNS_OPTIONS = 2;
    public static final int QUIC_OPTIONS = 3;

    public abstract ICronetEngineBuilder addPublicKeyPins(String var1, Set<byte[]> var2, boolean var3, Date var4);

    public abstract ICronetEngineBuilder addQuicHint(String var1, int var2, int var3);

    public abstract ICronetEngineBuilder enableHttp2(boolean var1);

    public abstract ICronetEngineBuilder enableHttpCache(int var1, long var2);

    public abstract ICronetEngineBuilder enablePublicKeyPinningBypassForLocalTrustAnchors(boolean var1);

    public abstract ICronetEngineBuilder enableQuic(boolean var1);

    public abstract ICronetEngineBuilder enableSdch(boolean var1);

    public ICronetEngineBuilder enableBrotli(boolean value) {
        return this;
    }

    public ICronetEngineBuilder setQuicOptions(QuicOptions quicOptions) {
        return this;
    }

    public ICronetEngineBuilder setDnsOptions(DnsOptions dnsOptions) {
        return this;
    }

    public ICronetEngineBuilder setConnectionMigrationOptions(ConnectionMigrationOptions connectionMigrationOptions) {
        return this;
    }

    public abstract ICronetEngineBuilder setExperimentalOptions(String var1);

    public abstract ICronetEngineBuilder setLibraryLoader(CronetEngine.Builder.LibraryLoader var1);

    public abstract ICronetEngineBuilder setStoragePath(String var1);

    public abstract ICronetEngineBuilder setUserAgent(String var1);

    public abstract String getDefaultUserAgent();

    public abstract ExperimentalCronetEngine build();

    protected Set<Integer> getSupportedConfigOptions() {
        return Collections.emptySet();
    }

    public ICronetEngineBuilder enableNetworkQualityEstimator(boolean value) {
        return this;
    }

    public ICronetEngineBuilder setThreadPriority(int priority) {
        return this;
    }
}

