/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import org.chromium.net.UrlResponseInfo;
import org.chromium.net.apihelpers.CronetRequestCompletionListener;
import org.chromium.net.apihelpers.InMemoryTransformCronetCallback;
import org.chromium.net.apihelpers.StringCronetCallback;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonCronetCallback
extends InMemoryTransformCronetCallback<JSONObject> {
    private static final StringCronetCallback STRING_CALLBACK = new StringCronetCallback(){

        @Override
        protected boolean shouldFollowRedirect(UrlResponseInfo info, String newLocationUrl) {
            throw new UnsupportedOperationException();
        }
    };

    public JsonCronetCallback addCompletionListener(CronetRequestCompletionListener<? super JSONObject> listener) {
        super.addCompletionListener(listener);
        return this;
    }

    @Override
    protected JSONObject transformBodyBytes(UrlResponseInfo info, byte[] bodyBytes) {
        String bodyString = STRING_CALLBACK.transformBodyBytes(info, bodyBytes);
        try {
            return new JSONObject(bodyString);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cannot parse the string as JSON!", e);
        }
    }
}

