/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;

public final class UploadDataProviders {
    public static UploadDataProvider create(final File file) {
        return new FileUploadProvider(new FileChannelProvider(){

            @Override
            public FileChannel getChannel() throws IOException {
                return new FileInputStream(file).getChannel();
            }
        });
    }

    public static UploadDataProvider create(final ParcelFileDescriptor fd) {
        return new FileUploadProvider(new FileChannelProvider(){

            @Override
            public FileChannel getChannel() throws IOException {
                if (fd.getStatSize() != -1L) {
                    return new ParcelFileDescriptor.AutoCloseInputStream(fd).getChannel();
                }
                fd.close();
                throw new IllegalArgumentException("Not a file: " + fd);
            }
        });
    }

    public static UploadDataProvider create(ByteBuffer buffer) {
        return new ByteBufferUploadProvider(buffer.slice());
    }

    public static UploadDataProvider create(byte[] data, int offset, int length) {
        return new ByteBufferUploadProvider(ByteBuffer.wrap(data, offset, length).slice());
    }

    public static UploadDataProvider create(byte[] data) {
        return UploadDataProviders.create(data, 0, data.length);
    }

    private UploadDataProviders() {
    }

    private static final class FileUploadProvider
    extends UploadDataProvider {
        private volatile FileChannel mChannel;
        private final FileChannelProvider mProvider;
        private final Object mLock = new Object();

        private FileUploadProvider(FileChannelProvider provider) {
            this.mProvider = provider;
        }

        @Override
        public long getLength() throws IOException {
            return this.getChannel().size();
        }

        @Override
        public void read(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) throws IOException {
            int read;
            if (!byteBuffer.hasRemaining()) {
                throw new IllegalStateException("Cronet passed a buffer with no bytes remaining");
            }
            FileChannel channel = this.getChannel();
            for (int bytesRead = 0; bytesRead == 0 && (read = channel.read(byteBuffer)) != -1; bytesRead += read) {
            }
            uploadDataSink.onReadSucceeded(false);
        }

        @Override
        public void rewind(UploadDataSink uploadDataSink) throws IOException {
            this.getChannel().position(0L);
            uploadDataSink.onRewindSucceeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileChannel getChannel() throws IOException {
            if (this.mChannel == null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mChannel == null) {
                        this.mChannel = this.mProvider.getChannel();
                    }
                }
            }
            return this.mChannel;
        }

        @Override
        public void close() throws IOException {
            FileChannel channel = this.mChannel;
            if (channel != null) {
                channel.close();
            }
        }
    }

    private static interface FileChannelProvider {
        public FileChannel getChannel() throws IOException;
    }

    private static final class ByteBufferUploadProvider
    extends UploadDataProvider {
        private final ByteBuffer mUploadBuffer;

        private ByteBufferUploadProvider(ByteBuffer uploadBuffer) {
            this.mUploadBuffer = uploadBuffer;
        }

        @Override
        public long getLength() {
            return this.mUploadBuffer.limit();
        }

        @Override
        public void read(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) {
            if (!byteBuffer.hasRemaining()) {
                throw new IllegalStateException("Cronet passed a buffer with no bytes remaining");
            }
            if (byteBuffer.remaining() >= this.mUploadBuffer.remaining()) {
                byteBuffer.put(this.mUploadBuffer);
            } else {
                int oldLimit = this.mUploadBuffer.limit();
                this.mUploadBuffer.limit(this.mUploadBuffer.position() + byteBuffer.remaining());
                byteBuffer.put(this.mUploadBuffer);
                this.mUploadBuffer.limit(oldLimit);
            }
            uploadDataSink.onReadSucceeded(false);
        }

        @Override
        public void rewind(UploadDataSink uploadDataSink) {
            this.mUploadBuffer.position(0);
            uploadDataSink.onRewindSucceeded();
        }
    }
}

