/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.chromium.net.CronetEngine;
import org.chromium.net.impl.CronetLogger;

public abstract class CronetProvider {
    public static final String PROVIDER_NAME_APP_PACKAGED = "App-Packaged-Cronet-Provider";
    public static final String PROVIDER_NAME_FALLBACK = "Fallback-Cronet-Provider";
    private static final String RES_KEY_CRONET_IMPL_CLASS = "CronetProviderClassName";
    private static final String TAG = CronetProvider.class.getSimpleName();
    private static final String JAVA_CRONET_PROVIDER_CLASS = "org.chromium.net.impl.JavaCronetProvider";
    private static final String NATIVE_CRONET_PROVIDER_CLASS = "org.chromium.net.impl.NativeCronetProvider";
    private static final String PLAY_SERVICES_CRONET_PROVIDER_CLASS = "com.google.android.gms.net.PlayServicesCronetProvider";
    private static final String GMS_CORE_CRONET_PROVIDER_CLASS = "com.google.android.gms.net.GmsCoreCronetProvider";
    protected final Context mContext;

    protected CronetProvider(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        this.mContext = context;
    }

    public static List<CronetProvider> getAllProviders(Context context) {
        ArrayList<CronetProvider> providers = new ArrayList<CronetProvider>();
        for (ProviderInfo providerInfo : CronetProvider.getAllProviderInfos(context)) {
            providers.add(providerInfo.provider);
        }
        return Collections.unmodifiableList(providers);
    }

    static List<ProviderInfo> getAllProviderInfos(Context context) {
        LinkedHashSet<ProviderInfo> providers = new LinkedHashSet<ProviderInfo>();
        CronetProvider.addCronetProviderFromResourceFile(context, CronetLogger.CronetSource.CRONET_SOURCE_UNSPECIFIED, providers);
        CronetProvider.addCronetProviderImplByClassName(context, PLAY_SERVICES_CRONET_PROVIDER_CLASS, CronetLogger.CronetSource.CRONET_SOURCE_PLAY_SERVICES, providers, false);
        CronetProvider.addCronetProviderImplByClassName(context, GMS_CORE_CRONET_PROVIDER_CLASS, CronetLogger.CronetSource.CRONET_SOURCE_PLAY_SERVICES, providers, false);
        CronetProvider.addCronetProviderImplByClassName(context, NATIVE_CRONET_PROVIDER_CLASS, CronetLogger.CronetSource.CRONET_SOURCE_STATICALLY_LINKED, providers, false);
        CronetProvider.addCronetProviderImplByClassName(context, JAVA_CRONET_PROVIDER_CLASS, CronetLogger.CronetSource.CRONET_SOURCE_FALLBACK, providers, false);
        return Collections.unmodifiableList(new ArrayList<ProviderInfo>(providers));
    }

    private static boolean addCronetProviderImplByClassName(Context context, String className, CronetLogger.CronetSource logSource, Set<ProviderInfo> providers, boolean logError) {
        ClassLoader loader = context.getClassLoader();
        try {
            Class<CronetProvider> providerClass = loader.loadClass(className).asSubclass(CronetProvider.class);
            Constructor<CronetProvider> ctor = providerClass.getConstructor(Context.class);
            ProviderInfo providerInfo = new ProviderInfo();
            providerInfo.provider = ctor.newInstance(context);
            providerInfo.logSource = logSource;
            providers.add(providerInfo);
            return true;
        }
        catch (InstantiationException e) {
            CronetProvider.logReflectiveOperationException(className, logError, e);
        }
        catch (InvocationTargetException e) {
            CronetProvider.logReflectiveOperationException(className, logError, e);
        }
        catch (NoSuchMethodException e) {
            CronetProvider.logReflectiveOperationException(className, logError, e);
        }
        catch (IllegalAccessException e) {
            CronetProvider.logReflectiveOperationException(className, logError, e);
        }
        catch (ClassNotFoundException e) {
            CronetProvider.logReflectiveOperationException(className, logError, e);
        }
        return false;
    }

    private static void logReflectiveOperationException(String className, boolean logError, Exception e) {
        if (logError) {
            Log.e((String)TAG, (String)("Unable to load provider class: " + className), (Throwable)e);
        } else if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("Tried to load " + className + " provider class but it wasn't included in the app classpath"));
        }
    }

    private static boolean addCronetProviderFromResourceFile(Context context, CronetLogger.CronetSource logSource, Set<ProviderInfo> providers) {
        int resId = context.getResources().getIdentifier(RES_KEY_CRONET_IMPL_CLASS, "string", context.getPackageName());
        if (resId == 0) {
            return false;
        }
        String className = context.getString(resId);
        if (className == null || className.equals(PLAY_SERVICES_CRONET_PROVIDER_CLASS) || className.equals(GMS_CORE_CRONET_PROVIDER_CLASS) || className.equals(JAVA_CRONET_PROVIDER_CLASS) || className.equals(NATIVE_CRONET_PROVIDER_CLASS)) {
            return false;
        }
        if (!CronetProvider.addCronetProviderImplByClassName(context, className, logSource, providers, true)) {
            Log.e((String)TAG, (String)("Unable to instantiate Cronet implementation class " + className + " that is listed as in the app string resource file under CronetProviderClassName key"));
        }
        return true;
    }

    public abstract CronetEngine.Builder createBuilder();

    public abstract String getName();

    public abstract String getVersion();

    public abstract boolean isEnabled();

    public String toString() {
        return "[class=" + this.getClass().getName() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", enabled=" + this.isEnabled() + "]";
    }

    static final class ProviderInfo {
        public CronetProvider provider;
        public CronetLogger.CronetSource logSource;

        ProviderInfo() {
        }

        public int hashCode() {
            return this.provider.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ProviderInfo && this.provider.equals(((ProviderInfo)other).provider);
        }
    }
}

