/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Proxy {
    public static final int HTTP = 0;
    public static final int HTTPS = 1;
    private final int mScheme;
    @NonNull
    private final String mHost;
    private final int mPort;
    @NonNull
    private final Callback mCallback;

    public Proxy(int scheme, @NonNull String host, int port, @NonNull Callback callback) {
        if (scheme != 0 && scheme != 1) {
            throw new IllegalArgumentException(String.format("Unknown scheme %s", scheme));
        }
        this.mScheme = scheme;
        this.mHost = Objects.requireNonNull(host);
        this.mPort = port;
        this.mCallback = Objects.requireNonNull(callback);
    }

    public int getScheme() {
        return this.mScheme;
    }

    @NonNull
    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    @NonNull
    public Callback getCallback() {
        return this.mCallback;
    }

    public static abstract class Callback {
        @Nullable
        public abstract List<Map.Entry<String, String>> onBeforeTunnelRequest();

        public abstract boolean onTunnelHeadersReceived(@NonNull List<Map.Entry<String, String>> var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Scheme {
    }
}

