/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.chromium.net.CronetException;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.apihelpers.CronetRequestCompletionListener;
import org.chromium.net.apihelpers.ImplicitFlowControlCallback;

public abstract class InMemoryTransformCronetCallback<T>
extends ImplicitFlowControlCallback {
    private static final String CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private ByteArrayOutputStream mResponseBodyStream;
    private WritableByteChannel mResponseBodyChannel;
    private final Set<CronetRequestCompletionListener<? super T>> mListeners = new LinkedHashSet<CronetRequestCompletionListener<? super T>>();

    private static long getBodyLength(UrlResponseInfo info) {
        List<String> contentLengthHeader = info.getAllHeaders().get(CONTENT_LENGTH_HEADER_NAME);
        if (contentLengthHeader == null || contentLengthHeader.size() != 1) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLengthHeader.get(0));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    protected abstract T transformBodyBytes(UrlResponseInfo var1, byte[] var2);

    public ImplicitFlowControlCallback addCompletionListener(CronetRequestCompletionListener<? super T> listener) {
        this.mListeners.add(listener);
        return this;
    }

    @Override
    protected final void onResponseStarted(UrlResponseInfo info) {
        long bodyLength = InMemoryTransformCronetCallback.getBodyLength(info);
        if (bodyLength > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("The body is too large and wouldn't fit in a byte array!");
        }
        this.mResponseBodyStream = bodyLength >= 0L ? new ByteArrayOutputStream((int)bodyLength) : new ByteArrayOutputStream();
        this.mResponseBodyChannel = Channels.newChannel(this.mResponseBodyStream);
    }

    @Override
    protected final void onBodyChunkRead(UrlResponseInfo info, ByteBuffer bodyChunk) throws Exception {
        this.mResponseBodyChannel.write(bodyChunk);
    }

    @Override
    protected final void onSucceeded(UrlResponseInfo info) {
        T body = this.transformBodyBytes(info, this.mResponseBodyStream.toByteArray());
        for (CronetRequestCompletionListener<T> callback : this.mListeners) {
            callback.onSucceeded(info, body);
        }
    }

    @Override
    protected final void onFailed(@Nullable UrlResponseInfo info, CronetException exception) {
        for (CronetRequestCompletionListener<T> callback : this.mListeners) {
            callback.onFailed(info, exception);
        }
    }

    @Override
    protected final void onCanceled(@Nullable UrlResponseInfo info) {
        for (CronetRequestCompletionListener<T> callback : this.mListeners) {
            callback.onCanceled(info);
        }
    }
}

