/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.apihelpers;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.apihelpers.ContentTypeParametersParser;
import org.chromium.net.apihelpers.CronetRequestCompletionListener;
import org.chromium.net.apihelpers.InMemoryTransformCronetCallback;

public abstract class StringCronetCallback
extends InMemoryTransformCronetCallback<String> {
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";

    StringCronetCallback() {
    }

    private Charset getCharsetFromHeaders(UrlResponseInfo info) {
        List<String> contentTypeHeaders = info.getAllHeaders().get(CONTENT_TYPE_HEADER_NAME);
        String charset = null;
        block2: for (String header : contentTypeHeaders) {
            ContentTypeParametersParser parser = new ContentTypeParametersParser(header);
            while (parser.hasMore()) {
                Map.Entry<String, String> parameter;
                try {
                    parameter = parser.getNextParameter();
                }
                catch (ContentTypeParametersParser.ContentTypeParametersParserException e) {
                    continue block2;
                }
                String parameterValue = parameter.getValue();
                if (charset != null && !parameterValue.equalsIgnoreCase(charset)) {
                    throw new IllegalArgumentException("Multiple charsets provided: " + parameterValue + " and " + charset);
                }
                charset = parameterValue;
            }
        }
        if (charset != null) {
            return Charset.forName(charset);
        }
        return Charset.defaultCharset();
    }

    public StringCronetCallback addCompletionListener(CronetRequestCompletionListener<? super String> listener) {
        super.addCompletionListener(listener);
        return this;
    }

    @Override
    protected String transformBodyBytes(UrlResponseInfo info, byte[] bodyBytes) {
        return new String(bodyBytes, this.getCharsetFromHeaders(info));
    }
}

