/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.annotation.SuppressLint;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.impl.CronetEngineBase;

public class BidirectionalStreamBuilderImpl
extends ExperimentalBidirectionalStream.Builder {
    private final CronetEngineBase mCronetEngine;
    private final String mUrl;
    private final BidirectionalStream.Callback mCallback;
    private final Executor mExecutor;
    private final ArrayList<Map.Entry<String, String>> mRequestHeaders = new ArrayList();
    private String mHttpMethod = "POST";
    private int mPriority = 3;
    private boolean mDelayRequestHeadersUntilFirstFlush;
    private Collection<Object> mRequestAnnotations;
    private boolean mTrafficStatsTagSet;
    private int mTrafficStatsTag;
    private boolean mTrafficStatsUidSet;
    private int mTrafficStatsUid;
    private long mNetworkHandle = -1L;

    BidirectionalStreamBuilderImpl(String url, BidirectionalStream.Callback callback, Executor executor, CronetEngineBase cronetEngine) {
        this.mUrl = Objects.requireNonNull(url, "URL is required.");
        this.mCallback = Objects.requireNonNull(callback, "Callback is required.");
        this.mExecutor = Objects.requireNonNull(executor, "Executor is required.");
        this.mCronetEngine = Objects.requireNonNull(cronetEngine, "CronetEngine is required.");
    }

    public BidirectionalStreamBuilderImpl setHttpMethod(String method) {
        this.mHttpMethod = Objects.requireNonNull(method, "Method is required.");
        return this;
    }

    public BidirectionalStreamBuilderImpl addHeader(String header, String value) {
        Objects.requireNonNull(header, "Invalid header name.");
        Objects.requireNonNull(value, "Invalid header value.");
        this.mRequestHeaders.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
        return this;
    }

    public BidirectionalStreamBuilderImpl setPriority(int priority) {
        this.mPriority = priority;
        return this;
    }

    public BidirectionalStreamBuilderImpl delayRequestHeadersUntilFirstFlush(boolean delayRequestHeadersUntilFirstFlush) {
        this.mDelayRequestHeadersUntilFirstFlush = delayRequestHeadersUntilFirstFlush;
        return this;
    }

    public ExperimentalBidirectionalStream.Builder addRequestAnnotation(Object annotation) {
        Objects.requireNonNull(annotation, "Invalid metrics annotation.");
        if (this.mRequestAnnotations == null) {
            this.mRequestAnnotations = new ArrayList<Object>();
        }
        this.mRequestAnnotations.add(annotation);
        return this;
    }

    public ExperimentalBidirectionalStream.Builder setTrafficStatsTag(int tag) {
        this.mTrafficStatsTagSet = true;
        this.mTrafficStatsTag = tag;
        return this;
    }

    public ExperimentalBidirectionalStream.Builder setTrafficStatsUid(int uid) {
        this.mTrafficStatsUidSet = true;
        this.mTrafficStatsUid = uid;
        return this;
    }

    public ExperimentalBidirectionalStream.Builder bindToNetwork(long networkHandle) {
        this.mNetworkHandle = networkHandle;
        return this;
    }

    @SuppressLint(value={"WrongConstant"})
    public ExperimentalBidirectionalStream build() {
        return this.mCronetEngine.createBidirectionalStream(this.mUrl, this.mCallback, this.mExecutor, this.mHttpMethod, this.mRequestHeaders, this.mPriority, this.mDelayRequestHeadersUntilFirstFlush, this.mRequestAnnotations, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mNetworkHandle);
    }
}

