/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.os.Process;
import android.os.SystemClock;
import android.util.Base64;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.IDN;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.chromium.net.CronetEngine;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.ProxyOptions;
import org.chromium.net.impl.CronetLogger;
import org.chromium.net.impl.CronetLoggerFactory;
import org.chromium.net.impl.ImplVersion;
import org.chromium.net.impl.UserAgent;
import org.chromium.net.impl.VersionSafeCallbacks;
import org.chromium.net.impl.VersionSafeProxyOptions;

public abstract class CronetEngineBuilderImpl
extends ICronetEngineBuilder {
    private static final Pattern INVALID_PKP_HOST_NAME = Pattern.compile("^[0-9\\.]*$");
    @VisibleForTesting
    static int sApiLevel = VersionSafeCallbacks.ApiVersion.getMaximumAvailableApiLevel();
    @VisibleForTesting
    public static final int NETWORK_THREAD_PRIORITY = 0;
    protected final CronetLogger mLogger;
    private final Context mApplicationContext;
    private final List<QuicHint> mQuicHints = new LinkedList<QuicHint>();
    private final List<Pkp> mPkps = new LinkedList<Pkp>();
    private boolean mPublicKeyPinningBypassForLocalTrustAnchorsEnabled;
    private String mUserAgent;
    private String mStoragePath;
    private boolean mQuicEnabled;
    private boolean mHttp2Enabled;
    private boolean mBrotiEnabled;
    private HttpCacheMode mHttpCacheMode;
    private long mHttpCacheMaxSize;
    private String mExperimentalOptions;
    protected long mMockCertVerifier;
    private boolean mNetworkQualityEstimatorEnabled;
    @Nullable
    private VersionSafeProxyOptions mProxyOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronetEngineBuilderImpl(Context context, CronetLogger.CronetSource cronetSource) {
        long startUptimeMillis = SystemClock.uptimeMillis();
        boolean successful = false;
        this.mApplicationContext = context.getApplicationContext();
        this.mLogger = CronetLoggerFactory.createLogger((Context)this.mApplicationContext, (CronetLogger.CronetSource)cronetSource);
        try {
            this.enableQuic(true);
            this.enableHttp2(true);
            this.enableBrotli(false);
            this.enableHttpCache(0, 0L);
            this.enableNetworkQualityEstimator(false);
            this.enablePublicKeyPinningBypassForLocalTrustAnchors(true);
            successful = true;
        }
        finally {
            this.maybeLogCronetEngineBuilderInitializedInfo(startUptimeMillis, successful, cronetSource);
        }
    }

    public CronetEngineBuilderImpl(Context context) {
        this(context, CronetLogger.CronetSource.CRONET_SOURCE_UNSPECIFIED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogCronetEngineBuilderInitializedInfo(long startUptimeMillis, boolean successful, CronetLogger.CronetSource cronetSource) {
        if (sApiLevel >= 30) {
            return;
        }
        CronetLogger.CronetEngineBuilderInitializedInfo logInfo = new CronetLogger.CronetEngineBuilderInitializedInfo();
        logInfo.creationSuccessful = false;
        try {
            logInfo.author = CronetLogger.CronetEngineBuilderInitializedInfo.Author.IMPL;
            logInfo.uid = Process.myUid();
            logInfo.implVersion = new CronetLogger.CronetVersion(ImplVersion.getCronetVersion());
            logInfo.source = cronetSource;
            logInfo.apiVersion = new CronetLogger.CronetVersion(VersionSafeCallbacks.ApiVersion.getCronetVersion());
            logInfo.cronetInitializationRef = this.getLogCronetInitializationRef();
            logInfo.creationSuccessful = successful;
        }
        finally {
            logInfo.engineBuilderCreatedLatencyMillis = (int)(SystemClock.uptimeMillis() - startUptimeMillis);
            this.mLogger.logCronetEngineBuilderInitializedInfo(logInfo);
        }
    }

    private static String validateHostNameForPinningAndConvert(String hostName) throws IllegalArgumentException {
        if (INVALID_PKP_HOST_NAME.matcher(hostName).matches()) {
            throw new IllegalArgumentException("Hostname " + hostName + " is illegal. A hostname should not consist of digits and/or dots only.");
        }
        if (hostName.length() > 255) {
            throw new IllegalArgumentException("Hostname " + hostName + " is too long. The name of the host does not comply with RFC 1122 and RFC 1123.");
        }
        try {
            return IDN.toASCII(hostName, 2);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Hostname " + hostName + " is illegal. The name of the host does not comply with RFC 1122 and RFC 1123.");
        }
    }

    public String getDefaultUserAgent() {
        return UserAgent.from(this.mApplicationContext);
    }

    public CronetEngineBuilderImpl setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
        return this;
    }

    @VisibleForTesting
    String getUserAgent() {
        return this.mUserAgent;
    }

    public CronetEngineBuilderImpl setStoragePath(String value) {
        if (!new File(value).isDirectory()) {
            throw new IllegalArgumentException("Storage path must be set to existing directory");
        }
        this.mStoragePath = value;
        return this;
    }

    @VisibleForTesting
    String storagePath() {
        return this.mStoragePath;
    }

    public CronetEngineBuilderImpl setLibraryLoader(CronetEngine.Builder.LibraryLoader loader) {
        return this;
    }

    VersionSafeCallbacks.LibraryLoader libraryLoader() {
        return null;
    }

    public CronetEngineBuilderImpl enableQuic(boolean value) {
        this.mQuicEnabled = value;
        return this;
    }

    @VisibleForTesting
    boolean quicEnabled() {
        return this.mQuicEnabled;
    }

    String getDefaultQuicUserAgentId() {
        return this.mQuicEnabled ? UserAgent.getQuicUserAgentIdFrom(this.mApplicationContext) : "";
    }

    public CronetEngineBuilderImpl enableHttp2(boolean value) {
        this.mHttp2Enabled = value;
        return this;
    }

    @VisibleForTesting
    boolean http2Enabled() {
        return this.mHttp2Enabled;
    }

    public CronetEngineBuilderImpl enableSdch(boolean value) {
        return this;
    }

    public CronetEngineBuilderImpl enableBrotli(boolean value) {
        this.mBrotiEnabled = value;
        return this;
    }

    @VisibleForTesting
    boolean brotliEnabled() {
        return this.mBrotiEnabled;
    }

    public CronetEngineBuilderImpl enableHttpCache(int cacheMode, long maxSize) {
        HttpCacheMode cacheModeEnum = HttpCacheMode.fromPublicBuilderCacheMode(cacheMode);
        if (cacheModeEnum.getType() == 1 && this.storagePath() == null) {
            throw new IllegalArgumentException("Storage path must be set");
        }
        this.mHttpCacheMode = cacheModeEnum;
        this.mHttpCacheMaxSize = maxSize;
        return this;
    }

    boolean cacheDisabled() {
        return !this.mHttpCacheMode.isContentCacheEnabled();
    }

    long httpCacheMaxSize() {
        return this.mHttpCacheMaxSize;
    }

    @VisibleForTesting
    int httpCacheMode() {
        return this.mHttpCacheMode.getType();
    }

    int publicBuilderHttpCacheMode() {
        return this.mHttpCacheMode.toPublicBuilderCacheMode();
    }

    public CronetEngineBuilderImpl addQuicHint(String host, int port, int alternatePort) {
        if (host.contains("/")) {
            throw new IllegalArgumentException("Illegal QUIC Hint Host: " + host);
        }
        this.mQuicHints.add(new QuicHint(host, port, alternatePort));
        return this;
    }

    List<QuicHint> quicHints() {
        return this.mQuicHints;
    }

    public CronetEngineBuilderImpl addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
        Objects.requireNonNull(hostName, "The hostname cannot be null.");
        Objects.requireNonNull(pinsSha256, "The set of SHA256 pins cannot be null.");
        Objects.requireNonNull(expirationDate, "The pin expiration date cannot be null.");
        String idnHostName = CronetEngineBuilderImpl.validateHostNameForPinningAndConvert(hostName);
        HashMap<String, byte[]> hashes = new HashMap<String, byte[]>();
        for (byte[] pinSha256 : pinsSha256) {
            if (pinSha256 == null || pinSha256.length != 32) {
                throw new IllegalArgumentException("Public key pin is invalid");
            }
            hashes.put(Base64.encodeToString((byte[])pinSha256, (int)0), pinSha256);
        }
        this.mPkps.add(new Pkp(idnHostName, (byte[][])hashes.values().toArray((T[])new byte[hashes.size()][]), includeSubdomains, expirationDate));
        return this;
    }

    List<Pkp> publicKeyPins() {
        return this.mPkps;
    }

    public CronetEngineBuilderImpl enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
        this.mPublicKeyPinningBypassForLocalTrustAnchorsEnabled = value;
        return this;
    }

    @VisibleForTesting
    boolean publicKeyPinningBypassForLocalTrustAnchorsEnabled() {
        return this.mPublicKeyPinningBypassForLocalTrustAnchorsEnabled;
    }

    public CronetEngineBuilderImpl setExperimentalOptions(String options) {
        this.mExperimentalOptions = options;
        return this;
    }

    public String experimentalOptions() {
        return this.mExperimentalOptions;
    }

    public CronetEngineBuilderImpl setMockCertVerifierForTesting(long mockCertVerifier) {
        this.mMockCertVerifier = mockCertVerifier;
        return this;
    }

    long mockCertVerifier() {
        return this.mMockCertVerifier;
    }

    @VisibleForTesting
    boolean networkQualityEstimatorEnabled() {
        return this.mNetworkQualityEstimatorEnabled;
    }

    public CronetEngineBuilderImpl enableNetworkQualityEstimator(boolean value) {
        this.mNetworkQualityEstimatorEnabled = value;
        return this;
    }

    public CronetEngineBuilderImpl setThreadPriority(int priority) {
        return this;
    }

    public CronetEngineBuilderImpl setProxyOptions(@Nullable ProxyOptions proxyOptions) {
        if (proxyOptions != null) {
            this.mProxyOptions = new VersionSafeProxyOptions(proxyOptions);
        }
        return this;
    }

    @Nullable
    VersionSafeProxyOptions getProxyOptions() {
        return this.mProxyOptions;
    }

    public Set<Integer> getSupportedConfigOptions() {
        HashSet<Integer> supportedConfigOptions = new HashSet<Integer>();
        supportedConfigOptions.add(4);
        return Collections.unmodifiableSet(supportedConfigOptions);
    }

    protected long getLogCronetInitializationRef() {
        return 0L;
    }

    Context getContext() {
        return this.mApplicationContext;
    }

    CronetLogger.CronetEngineBuilderInfo toLoggerInfo() {
        return new CronetLogger.CronetEngineBuilderInfo(this.publicKeyPinningBypassForLocalTrustAnchorsEnabled(), this.getUserAgent(), this.storagePath(), this.quicEnabled(), this.http2Enabled(), this.brotliEnabled(), this.publicBuilderHttpCacheMode(), this.experimentalOptions(), this.networkQualityEstimatorEnabled(), 0, this.getLogCronetInitializationRef());
    }

    @VisibleForTesting
    static enum HttpCacheMode {
        DISABLED(0, false),
        DISK(1, true),
        DISK_NO_HTTP(1, false),
        MEMORY(2, true);

        private final int mType;
        private final boolean mContentCacheEnabled;

        private HttpCacheMode(int type, boolean contentCacheEnabled) {
            this.mContentCacheEnabled = contentCacheEnabled;
            this.mType = type;
        }

        @VisibleForTesting
        static HttpCacheMode fromPublicBuilderCacheMode(int cacheMode) {
            switch (cacheMode) {
                case 0: {
                    return DISABLED;
                }
                case 2: {
                    return DISK_NO_HTTP;
                }
                case 3: {
                    return DISK;
                }
                case 1: {
                    return MEMORY;
                }
            }
            throw new IllegalArgumentException("Unknown public builder cache mode");
        }

        int getType() {
            return this.mType;
        }

        boolean isContentCacheEnabled() {
            return this.mContentCacheEnabled;
        }

        int toPublicBuilderCacheMode() {
            switch (this.ordinal()) {
                case 0: {
                    return 0;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 3: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Unknown internal builder cache mode");
        }
    }

    public static class QuicHint {
        final String mHost;
        final int mPort;
        final int mAlternatePort;

        QuicHint(String host, int port, int alternatePort) {
            this.mHost = host;
            this.mPort = port;
            this.mAlternatePort = alternatePort;
        }
    }

    public static class Pkp {
        final String mHost;
        final byte[][] mHashes;
        final boolean mIncludeSubdomains;
        final Date mExpirationDate;

        Pkp(String host, byte[][] hashes, boolean includeSubdomains, Date expirationDate) {
            this.mHost = host;
            this.mHashes = hashes;
            this.mIncludeSubdomains = includeSubdomains;
            this.mExpirationDate = expirationDate;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpCacheSetting {
    }
}

