/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.chromium.base.metrics.ScopedSysTraceEvent;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.chromium.net.impl.JavaUrlRequestUtils;
import org.chromium.net.impl.VersionSafeCallbacks;

public abstract class JavaUploadDataSinkBase
extends UploadDataSink {
    public static final int DEFAULT_UPLOAD_BUFFER_SIZE = 8192;
    private final AtomicInteger mSinkState = new AtomicInteger(3);
    private final Executor mUserUploadExecutor;
    private final Executor mExecutor;
    private final VersionSafeCallbacks.UploadDataProviderWrapper mUploadProvider;
    private ByteBuffer mBuffer;
    private long mTotalBytes;
    private long mWrittenBytes;
    private int mReadCount;

    public JavaUploadDataSinkBase(final Executor userExecutor, Executor executor, UploadDataProvider provider) {
        this.mUserUploadExecutor = new Executor(){
            final /* synthetic */ JavaUploadDataSinkBase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute(Runnable runnable) {
                try {
                    userExecutor.execute(runnable);
                }
                catch (RejectedExecutionException e) {
                    this.this$0.processUploadError(e);
                }
            }
        };
        this.mExecutor = executor;
        this.mUploadProvider = new VersionSafeCallbacks.UploadDataProviderWrapper(provider);
    }

    private void startRead() {
        this.executeOnExecutor(this.getErrorSettingRunnable(() -> {
            this.initializeRead();
            this.mSinkState.set(0);
            this.readFromProvider();
        }), "startRead");
    }

    private void readFromProvider() {
        this.executeOnUploadExecutor(() -> {
            this.mUploadProvider.read(this, this.mBuffer);
            this.mExecutor.execute(() -> ++this.mReadCount);
        }, "readFromProvider");
    }

    private void executeOnExecutor(Runnable runnable, String name) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped((String)("JavaUploadDataSinkBase#executeOnExecutor " + name));){
            this.mExecutor.execute(() -> {
                try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped((String)("JavaUploadDataSinkBase#executeOnExecutor " + name + " running callback"));){
                    runnable.run();
                }
            });
        }
    }

    private void executeOnUploadExecutor(JavaUrlRequestUtils.CheckedRunnable runnable, String name) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped((String)("Cronet JavaUploadDataSinkBase#executeOnUploadExecutor " + name));){
            this.mUserUploadExecutor.execute(() -> {
                try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped((String)("Cronet JavaUploadDataSinkBase#executeOnUploadExecutor " + name + " running callback"));){
                    this.getUploadErrorSettingRunnable(runnable).run();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.processUploadError(e);
        }
    }

    public void onReadSucceeded(boolean finalChunk) {
        if (!this.mSinkState.compareAndSet(0, 2)) {
            throw new IllegalStateException("onReadSucceeded() called when not awaiting a read result; in state: " + this.mSinkState.get());
        }
        JavaUrlRequestUtils.CheckedRunnable checkedRunnable = () -> {
            this.mBuffer.flip();
            if (this.mTotalBytes != -1L && this.mTotalBytes - this.mWrittenBytes < (long)this.mBuffer.remaining()) {
                String msg = String.format(Locale.getDefault(), "Read upload data length %d exceeds expected length %d", this.mWrittenBytes + (long)this.mBuffer.remaining(), this.mTotalBytes);
                this.processUploadError(new IllegalArgumentException(msg));
                return;
            }
            if (this.mBuffer.remaining() == 0 && !finalChunk) {
                this.processUploadError(new IllegalStateException("Bytes read can't be zero except for last chunk!"));
                return;
            }
            this.mWrittenBytes += (long)this.processSuccessfulRead(this.mBuffer);
            if (this.mWrittenBytes < this.mTotalBytes || this.mTotalBytes == -1L && !finalChunk) {
                this.mBuffer.clear();
                this.mSinkState.set(0);
                this.readFromProvider();
            } else if (this.mTotalBytes == -1L) {
                this.finish();
            } else if (this.mTotalBytes == this.mWrittenBytes) {
                this.finish();
            } else {
                String msg = String.format(Locale.getDefault(), "Read upload data length %d exceeds expected length %d", this.mWrittenBytes, this.mTotalBytes);
                this.processUploadError(new IllegalArgumentException(msg));
            }
        };
        this.executeOnExecutor(this.getErrorSettingRunnable(checkedRunnable), "onReadSucceeded");
    }

    public void onRewindSucceeded() {
        if (!this.mSinkState.compareAndSet(1, 2)) {
            throw new IllegalStateException("onRewindSucceeded() called when not awaiting a rewind; in state: " + this.mSinkState.get());
        }
        this.startRead();
    }

    public void onReadError(Exception exception) {
        this.processUploadError(exception);
    }

    public void onRewindError(Exception exception) {
        this.processUploadError(exception);
    }

    public void start(boolean firstTime) {
        this.executeOnUploadExecutor(() -> {
            this.mTotalBytes = this.mUploadProvider.getLength();
            if (this.mTotalBytes == 0L) {
                this.finish();
            } else {
                this.mBuffer = this.mTotalBytes > 0L && this.mTotalBytes < 8192L ? ByteBuffer.allocateDirect((int)this.mTotalBytes + 1) : ByteBuffer.allocateDirect(8192);
                this.initializeStart(this.mTotalBytes);
                if (firstTime) {
                    this.startRead();
                } else {
                    this.mSinkState.set(1);
                    this.mUploadProvider.rewind(this);
                }
            }
        }, "start");
    }

    int getReadCount() {
        return this.mReadCount;
    }

    protected abstract Runnable getErrorSettingRunnable(JavaUrlRequestUtils.CheckedRunnable var1);

    protected abstract Runnable getUploadErrorSettingRunnable(JavaUrlRequestUtils.CheckedRunnable var1);

    protected abstract void processUploadError(Throwable var1);

    protected abstract int processSuccessfulRead(ByteBuffer var1) throws IOException;

    protected abstract void finish() throws IOException;

    protected abstract void initializeRead() throws IOException;

    protected abstract void initializeStart(long var1);

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SinkState {
        public static final int AWAITING_READ_RESULT = 0;
        public static final int AWAITING_REWIND_RESULT = 1;
        public static final int UPLOADING = 2;
        public static final int NOT_STARTED = 3;
    }
}

