/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import java.util.concurrent.atomic.AtomicInteger;

public final class RefCountDelegate {
    private final AtomicInteger mCount = new AtomicInteger(1);
    private final Runnable mDelegate;

    public RefCountDelegate(Runnable delegate) {
        this.mDelegate = delegate;
    }

    public void increment() {
        int updated_count = this.mCount.incrementAndGet();
        assert (updated_count > 1) : "increment() called on a RefCountDelegate with count < 1";
    }

    public void decrement() {
        int updated_count = this.mCount.decrementAndGet();
        assert (updated_count >= 0) : "decrement() called on a RefCountDelegate with count < 1";
        if (updated_count == 0) {
            this.mDelegate.run();
        }
    }
}

