/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.chromium.net.Proxy;
import org.chromium.net.impl.VersionSafeCallbacks;

final class VersionSafeProxyCallback {
    private static final int PROXY_CALLBACK_API_LEVEL = 38;
    @NonNull
    private final Proxy.Callback mBackend;

    private boolean apiContainsProxyCallbackClass() {
        return VersionSafeCallbacks.ApiVersion.getMaximumAvailableApiLevel() >= 38;
    }

    VersionSafeProxyCallback(@NonNull Proxy.Callback backend) {
        if (!this.apiContainsProxyCallbackClass()) {
            throw new AssertionError((Object)String.format("This should not have been created: the Cronet API being used has an ApiLevel of %s, but ProxyCallback was added in ApiLevel %s", VersionSafeCallbacks.ApiVersion.getMaximumAvailableApiLevel(), 38));
        }
        this.mBackend = Objects.requireNonNull(backend);
    }

    @Nullable
    List<Map.Entry<String, String>> onBeforeTunnelRequest() {
        return this.mBackend.onBeforeTunnelRequest();
    }

    boolean onTunnelHeadersReceived(@NonNull List<Map.Entry<String, String>> responseHeaders, int statusCode) {
        return this.mBackend.onTunnelHeadersReceived(responseHeaders, statusCode);
    }
}

