/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.chromium.net.impl.VersionSafeCallbacks;
import org.chromium.net.impl.VersionSafeProxyCallback;
import org.chromium.net.impl.proto.Proxy;
import org.chromium.net.impl.proto.ProxyOptions;
import org.chromium.net.impl.proto.ProxyScheme;

final class VersionSafeProxyOptions {
    private static final int SET_PROXY_OPTIONS_API_LEVEL = 38;
    @NonNull
    private final org.chromium.net.ProxyOptions mBackend;

    private static boolean apiContainsProxyOptionsClass() {
        return VersionSafeCallbacks.ApiVersion.getMaximumAvailableApiLevel() >= 38;
    }

    VersionSafeProxyOptions(@NonNull org.chromium.net.ProxyOptions backend) {
        if (!VersionSafeProxyOptions.apiContainsProxyOptionsClass()) {
            throw new AssertionError((Object)String.format("This should have not been created: the Cronet API being used has an ApiLevel of %s, but setProxyOptions was added in ApiLevel %s", VersionSafeCallbacks.ApiVersion.getMaximumAvailableApiLevel(), 38));
        }
        this.mBackend = Objects.requireNonNull(backend);
        if (this.mBackend.getProxyList().isEmpty()) {
            throw new AssertionError((Object)"The list of proxies should never be empty, this is checked in the API layer");
        }
    }

    @NonNull
    List<VersionSafeProxyCallback> createProxyCallbackList() {
        ArrayList<VersionSafeProxyCallback> proxyCallbacks = new ArrayList<VersionSafeProxyCallback>();
        for (org.chromium.net.Proxy proxy : this.mBackend.getProxyList()) {
            boolean isDirect = proxy == null;
            proxyCallbacks.add(isDirect ? null : new VersionSafeProxyCallback(proxy.getCallback()));
        }
        return Collections.unmodifiableList(proxyCallbacks);
    }

    @NonNull
    ProxyOptions createProxyOptionsProto() {
        ProxyOptions.Builder proxyOptionsProtoBuilder = ProxyOptions.newBuilder();
        for (org.chromium.net.Proxy proxy : this.mBackend.getProxyList()) {
            Proxy.Builder proxyProtoBuilder = Proxy.newBuilder();
            if (proxy == null) {
                proxyProtoBuilder.setScheme(ProxyScheme.DIRECT);
            } else {
                proxyProtoBuilder.setHost(proxy.getHost());
                proxyProtoBuilder.setPort(proxy.getPort());
                int scheme = proxy.getScheme();
                if (scheme == 0) {
                    proxyProtoBuilder.setScheme(ProxyScheme.HTTP);
                } else if (scheme == 1) {
                    proxyProtoBuilder.setScheme(ProxyScheme.HTTPS);
                } else {
                    throw new AssertionError((Object)String.format("Unknown Proxy.Scheme: %s. This should have been caught by the API layer", scheme));
                }
            }
            proxyOptionsProtoBuilder.addProxies((Proxy)proxyProtoBuilder.build());
        }
        return (ProxyOptions)proxyOptionsProtoBuilder.build();
    }
}

