/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.os.UserManager;
import android.provider.MediaStore;
import android.view.Display;
import android.view.View;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.core.os.BuildCompat;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.ContextUtils;

public class ApiCompatibilityUtils {
    private static final String TAG = "ApiCompatUtil";

    private ApiCompatibilityUtils() {
    }

    @NonNull
    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    @NonNull
    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static byte[] getBytesUtf8(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static Intent getNotificationSettingsIntent() {
        Intent intent = new Intent();
        String packageName = ContextUtils.getApplicationContext().getPackageName();
        if (Build.VERSION.SDK_INT >= 26) {
            ApisO.initNotificationSettingsIntent(intent, packageName);
        } else {
            intent.setAction("android.settings.ACTION_APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", packageName);
            intent.putExtra("app_uid", ContextUtils.getApplicationContext().getApplicationInfo().uid);
        }
        return intent;
    }

    public static Drawable getDrawable(Resources res, int id2) throws Resources.NotFoundException {
        return ApiCompatibilityUtils.getDrawableForDensity(res, id2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawableForDensity(Resources res, int id2, int density) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (density == 0) {
                Drawable drawable2 = res.getDrawable(id2, null);
                return drawable2;
            }
            Drawable drawable3 = res.getDrawableForDensity(id2, density, null);
            return drawable3;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    public static int getColor(Resources res, int id2) throws Resources.NotFoundException {
        return res.getColor(id2);
    }

    public static void setTextAppearance(TextView view, int id2) {
        view.setTextAppearance(view.getContext(), id2);
    }

    public static boolean isDemoUser() {
        return Build.VERSION.SDK_INT >= 25 && ApisNMR1.isDemoUser();
    }

    public static int checkPermission(Context context, String permission, int pid, int uid) {
        try {
            return context.checkPermission(permission, pid, uid);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public static boolean isInMultiWindowMode(Activity activity) {
        return activity.isInMultiWindowMode();
    }

    @NonNull
    public static List<Integer> getTargetableDisplayIds(Activity activity) {
        if (Build.VERSION.SDK_INT >= 29) {
            return ApisQ.getTargetableDisplayIds(activity);
        }
        return new ArrayList<Integer>();
    }

    public static void disableSmartSelectionTextClassifier(TextView textView) {
        if (Build.VERSION.SDK_INT >= 26) {
            ApisO.disableSmartSelectionTextClassifier(textView);
        }
    }

    public static Bundle createLaunchDisplayIdActivityOptions(int displayId) {
        if (Build.VERSION.SDK_INT >= 26) {
            return ApisO.createLaunchDisplayIdActivityOptions(displayId);
        }
        return null;
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static void setActivityOptionsBackgroundActivityStartMode(@NonNull ActivityOptions options) {
        if (!BuildCompat.isAtLeastU()) {
            return;
        }
        options.setPendingIntentBackgroundActivityStartMode(1);
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static void clearHandwritingBoundsOffsetBottom(View view) {
        if (!BuildCompat.isAtLeastU()) {
            return;
        }
        try {
            float offsetTop = ((Float)View.class.getMethod("getHandwritingBoundsOffsetTop", new Class[0]).invoke((Object)view, new Object[0])).floatValue();
            float offsetLeft = ((Float)View.class.getMethod("getHandwritingBoundsOffsetLeft", new Class[0]).invoke((Object)view, new Object[0])).floatValue();
            float offsetRight = ((Float)View.class.getMethod("getHandwritingBoundsOffsetRight", new Class[0]).invoke((Object)view, new Object[0])).floatValue();
            Method setHandwritingBoundsOffsets = View.class.getMethod("setHandwritingBoundsOffsets", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            setHandwritingBoundsOffsets.invoke((Object)view, Float.valueOf(offsetLeft), Float.valueOf(offsetTop), Float.valueOf(offsetRight), 0);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    static String getProcessName() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ApisP.getProcessName();
        }
        try {
            Class<?> activityThreadClazz = Class.forName("android.app.ActivityThread");
            return (String)activityThreadClazz.getMethod("currentProcessName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isRunningInUserTestHarness() {
        if (Build.VERSION.SDK_INT >= 29) {
            return ApisQ.isRunningInUserTestHarness();
        }
        return false;
    }

    public static Bitmap getBitmapByUri(ContentResolver cr, Uri uri) throws IOException {
        if (Build.VERSION.SDK_INT >= 28) {
            return ApisP.getBitmapByUri(cr, uri);
        }
        return MediaStore.Images.Media.getBitmap((ContentResolver)cr, (Uri)uri);
    }

    @RequiresApi(value=26)
    private static class ApisO {
        private ApisO() {
        }

        static void initNotificationSettingsIntent(Intent intent, String packageName) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", packageName);
        }

        static void disableSmartSelectionTextClassifier(TextView textView) {
            textView.setTextClassifier(TextClassifier.NO_OP);
        }

        static Bundle createLaunchDisplayIdActivityOptions(int displayId) {
            ActivityOptions options = ActivityOptions.makeBasic();
            options.setLaunchDisplayId(displayId);
            return options.toBundle();
        }
    }

    @RequiresApi(value=25)
    private static class ApisNMR1 {
        private ApisNMR1() {
        }

        static boolean isDemoUser() {
            UserManager userManager = (UserManager)ContextUtils.getApplicationContext().getSystemService("user");
            return userManager.isDemoUser();
        }
    }

    @RequiresApi(value=29)
    private static class ApisQ {
        private ApisQ() {
        }

        static boolean isRunningInUserTestHarness() {
            return ActivityManager.isRunningInUserTestHarness();
        }

        static List<Integer> getTargetableDisplayIds(@Nullable Activity activity) {
            ArrayList<Integer> displayList = new ArrayList<Integer>();
            if (activity == null) {
                return displayList;
            }
            DisplayManager displayManager = (DisplayManager)activity.getSystemService("display");
            if (displayManager == null) {
                return displayList;
            }
            Display[] displays = displayManager.getDisplays();
            ActivityManager am = (ActivityManager)activity.getSystemService("activity");
            for (Display display : displays) {
                if (display.getState() != 2 || !am.isActivityStartAllowedOnDisplay((Context)activity, display.getDisplayId(), new Intent((Context)activity, activity.getClass()))) continue;
                displayList.add(display.getDisplayId());
            }
            return displayList;
        }
    }

    @RequiresApi(value=28)
    private static class ApisP {
        private ApisP() {
        }

        static String getProcessName() {
            return Application.getProcessName();
        }

        static Bitmap getBitmapByUri(ContentResolver cr, Uri uri) throws IOException {
            return ImageDecoder.decodeBitmap((ImageDecoder.Source)ImageDecoder.createSource((ContentResolver)cr, (Uri)uri));
        }
    }
}

