/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.text.TextUtils;
import java.io.IOException;
import org.chromium.base.BundleUtils;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class ApkAssets {
    private static final String TAG = "ApkAssets";
    private static String sLastError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static long[] open(String fileName, String splitName) {
        sLastError = null;
        AssetFileDescriptor afd = null;
        try {
            Context context = ContextUtils.getApplicationContext();
            if (!TextUtils.isEmpty((CharSequence)splitName) && BundleUtils.isIsolatedSplitInstalled(splitName)) {
                context = BundleUtils.createIsolatedSplitContext(context, splitName);
            }
            AssetManager manager = context.getAssets();
            afd = manager.openNonAssetFd(fileName);
            long[] lArray = new long[]{afd.getParcelFileDescriptor().detachFd(), afd.getStartOffset(), afd.getLength()};
            return lArray;
        }
        catch (IOException e) {
            sLastError = "Error while loading asset " + fileName + " from " + splitName + ": " + e;
            if (!e.getMessage().equals("") && !e.getMessage().equals(fileName)) {
                Log.e(TAG, sLastError);
            }
            long[] lArray = new long[]{-1L, -1L, -1L};
            return lArray;
        }
        finally {
            try {
                if (afd != null) {
                    afd.close();
                }
            }
            catch (IOException e2) {
                Log.e(TAG, "Unable to close AssetFileDescriptor", e2);
            }
        }
    }

    @CalledByNative
    private static String takeLastErrorString() {
        String rv = sLastError;
        sLastError = null;
        return rv;
    }
}

